/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.Project;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@Entity
@Table(name="audio_device", schema="public")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="audio.device")
@PluralResourceKey(value="audio.devices")
@PreferredDisplayOrder(value="audioDeviceId,name,regex,isPlayback,*,projects")
@XmlType(name="audio_device")
public class AudioDevice
implements Serializable {
    public static final String PLAYBACK_PREFIX = "Playback: ";
    public static final String RECORDING_PREFIX = "Recording: ";
    public static final String REGEX_STR = "(regex)";
    private int audioDeviceId;
    private String name;
    private boolean playback;
    private boolean regex;
    private String jextension;
    private Set<Project> projects = new HashSet<Project>(0);

    @Id
    @Column(name="audio_device_id", unique=true, nullable=false, updatable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    public int getAudioDeviceId() {
        return this.audioDeviceId;
    }

    public void setAudioDeviceId(int audioDeviceId) {
        this.audioDeviceId = audioDeviceId;
    }

    @Column(name="name", length=500, updatable=false)
    @ResourceKey(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="is_playback", nullable=false, updatable=false)
    @ResourceKey(value="playback")
    public boolean isPlayback() {
        return this.playback;
    }

    public void setPlayback(boolean playback) {
        this.playback = playback;
    }

    @Column(name="regex", nullable=false, updatable=false)
    @ResourceKey(value="regular_expression")
    public boolean isRegex() {
        return this.regex;
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    @Column(name="jextension", length=20, updatable=false)
    @ResourceKey(value="audio.javasound.extension")
    public String getJextension() {
        return this.jextension;
    }

    public void setJextension(String jextension) {
        this.jextension = jextension;
    }

    @ManyToMany(fetch=FetchType.LAZY, mappedBy="audioDevices")
    @ResourceKey(value="projects")
    @XmlTransient
    public Set<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<Project> projects) {
        this.projects = projects;
    }

    public String toString() {
        String jExt;
        StringBuffer sb = new StringBuffer();
        if (this.isPlayback()) {
            sb.append(PLAYBACK_PREFIX);
        } else {
            sb.append(RECORDING_PREFIX);
        }
        sb.append(this.name);
        if (this.regex) {
            sb.append(",");
            sb.append(REGEX_STR);
        }
        if ((jExt = this.getJextension()) != null && !jExt.equals("")) {
            sb.append(", Java-Ext: " + jExt);
        }
        return sb.toString();
    }
}

