/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.LinkID;
import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.dom.Temporal;
import ipsk.db.speech.Account;
import ipsk.db.speech.Organisation;
import ipsk.db.speech.XMLDateAdapter;
import ipsk.db.speech.XMLIntegerAdapter;
import ipsk.persistence.ImmutibilityProvider;
import ipsk.util.EnumResourceKeys;
import ipsk.util.MemberResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import ipsk.util.annotations.TextAreaView;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@Entity
@Table(name="person")
@Inheritance(strategy=InheritanceType.JOINED)
@PreferredDisplayOrder(value="personId,name,forename,address,sex,email,dateOfBirth,birthPlace,profession,*,organisations,account,comments")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
public class Person
implements Serializable,
ImmutibilityProvider {
    protected Integer personId;
    protected String uuid;
    private String code;
    private String name;
    private String forename;
    private Sex sex;
    private Date dateOfBirth;
    private Integer birthYear;
    private Date registered = new Date();
    private String address;
    private String street;
    private String zipcode;
    private String city;
    private String country;
    private String birthPlace;
    private String profession;
    private String comments;
    private Account account;
    private Set<Organisation> organisations = new HashSet<Organisation>(0);
    private String email;

    public Person() {
    }

    public Person(int personId) {
        this();
        this.personId = personId;
    }

    public Person(int personId, String code, String name, String forename, Sex sex, Date dateOfBirth, Date registered, String address, String birthPlace, String profession, String comments, Account account) {
        this.personId = personId;
        this.code = code;
        this.name = name;
        this.forename = forename;
        this.sex = sex;
        this.dateOfBirth = dateOfBirth;
        this.registered = registered;
        this.address = address;
        this.birthPlace = birthPlace;
        this.profession = profession;
        this.comments = comments;
        this.account = account;
    }

    @Id
    @Column(name="person_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @LinkID
    @XmlID
    @XmlJavaTypeAdapter(value=XMLIntegerAdapter.class)
    @ResourceKey(value="id")
    public Integer getPersonId() {
        return this.personId;
    }

    public void setPersonId(Integer personId) {
        this.personId = personId;
    }

    @Column(length=36, unique=true, nullable=true)
    @ResourceKey(value="uuid")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Column(name="code", length=10)
    @ResourceKey(value="code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Column(name="name", length=100)
    @ResourceKey(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="forename", length=100)
    @ResourceKey(value="forename")
    public String getForename() {
        return this.forename;
    }

    public void setForename(String forename) {
        this.forename = forename;
    }

    @Column(name="sex", length=10)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="sex")
    public Sex getSex() {
        return this.sex;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    @Temporal(value=TemporalType.DATE)
    @ipsk.beans.dom.Temporal(type=Temporal.Type.DATE)
    @XmlElement
    @XmlJavaTypeAdapter(value=XMLDateAdapter.class)
    @Column(name="date_of_birth", length=4)
    @ResourceKey(value="date_of_birth")
    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    @Column(name="year_of_birth")
    @ResourceKey(value="year_of_birth")
    public Integer getBirthYear() {
        return this.birthYear;
    }

    public void setBirthYear(Integer birthYear) {
        this.birthYear = birthYear;
    }

    @Column(name="address", length=1000)
    @ResourceKey(value="address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name="birth_place", length=100)
    @ResourceKey(value="birthplace")
    public String getBirthPlace() {
        return this.birthPlace;
    }

    public void setBirthPlace(String birthPlace) {
        this.birthPlace = birthPlace;
    }

    @Column(name="profession", length=100)
    @ResourceKey(value="profession")
    public String getProfession() {
        return this.profession;
    }

    public void setProfession(String profession) {
        this.profession = profession;
    }

    @Column(name="comments")
    @ResourceKey(value="comments")
    @TextAreaView
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Column
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="registered")
    public Date getRegistered() {
        return this.registered;
    }

    public void setRegistered(Date registered) {
        this.registered = registered;
    }

    @OneToOne(mappedBy="person")
    @ResourceKey(value="account")
    @XmlTransient
    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    @ManyToMany(mappedBy="persons", fetch=FetchType.LAZY)
    @ResourceKey(value="organisations")
    @XmlTransient
    public Set<Organisation> getOrganisations() {
        return this.organisations;
    }

    public void setOrganisations(Set<Organisation> organisations) {
        this.organisations = organisations;
    }

    private String toWelcomeName() {
        if (this.name != null && !"".equals(this.name) && this.forename != null && !"".equals(this.forename)) {
            return this.name + " " + this.forename;
        }
        if (this.name != null && !"".equals(this.name)) {
            return this.name;
        }
        if (this.forename != null && !"".equals(this.forename)) {
            return this.forename;
        }
        return null;
    }

    public String toString() {
        String welcomeName = this.toWelcomeName();
        if (welcomeName != null) {
            return welcomeName;
        }
        return "ID: " + Integer.toString(this.personId);
    }

    @Transient
    public String getWelcomeName() {
        String welcomeName = this.toWelcomeName();
        if (welcomeName != null) {
            return welcomeName;
        }
        return "";
    }

    @Column(length=1000)
    @ResourceKey(value="street")
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    @Column(length=100)
    @ResourceKey(value="zip_code")
    public String getZipcode() {
        return this.zipcode;
    }

    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    @Column(length=100)
    @ResourceKey(value="city")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Column(length=100)
    @ResourceKey(value="country")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Column(length=1000)
    @ResourceKey(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isImmutable() {
        return true;
    }

    public boolean isRemovable() {
        return this.account == null;
    }

    @EnumResourceKeys(memberResourceKeys={@MemberResourceKey(name="MALE", key="male"), @MemberResourceKey(name="FEMALE", key="female"), @MemberResourceKey(name="OTHER", key="other")})
    public static enum Sex {
        MALE,
        FEMALE,
        OTHER;

    }
}

