/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.model.db;

import ips.annot.model.db.Bundle;
import ips.annot.model.db.Item;
import ips.annot.model.db.LevelDefinition;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="level", propOrder={"name", "type", "items"})
public class Level {
    @Id
    @SequenceGenerator(name="keys", sequenceName="KEYS", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="keys")
    @XmlTransient
    private int id;
    @ManyToOne
    private transient Bundle bundle;
    @OneToOne
    private LevelDefinition definition = null;
    @OneToMany(mappedBy="level")
    private List<Item> items = new ArrayList<Item>();

    @XmlTransient
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @XmlTransient
    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    @XmlTransient
    public LevelDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(LevelDefinition definition) {
        this.definition = definition;
    }

    @XmlElement(name="name")
    public String getName() {
        return this.getDefinition().getName();
    }

    public void setName(String name) {
        LevelDefinition ld = this.getDefinition();
        if (ld == null) {
            ld = new LevelDefinition();
            this.setDefinition(ld);
        }
        ld.setName(name);
    }

    @XmlElement(name="type")
    public String getType() {
        return this.getDefinition().getType();
    }

    public void setType(String type) {
        LevelDefinition ld = this.getDefinition();
        if (ld == null) {
            ld = new LevelDefinition();
            this.setDefinition(ld);
        }
        ld.setType(type);
    }

    @XmlElements(value={@XmlElement(name="items")})
    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> elements) {
        this.items = elements;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(String.valueOf(this.getDefinition().getName()) + ": (" + this.items.size() + " items)\n");
        for (Item item : this.items) {
            buffer.append(String.valueOf(item.toString()) + "\n");
        }
        return buffer.toString();
    }
}

