/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.model.db;

import ips.annot.model.db.LevelDefinition;
import ips.annot.model.db.LinkDefinition;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class Schema {
    private Set<LevelDefinition> levelDefinitions = new HashSet<LevelDefinition>();
    private Set<LinkDefinition> constraints = new HashSet<LinkDefinition>();

    public Set<LevelDefinition> getTierDefinitions() {
        return this.levelDefinitions;
    }

    public void setTierDefinitions(Set<LevelDefinition> tierDefinitions) {
        this.levelDefinitions = tierDefinitions;
    }

    public void addLevelDefinition(LevelDefinition tierDefinition) {
        this.levelDefinitions.add(tierDefinition);
    }

    public LevelDefinition getLevelDefinitionByName(String tierName) {
        LevelDefinition tierDefinition2;
        for (LevelDefinition tierDefinition2 : this.levelDefinitions) {
            if (!tierDefinition2.getName().equals(tierName)) continue;
            return tierDefinition2;
        }
        tierDefinition2 = new LevelDefinition();
        tierDefinition2.setName(tierName);
        this.addLevelDefinition(tierDefinition2);
        return tierDefinition2;
    }

    public Set<LinkDefinition> getConstraints() {
        return this.constraints;
    }

    private void setConstraints(Set<LinkDefinition> constraints) {
        this.constraints = constraints;
    }

    public Set<LinkDefinition> getRootTiers() {
        HashSet<LinkDefinition> roots = new HashSet<LinkDefinition>();
        for (LinkDefinition ld : this.getConstraints()) {
            if (!ld.getType().equals("INIT")) continue;
            roots.add(ld);
        }
        return roots;
    }

    public List<LinkDefinition> getSubTiers(LinkDefinition linkDef) {
        Vector<LinkDefinition> subtiers = new Vector<LinkDefinition>();
        for (LinkDefinition ld : this.getConstraints()) {
            if (!linkDef.getSubLevel().equals(ld.getSuperLevel())) continue;
            subtiers.add(ld);
        }
        return subtiers;
    }

    public List getPaths(LinkDefinition current, List<LinkDefinition> lpath) {
        if (this.getSubTiers(current).size() == 0) {
            lpath.add(current);
            return lpath;
        }
        return lpath;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Schema\tTier names: ");
        for (LevelDefinition tierDefinition : this.levelDefinitions) {
            buffer.append(tierDefinition.toString());
            buffer.append(", ");
        }
        buffer.append("Constraints: ");
        for (LinkDefinition constraint : this.constraints) {
            buffer.append(constraint.toString());
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

