/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.view;

import ips.annot.model.db.SegmentItem;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import javax.swing.JComponent;

public class SegmentsViewer
extends JComponent {
    private List<SegmentItem> intervalItems;

    public SegmentsViewer(List<SegmentItem> intervalItems) {
        this.intervalItems = intervalItems;
        this.setLayout(null);
        this.setOpaque(true);
        this.setSize(this.getPreferredSize().width, this.getPreferredSize().height);
    }

    private long totalLength() {
        long begin = 0L;
        SegmentItem lastItem = this.intervalItems.get(this.intervalItems.size() - 1);
        long end = lastItem.getSampleStart() + lastItem.getSampleDur();
        return end - begin;
    }

    @Override
    public void paintComponent(Graphics g) {
        int w = this.getSize().width;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(Color.BLACK);
        int xStep = (int)(this.totalLength() / (long)w);
        int i = 0;
        while (i < this.intervalItems.size()) {
            SegmentItem ii = this.intervalItems.get(i);
            int xl = (int)(ii.getSampleStart() / (long)xStep);
            int xr = (int)((ii.getSampleStart() + ii.getSampleDur()) / (long)xStep);
            String label = ii.getLabelText();
            if (i > 0) {
                g.drawLine(xl, 0, xl, this.getSize().height);
            }
            int midx = xl + (xr - xl) / 2 - 3;
            int midy = this.getSize().height / 2;
            g.drawString(label, midx, midy + 6);
            ++i;
        }
    }

    public List<SegmentItem> getIntervalItems() {
        return this.intervalItems;
    }

    public void setIntervalItems(List<SegmentItem> intervalItems) {
        this.intervalItems = intervalItems;
    }
}

