/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.text;

import ips.annot.io.BundleAnnotationFilePersistor;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.annot.model.db.LevelDefinition;
import ipsk.io.StreamCopy;
import ipsk.text.EncodeException;
import ipsk.text.ParserException;
import ipsk.text.Version;
import ipsk.util.LocalizableMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SingleLevelTextFilePersistor
implements BundleAnnotationFilePersistor {
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private File file;
    private LevelDefinition levelDefinition;
    private Charset charset = Charset.forName("UTF-8");

    @Override
    public boolean isLossless() {
        return false;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public void write(Bundle bundle) throws IOException, EncodeException {
        List<Item> items;
        int itsCnt;
        String levelName;
        Level tier;
        String line = null;
        if (this.levelDefinition != null && (tier = bundle.getTierByName(levelName = this.levelDefinition.getName())) != null && (itsCnt = (items = tier.getItems()).size()) > 0) {
            Map<String, Object> lblMaps;
            int lblCnt;
            if (items.size() > 1) {
                throw new EncodeException("Unable to encode multiple items to one text line");
            }
            Item it = items.get(0);
            if (it != null && (lblCnt = (lblMaps = it.getLabels()).size()) > 0) {
                if (lblCnt > 1) {
                    throw new EncodeException("Unable to encode multiple attributes to one text line");
                }
                if (!lblMaps.containsKey(levelName)) {
                    throw new EncodeException("Encoding failed: attribute name does not match level definition name");
                }
                Object lblVal = lblMaps.get(levelName);
                if (lblVal != null) {
                    if (lblVal instanceof String) {
                        line = (String)lblVal;
                    } else {
                        throw new EncodeException("Encoding failed: Only text can be encoded! (Value is of Java type: '" + lblVal.getClass().getName() + "')");
                    }
                }
            }
        }
        if (line != null) {
            FileOutputStream fos = new FileOutputStream(this.file);
            try (OutputStreamWriter wr = new OutputStreamWriter((OutputStream)fos, this.charset);){
                wr.write(line);
            }
        }
    }

    @Override
    public String getPreferredFileExtension() {
        return "txt";
    }

    @Override
    public Bundle load() throws IOException, ParserException {
        String annoText = StreamCopy.readTextFile((File)this.file, (Charset)this.charset);
        Bundle b = new Bundle();
        Level t = new Level();
        t.setDefinition(this.levelDefinition);
        t.setBundle(b);
        Item it = new Item();
        it.setLabel(this.levelDefinition.getName(), annoText);
        ArrayList<Item> its = new ArrayList<Item>();
        its.add(it);
        t.setItems(its);
        b.getLevels().add(t);
        return b;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public LevelDefinition getLevelDefinition() {
        return this.levelDefinition;
    }

    public void setLevelDefinition(LevelDefinition levelDefinition) {
        this.levelDefinition = levelDefinition;
    }

    public void setLevelDefinitionKeyName(String levelDefinitionKeyName) {
        this.levelDefinition = new LevelDefinition();
        this.levelDefinition.setName(levelDefinitionKeyName);
    }

    public String getServiceImplementationClassname() {
        return this.getClass().getName();
    }

    public LocalizableMessage getTitle() {
        return new LocalizableMessage("Single text line loader/writer");
    }

    public LocalizableMessage getDescription() {
        return new LocalizableMessage("Simple text loader writer.");
    }

    public String getVendor() {
        return "Institut of Phonetics and Speech Processing";
    }

    public Version getSpecificationVersion() {
        return new Version(new int[]{0, 0, 1});
    }

    public Version getImplementationVersion() {
        return new Version(new int[]{0, 0, 1});
    }

    @Override
    public Bundle load(Bundle bundle) throws IOException, ParserException {
        return this.load();
    }

    @Override
    public String getPreferredFilenameSuffix() {
        return null;
    }

    @Override
    public boolean isWritable(Bundle bundle) {
        return true;
    }
}

