/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.view;

import ips.annot.model.db.LevelDefinition;
import ips.annot.view.ColorScheme;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class TierDefinitionViewer
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static int NEUTRAL = 0;
    private static int HILITE = 1;
    private static int DISABLED = 2;
    private static int SELECTED = 3;
    private LevelDefinition tierDefinition;
    private int state;
    private int oldState;
    private Point mousepress;
    private Point mouserelease;
    private Point location;
    private int width;
    private int height;

    public TierDefinitionViewer() {
        this.oldState = this.state = NEUTRAL;
        this.setState(NEUTRAL);
        this.createGUI();
    }

    private void createGUI() {
        this.width = 100;
        this.height = 20;
        this.setSize(this.width, this.height);
        this.setOpaque(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public LevelDefinition getTierDefinition() {
        return this.tierDefinition;
    }

    public void setTierDefinition(LevelDefinition tierDefinition) {
        this.tierDefinition = tierDefinition;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getOldState() {
        return this.oldState;
    }

    public void setOldState(int oldState) {
        this.oldState = oldState;
    }

    public Point getTopMid() {
        int x = this.getLocation().x + this.getWidth() / 2;
        return new Point(x, this.getLocation().y);
    }

    public Point getBottomMid() {
        int x = this.getLocation().x + this.getWidth() / 2;
        return new Point(x, this.getLocation().y + this.getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color bgColor = null;
        Color lineColor = null;
        Color textColor = null;
        if (this.getState() == NEUTRAL) {
            bgColor = ColorScheme.NEUTRAL_BG_COLOR;
            lineColor = ColorScheme.NEUTRAL_LINE_COLOR;
            textColor = ColorScheme.NEUTRAL_TEXT_COLOR;
        } else if (this.getState() == HILITE) {
            bgColor = ColorScheme.HILITE_BG_COLOR;
            lineColor = ColorScheme.HILITE_LINE_COLOR;
            textColor = ColorScheme.HILITE_TEXT_COLOR;
        } else if (this.getState() == SELECTED) {
            bgColor = ColorScheme.SELECTED_BG_COLOR;
            lineColor = ColorScheme.SELECTED_LINE_COLOR;
            textColor = ColorScheme.SELECTED_TEXT_COLOR;
        } else if (this.getState() == DISABLED) {
            bgColor = ColorScheme.DISABLED_BG_COLOR;
            lineColor = ColorScheme.DISABLED_LINE_COLOR;
            textColor = ColorScheme.DISABLED_TEXT_COLOR;
        }
        g.setColor(bgColor);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(lineColor);
        g.drawRect(0, 0, this.width - 1, this.height - 1);
        g.setColor(textColor);
        g.drawString(this.tierDefinition.getName(), 2, 15);
    }

    private void moveViewer(int x, int y) {
        int offset = 1;
        if (this.mousepress.x != x || this.mousepress.y != y) {
            this.repaint(this.location.x, this.location.y, this.width + offset, this.height + offset);
            int translatex = x - this.mousepress.x;
            int translatey = y - this.mousepress.y;
            this.location.translate(translatex, translatey);
            this.setLocation(this.location);
            this.repaint(this.location.x, this.location.y, this.width + offset, this.height + offset);
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        if (this.getState() == NEUTRAL) {
            this.setState(HILITE);
        } else if (this.getState() == HILITE) {
            this.setState(NEUTRAL);
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.setOldState(this.state);
        this.setState(SELECTED);
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.setState(this.oldState);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.mousepress = event.getPoint();
        this.location = this.getLocation();
        this.moveViewer(this.mousepress.x, this.mousepress.y);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.setState(this.oldState);
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.moveViewer(event.getX(), event.getY());
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }
}

