/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.view;

import ips.annot.model.db.EventItem;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.annot.model.db.SegmentItem;
import ips.annot.view.EventItemViewer;
import ips.annot.view.IntervalItemViewer;
import ips.annot.view.ItemViewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TierViewer
extends JPanel {
    private static final int MIN_WIDTH = 400;
    private static final int MIN_HEIGHT = 32;
    private static final int PREF_WIDTH = 1024;
    private static final int PREF_HEIGHT = 64;
    private static final int MAX_WIDTH = 3072;
    private static final int MAX_HEIGHT = 512;
    private static final int LEFT_PADDING = 4;
    private static final int RIGHT_PADDING = 4;
    private static final int TOP_PADDING = 4;
    private static final int BOTTOM_PADDING = 4;
    private int width = 1024;
    private int height = 64;
    private Vector<ItemViewer> itemViewers = new Vector();
    private Level tier;

    public TierViewer(Level tier) {
        this.tier = tier;
        this.createGUI();
    }

    public Vector<ItemViewer> getItemViewers() {
        return this.itemViewers;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(400, 32);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(1024, 64);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(3072, 512);
    }

    private void createGUI() {
        this.setLayout(null);
        this.update();
    }

    /*
     * WARNING - void declaration
     */
    public void update() {
        int widthSum = 0;
        int maxHeight = 0;
        for (Item item : this.tier.getItems()) {
            void var5_6;
            Object object = null;
            if (item instanceof SegmentItem) {
                IntervalItemViewer intervalItemViewer = new IntervalItemViewer((SegmentItem)item);
            } else if (item instanceof EventItem) {
                EventItemViewer eventItemViewer = new EventItemViewer((EventItem)item);
            } else if (item instanceof Item) {
                ItemViewer itemViewer = new ItemViewer(item);
            } else {
                System.out.println("ERROR: other type of viewer: " + object.getClass().getName() + ", " + ((JComponent)object).getHeight());
            }
            if (var5_6.getHeight() > maxHeight) {
                maxHeight = var5_6.getHeight();
            }
            this.itemViewers.add((ItemViewer)var5_6);
            widthSum = widthSum + 4 + var5_6.getWidth();
        }
        this.width = widthSum + 4;
        this.height = 4 + maxHeight + 4;
        this.setSize(this.width, this.height);
        System.out.println(this.tier.getName() + ": (" + this.width + ", " + this.height + "), " + this.itemViewers.size() + " viewers.");
        int x = (this.getSize().width - widthSum) / 2;
        if (x < 0) {
            x = 0;
        }
        for (JComponent jComponent : this.itemViewers) {
            jComponent.setLocation(x, 4);
            this.add(jComponent);
            x = x + jComponent.getWidth() + 4;
        }
        this.repaint();
    }

    public Point getItemViewerLocation(Item item) {
        for (ItemViewer itemViewer : this.itemViewers) {
            if (!itemViewer.getItem().equals(item)) continue;
            return itemViewer.getLocation();
        }
        return null;
    }

    private Point getMidWidthPoint(JComponent component) {
        Point p = component.getLocation();
        int midWidth = component.getWidth() / 2;
        return new Point(p.x + midWidth, p.y);
    }

    private Point getMidHeightPoint(JComponent component) {
        Point p = component.getLocation();
        int midHeight = component.getHeight() / 2;
        return new Point(p.x, p.y + midHeight);
    }

    @Override
    public void paintComponent(Graphics g) {
        Point p0 = this.getMidHeightPoint(this.itemViewers.get(0));
        g.setColor(Color.BLACK);
        for (JComponent jComponent : this.itemViewers) {
            Point p1 = this.getMidHeightPoint(jComponent);
            g.drawLine(p0.x, p0.y, p1.x, p1.y);
            g.drawLine(p0.x, p0.y + 1, p1.x, p1.y + 1);
        }
    }
}

