/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.model;

import ips.annot.model.db.LevelDefinition;

public enum PredefinedLevelDefinition {
    PRT("Prompt", "ITEM"),
    TPL("Template", "ITEM"),
    ORT("Orthography", "ITEM"),
    KAN("Canonic", "ITEM"),
    MAU("MAUS segmented", "SEGMENT");

    private final String value;
    private final String type;
    private final LevelDefinition levelDefinition;

    private PredefinedLevelDefinition(String value, String type) {
        this.value = value;
        this.type = type;
        this.levelDefinition = new LevelDefinition(this);
    }

    public LevelDefinition getLevelDefinition() {
        return this.levelDefinition;
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public String getKeyName() {
        return super.toString();
    }

    public static PredefinedLevelDefinition getByValue(String value) {
        for (PredefinedLevelDefinition pp : PredefinedLevelDefinition.values()) {
            if (!pp.value.equals(value)) continue;
            return pp;
        }
        return null;
    }

    public static void main(String[] args) {
        PredefinedLevelDefinition mausLd = MAU;
        System.out.print(mausLd + " " + mausLd.getKeyName());
    }

    public String getType() {
        return this.type;
    }
}

