/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.model.emu;

import ips.annot.io.BundleAnnotationFilePersistor;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.annot.model.db.LevelDefinition;
import ipsk.io.StreamCopy;
import ipsk.text.EncodeException;
import ipsk.text.ParserException;
import ipsk.text.Version;
import ipsk.util.LocalizableMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

public class EmuBundleAnnotationPersistor
implements BundleAnnotationFilePersistor {
    private File file;
    private static volatile JAXBContext jaxbContext;
    private static volatile Charset cs;
    private static String CS_NAME;

    private synchronized JAXBContext jaxbContext() throws JAXBException {
        if (jaxbContext == null) {
            cs = Charset.forName(CS_NAME);
            HashMap<String, String> jaxbEclipseLinkPropsmap = new HashMap<String, String>();
            jaxbEclipseLinkPropsmap.put("javax.xml.bind.context.factory", "org.eclipse.persistence.jaxb.JAXBContextFactory");
            jaxbContext = JAXBContextFactory.createContext((Class[])new Class[]{Bundle.class}, jaxbEclipseLinkPropsmap);
        }
        return jaxbContext;
    }

    public String getServiceImplementationClassname() {
        return this.getClass().getName();
    }

    public LocalizableMessage getTitle() {
        return new LocalizableMessage("EMU DB annotation loader/writer");
    }

    public LocalizableMessage getDescription() {
        return new LocalizableMessage("Imports/exports bundle annotations in EMU DB JSON format.");
    }

    public String getVendor() {
        return "Institut of Phonetics and Speech Processing";
    }

    public Version getSpecificationVersion() {
        return new Version(new int[]{0, 0, 1});
    }

    public Version getImplementationVersion() {
        return new Version(new int[]{0, 0, 1});
    }

    @Override
    public boolean isLossless() {
        return true;
    }

    private void applyItemIds(Bundle bundle) {
        Integer hstId = bundle.highestID();
        int hId = -1;
        if (hstId != null) {
            hId = hstId;
        }
        List<Level> lvls = bundle.getLevels();
        for (Level lvl : lvls) {
            List<Item> its = lvl.getItems();
            for (Item it : its) {
                Integer itemId = it.getBundleId();
                if (itemId != null) continue;
                it.setBundleId(++hId);
            }
        }
    }

    @Override
    public void write(Bundle bundle) throws IOException, EncodeException {
        Marshaller marshaller;
        this.applyItemIds(bundle);
        try {
            JAXBContext jc = this.jaxbContext();
            marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        }
        catch (JAXBException e) {
            throw new EncodeException((Throwable)e);
        }
        try (PrintWriter ow = new PrintWriter(this.file, CS_NAME);){
            marshaller.marshal((Object)bundle, (Writer)ow);
        }
    }

    @Override
    public Bundle load() throws IOException, ParserException {
        Unmarshaller unmarshaller;
        Bundle b = null;
        try {
            JAXBContext jc = this.jaxbContext();
            unmarshaller = jc.createUnmarshaller();
            unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            unmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
        }
        catch (JAXBException e) {
            throw new ParserException((Throwable)e);
        }
        FileInputStream fis = new FileInputStream(this.file);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, cs);
        StreamSource json = new StreamSource(isr);
        try {
            JAXBElement jb = unmarshaller.unmarshal((Source)json, Bundle.class);
            b = (Bundle)jb.getValue();
            if (b != null) {
                b.applyBundleToLevels();
                b.applyLevelsToItems();
                b.applyItemPositions();
                b.resolveLinkReferences();
            }
        }
        catch (JAXBException e) {
            throw new ParserException((Throwable)e);
        }
        finally {
            if (isr != null) {
                isr.close();
            }
        }
        return b;
    }

    @Override
    public Bundle load(Bundle bundle) throws IOException, ParserException {
        return this.load();
    }

    public static void main(String[] args) {
        Bundle b = new Bundle();
        b.setId(5);
        b.setName("foo");
        b.setAnnotates("foo.wav");
        LevelDefinition ld = new LevelDefinition();
        ld.setName("Phonetic");
        Level l = new Level();
        l.setDefinition(ld);
        Item it1 = new Item();
        it1.setLevel(l);
        it1.setBundleId(456);
        it1.setLabel("Phonetic", "Label foo");
        l.getItems().add(it1);
        b.getLevels().add(l);
        EmuBundleAnnotationPersistor p = new EmuBundleAnnotationPersistor();
        try {
            File f = new File("/homes/klausj/WORK/EmuDbs_NewEMU/ae/0000_ses/msajc003_bndl/msajc003_annot.json");
            p.setFile(f);
            Bundle bl = p.load();
            System.out.println(bl);
            File of = File.createTempFile("test", ".json");
            p.setFile(of);
            p.write(bl);
            String ofC = StreamCopy.readTextFile((File)of, (Charset)Charset.forName("UTF-8"));
            System.out.println(ofC);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        catch (EncodeException e) {
            e.printStackTrace();
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public String getPreferredFileExtension() {
        return "json";
    }

    @Override
    public String getPreferredFilenameSuffix() {
        return "_annot";
    }

    public String[] getLinks() {
        return new String[]{"https://github.com/IPS-LMU/EMU-webApp", "https://github.com/IPS-LMU/emuR"};
    }

    @Override
    public boolean isWritable(Bundle bundle) {
        return true;
    }

    static {
        CS_NAME = "UTF-8";
    }
}

