/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.model.emu;

import ips.annot.model.db.Bundle;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.annot.model.emu.EmuBundleAnnotationPersistor;
import ipsk.text.ParserException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoadTest {
    public List<Bundle> load(File emuDbDir) throws IOException, ParserException {
        File[] sessDirs;
        long startTime = System.currentTimeMillis();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        EmuBundleAnnotationPersistor ebap = new EmuBundleAnnotationPersistor();
        int sCnt = 0;
        for (File sessDir : sessDirs = emuDbDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("_ses");
            }
        })) {
            File[] bundleDirs;
            System.out.println(++sCnt + ": " + sessDir);
            for (File bundleDir : bundleDirs = sessDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("_bndl");
                }
            })) {
                File[] annotFiles = bundleDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith("_annot.json");
                    }
                });
                ebap.setFile(annotFiles[0]);
                Bundle b = ebap.load();
                bundles.add(b);
            }
        }
        long endTime = System.currentTimeMillis();
        double durMs = endTime - startTime;
        System.out.println("Loaded " + bundles.size() + " annot files.(links resolved) in " + durMs / 1000.0 + " seconds");
        return bundles;
    }

    public boolean dominatedBy(Item dominator, Item dominated) {
        Set<Item> dominatorToIts = dominator.getToItems();
        if (dominatorToIts.contains(dominated)) {
            return true;
        }
        for (Item toIt : dominatorToIts) {
            boolean rd = this.dominatedBy(toIt, dominated);
            if (!rd) continue;
            return true;
        }
        return false;
    }

    public boolean domination(Item item1, Item item2) {
        boolean dominates = this.dominatedBy(item1, item2);
        boolean dominated = this.dominatedBy(item2, item1);
        return dominates || dominated;
    }

    public List<QRSeq> domination(QRSeq leftSeq, List<QRSeq> rightSeqs) {
        ArrayList<QRSeq> res = new ArrayList<QRSeq>();
        for (QRSeq rSeq : rightSeqs) {
            Item leftStartIt = leftSeq.getStartItem();
            Item rightStartIt = rSeq.getStartItem();
            boolean startDomination = this.domination(leftStartIt, rightStartIt);
            Item leftStopIt = leftSeq.getStopItem();
            Item rightStopIt = rSeq.getStopItem();
            boolean stopDomination = this.domination(leftStopIt, rightStopIt);
            if (!startDomination || !stopDomination) continue;
            res.add(leftSeq);
            break;
        }
        return res;
    }

    public QRSeq sequenceQuery(QRSeq leftSeq, QRSeq rightSeq) {
        Level rightLvl;
        Item leftStartIt = leftSeq.getStartItem();
        Item rightStartIt = rightSeq.getStartItem();
        Item leftStopIt = leftSeq.getStopItem();
        Item rightStopIt = rightSeq.getStopItem();
        Level leftLvl = leftStartIt.getLevel();
        if (leftLvl.equals(rightLvl = rightStartIt.getLevel())) {
            Bundle rightB;
            Bundle leftB = leftLvl.getBundle();
            if (leftB.equals(rightB = rightLvl.getBundle())) {
                Integer leftStopPos = leftStopIt.getPosition();
                Integer rightStartPos = rightStartIt.getPosition();
                if (leftStopPos != null && rightStartPos != null) {
                    if (rightStartPos == leftStopPos + 1) {
                        return new QRSeq(leftStartIt, rightStopIt);
                    }
                } else {
                    System.err.println("Position of item not set!!");
                }
            } else {
                System.out.println("Bundles do not match!");
            }
        }
        return null;
    }

    public List<QRSeq> sequenceQuery(QRSeq leftSeq, List<QRSeq> rightSeqs) {
        ArrayList<QRSeq> res = new ArrayList<QRSeq>();
        for (QRSeq rSeq : rightSeqs) {
            QRSeq resSeq = this.sequenceQuery(leftSeq, rSeq);
            if (resSeq == null) continue;
            res.add(resSeq);
        }
        return res;
    }

    public Map<Bundle, List<QRSeq>> domination(Map<Bundle, List<QRSeq>> leftSeqs, Map<Bundle, List<QRSeq>> rightSeqs) {
        HashMap<Bundle, List<QRSeq>> res = new HashMap<Bundle, List<QRSeq>>();
        for (Bundle b : leftSeqs.keySet()) {
            ArrayList<QRSeq> bResSeqs = new ArrayList<QRSeq>();
            List<QRSeq> leftBSeqs = leftSeqs.get(b);
            List<QRSeq> rightBSeqs = rightSeqs.get(b);
            for (QRSeq leftSeq : leftBSeqs) {
                List<QRSeq> r = this.domination(leftSeq, rightBSeqs);
                bResSeqs.addAll(r);
            }
            res.put(b, bResSeqs);
            int lSize = leftBSeqs.size();
            int n = bResSeqs.size();
        }
        return res;
    }

    public Map<Bundle, List<QRSeq>> sequenceQuery(Map<Bundle, List<QRSeq>> leftSeqs, Map<Bundle, List<QRSeq>> rightSeqs) {
        HashMap<Bundle, List<QRSeq>> res = new HashMap<Bundle, List<QRSeq>>();
        for (Bundle b : leftSeqs.keySet()) {
            ArrayList<QRSeq> bResSeqs = new ArrayList<QRSeq>();
            List<QRSeq> leftBSeqs = leftSeqs.get(b);
            List<QRSeq> rightBSeqs = rightSeqs.get(b);
            for (QRSeq leftSeq : leftBSeqs) {
                List<QRSeq> r = this.sequenceQuery(leftSeq, rightBSeqs);
                bResSeqs.addAll(r);
            }
            res.put(b, bResSeqs);
        }
        return res;
    }

    public Map<Bundle, List<QRSeq>> queryLabel(List<Bundle> bundles, String level, String label) {
        HashMap<Bundle, List<QRSeq>> res = new HashMap<Bundle, List<QRSeq>>();
        for (Bundle b : bundles) {
            ArrayList<QRSeq> bResSeqs = new ArrayList<QRSeq>();
            List<Level> bLvls = b.getLevels();
            for (Level bl : bLvls) {
                if (!level.equals(bl.getName())) continue;
                List<Item> items = bl.getItems();
                for (int i = 0; i < items.size(); ++i) {
                    Item it = items.get(i);
                    Map<String, Object> attrs = it.getLabels();
                    Object attr = attrs.get(level);
                    if (!(attr instanceof String)) continue;
                    String strAttr = (String)attr;
                    if (label != null && !strAttr.equals(label)) continue;
                    QRSeq qrSeq = new QRSeq(it, it);
                    bResSeqs.add(qrSeq);
                }
            }
            res.put(b, bResSeqs);
        }
        return res;
    }

    public Map<Bundle, List<QRSeq>> queryLabelRegex(List<Bundle> bundles, String level, String labelRegex, boolean searchAttributes) {
        HashMap<Bundle, List<QRSeq>> res = new HashMap<Bundle, List<QRSeq>>();
        Pattern p = Pattern.compile(labelRegex);
        for (Bundle b : bundles) {
            ArrayList<QRSeq> bResSeqs = new ArrayList<QRSeq>();
            List<Level> bLvls = b.getLevels();
            for (Level bl : bLvls) {
                if (!level.equals(bl.getName()) && !searchAttributes) continue;
                List<Item> items = bl.getItems();
                for (int i = 0; i < items.size(); ++i) {
                    String strAttr;
                    Matcher m;
                    Item it = items.get(i);
                    Map<String, Object> attrs = it.getLabels();
                    Object attr = attrs.get(level);
                    if (!(attr instanceof String) || !(m = p.matcher(strAttr = (String)attr)).matches()) continue;
                    QRSeq qrSeq = new QRSeq(it, it);
                    bResSeqs.add(qrSeq);
                }
            }
            res.put(b, bResSeqs);
        }
        return res;
    }

    private int intermediateResultSize(Map<Bundle, List<QRSeq>> r) {
        int size = 0;
        for (List<QRSeq> seqs : r.values()) {
            size += seqs.size();
        }
        return size;
    }

    private void printSeglist(Map<Bundle, List<QRSeq>> seglist) {
        for (List<QRSeq> lr : seglist.values()) {
            for (QRSeq r : lr) {
                System.out.println(r);
            }
        }
    }

    public Map<Bundle, List<QRSeq>> testQuery(List<Bundle> bundles) {
        ArrayList<Bundle> qbundles = new ArrayList();
        qbundles = bundles;
        Map<Bundle, List<QRSeq>> leftSeqSs = this.queryLabel(qbundles, "phonetic", "n");
        Map<Bundle, List<QRSeq>> rightSeqs = this.queryLabel(qbundles, "word", "sein");
        System.out.println(this.intermediateResultSize(leftSeqSs) + " -> " + this.intermediateResultSize(rightSeqs));
        Map<Bundle, List<QRSeq>> domQ = this.domination(leftSeqSs, rightSeqs);
        return domQ;
    }

    public static void main(String[] args) {
        String emuDbDirNm = args[0];
        File emuDbDir = new File(emuDbDirNm);
        LoadTest lt = new LoadTest();
        List<Bundle> bundleList = null;
        try {
            bundleList = lt.load(emuDbDir);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        catch (ParserException e1) {
            e1.printStackTrace();
            return;
        }
        long startTimeMs = System.currentTimeMillis();
        Map<Bundle, List<QRSeq>> res = lt.testQuery(bundleList);
        int segListSize = lt.intermediateResultSize(res);
        System.out.println("Found " + segListSize + " items in " + (System.currentTimeMillis() - startTimeMs) + " ms");
    }

    public static void printMemusage(PrintWriter pw) {
        Runtime runtime = Runtime.getRuntime();
        NumberFormat format = NumberFormat.getInstance();
        StringBuilder sb = new StringBuilder();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        sb.append("free memory: " + format.format(freeMemory / 1024L) + "\n");
        sb.append("allocated memory: " + format.format(allocatedMemory / 1024L) + "\n");
        sb.append("max memory: " + format.format(maxMemory / 1024L) + "\n");
        sb.append("total free memory: " + format.format((freeMemory + (maxMemory - allocatedMemory)) / 1024L) + "\n");
        pw.println(sb);
    }

    public class QRSeq {
        private Item startItem;
        private Item stopItem;

        public QRSeq(Item startItem, Item stopItem) {
            this.startItem = startItem;
            this.stopItem = stopItem;
        }

        public Item getStartItem() {
            return this.startItem;
        }

        public Item getStopItem() {
            return this.stopItem;
        }

        public String toString() {
            return new String("Sequence: " + this.startItem + " -> " + this.stopItem);
        }
    }
}

