/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.view;

import ips.annot.model.AnnotatedAudioClip;
import ips.annot.model.db.Bundle;
import ips.annot.textgrid.TextGridFileParser;
import ips.annot.view.AnnotationAudioClipUI;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.URLAudioSource;
import ipsk.audio.VectorBufferAudioSource;
import ipsk.audio.actions.LoopAction;
import ipsk.audio.actions.PauseAction;
import ipsk.audio.actions.StartPlaybackAction;
import ipsk.audio.actions.StopAction;
import ipsk.audio.arr.Selection;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.AudioClipListener;
import ipsk.audio.arr.clip.events.AudioClipChangedEvent;
import ipsk.audio.arr.clip.events.SelectionChangedEvent;
import ipsk.audio.arr.clip.ui.AudioClipScrollPane;
import ipsk.audio.arr.clip.ui.AudioClipUIContainer;
import ipsk.audio.arr.clip.ui.AudioSignalUI;
import ipsk.audio.arr.clip.ui.AudioTimeScaleUI;
import ipsk.audio.arr.clip.ui.FourierUI;
import ipsk.audio.arr.clip.ui.FragmentActionBarUI;
import ipsk.audio.bean.AudioPlayerBean;
import ipsk.audio.events.StartPlaybackActionEvent;
import ipsk.audio.mixer.MixerManager;
import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.player.PlayerListener;
import ipsk.audio.player.event.PlayerCloseEvent;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.audio.player.event.PlayerPauseEvent;
import ipsk.audio.player.event.PlayerStartEvent;
import ipsk.audio.player.event.PlayerStopEvent;
import ipsk.audio.ui.TransportUI;
import ipsk.awt.ProgressListener;
import ipsk.awt.PropertyChangeAWTEventTransferAgent;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.awt.event.ProgressErrorEvent;
import ipsk.awt.event.ProgressEvent;
import ipsk.io.VectorBuffer;
import ipsk.io.VectorBufferedInputStream;
import ipsk.io.VectorBufferedOutputStream;
import ipsk.net.URLContentLoader;
import ipsk.net.http.ContentType;
import ipsk.swing.JPopupMenuListener;
import ipsk.swing.JProgressDialogPanel;
import ipsk.swing.action.tree.ActionFolder;
import ipsk.swing.action.tree.ActionGroup;
import ipsk.swing.action.tree.ActionList;
import ipsk.swing.action.tree.ActionNode;
import ipsk.swing.action.tree.ActionTreeRoot;
import ipsk.swing.action.tree.JMenuBuilder;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.EventObject;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AnnotatedAudioPlayerBean
extends JPanel
implements AudioClipListener,
PlayerListener,
ActionListener,
ProgressListener {
    public static final boolean DEBUG = false;
    private boolean debug;
    private static final long serialVersionUID = 1L;
    private static final Float PREFERRED_LINE_BUFFER_SIZE_MILLIS = Float.valueOf(1000.0f);
    public static final int DEF_UPDATE_INTERVALL_MS = 200;
    private AnnotatedAudioClip audioClip;
    protected URL source;
    private URL annotationURL;
    private URLContentLoader audioLoader;
    private URLContentLoader annotationLoader;
    private VectorBufferedOutputStream annotionFileContent;
    private AudioPlayerBean.Status status;
    protected PropertyChangeAWTEventTransferAgent pChTa;
    private VectorBufferedOutputStream vbOut;
    protected AudioSource audioSource;
    protected AnnotationAudioClipUI annotationAudioClipUI;
    protected AudioClipUIContainer uiContainer;
    private JProgressDialogPanel progressPanel;
    private AudioClipScrollPane scrollPane;
    private String message;
    private Player player;
    protected AudioSource playbackSource;
    private StartPlaybackAction startAction;
    private StopAction stopAction;
    private PauseAction pauseAction;
    private LoopAction loopAction;
    private JPanel playerPanel;
    private Timer updateTimer;
    private Selection selection;
    private FourierUI sonagram;
    protected AudioSignalUI signalUI;
    private FragmentActionBarUI fragmentActionBar;
    private AudioTimeScaleUI timeScale;
    private boolean startPlayOnSelect;
    private Mixer device;
    private boolean autoPlayOnLoad;
    public static final String VERSION = AudioPlayerBean.class.getPackage().getImplementationVersion();
    private volatile Bundle bundle;
    private volatile InputStreamReader annotationreader;
    private Charset textGridCharset;

    public AnnotatedAudioPlayerBean() {
        this(new AnnotatedAudioClip());
    }

    public AnnotatedAudioPlayerBean(AnnotatedAudioClip audioClip) {
        block8: {
            super(new BorderLayout());
            this.debug = false;
            this.status = null;
            this.pChTa = new PropertyChangeAWTEventTransferAgent();
            this.signalUI = null;
            this.autoPlayOnLoad = false;
            this.textGridCharset = null;
            this.audioClip = audioClip;
            if (this.audioClip == null) {
                this.audioClip = new AnnotatedAudioClip();
            }
            this.audioClip.addAudioSampleListener(this);
            try {
                MixerManager mm = new MixerManager();
                Mixer[] devices = mm.getDirectPlaybackMixers();
                if (devices != null && devices.length > 0) {
                    this.device = devices[0];
                    this.player = new Player(this.device);
                } else {
                    this.player = new Player();
                }
            }
            catch (LineUnavailableException e) {
                if (!this.debug) break block8;
                System.out.println("Could not get a direct audio device !");
                e.printStackTrace();
            }
        }
        if (this.player == null) {
            this.player = new Player();
        }
        if (this.player != null) {
            this.player.setPreferredLineBufferSizeMillis(PREFERRED_LINE_BUFFER_SIZE_MILLIS);
            this.player.setMeasureLevel(false);
            this.player.addPlayerListener((PlayerListener)this);
        }
        this.playerPanel = new JPanel();
        this.startAction = new StartPlaybackAction();
        this.stopAction = new StopAction();
        this.pauseAction = new PauseAction();
        this.loopAction = new LoopAction();
        this.startAction.setEnabled(false);
        this.stopAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.startAction.addActionListener((ActionListener)this);
        this.stopAction.addActionListener((ActionListener)this);
        this.pauseAction.addActionListener((ActionListener)this);
        this.loopAction.addActionListener((ActionListener)this);
        TransportUI tp = new TransportUI(this.startAction, this.stopAction, this.pauseAction, this.loopAction);
        this.playerPanel.add((Component)tp);
        this.add((Component)this.playerPanel, "South");
        this.updateTimer = new Timer(200, this);
        this.signalUI = new AudioSignalUI();
        this.uiContainer = new AudioClipUIContainer();
        this.uiContainer.add((Component)this.signalUI);
        this.sonagram = new FourierUI();
        this.sonagram.setUseThread(true);
        this.uiContainer.add((Component)this.sonagram);
        this.fragmentActionBar = new FragmentActionBarUI();
        this.fragmentActionBar.setStartPlaybackAction(this.startAction);
        this.uiContainer.add((Component)this.fragmentActionBar);
        this.annotationAudioClipUI = new AnnotationAudioClipUI(audioClip);
        this.uiContainer.add((Component)((Object)this.annotationAudioClipUI));
        this.timeScale = new AudioTimeScaleUI();
        this.uiContainer.add((Component)this.timeScale);
        this.scrollPane = new AudioClipScrollPane(this.uiContainer);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.uiContainer.setAudioClip((AudioClip)audioClip);
        this.createPopupMenu();
        String m = "Audio player initialized.";
        if (this.debug) {
            System.out.println(m);
        }
        this.setMessage(m);
        this.status = AudioPlayerBean.Status.INITIALIZED;
    }

    public URL getAnnotationURL() {
        return this.annotationURL;
    }

    private synchronized void createAnnotation() {
        AudioSource as = this.audioClip.getAudioSource();
        if (as == null) {
            return;
        }
        float sampleRate = -1.0f;
        try {
            sampleRate = this.audioClip.getFormat().getSampleRate();
        }
        catch (AudioSourceException e) {
            e.printStackTrace();
        }
        TextGridFileParser tgfp = new TextGridFileParser(sampleRate);
        try {
            this.bundle = tgfp.parse(this.annotationreader);
            if (this.debug) {
                System.out.println("Parsed TextGrid annotation:\n" + this.bundle);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.audioClip.setBundle(this.bundle);
    }

    public void update(ProgressEvent progressEvent) {
        ProgressStatus status;
        Object evSrc = progressEvent.getSource();
        if (evSrc == this.audioLoader) {
            ProgressStatus status2 = progressEvent.getProgressStatus();
            if (progressEvent instanceof ProgressErrorEvent) {
                if (this.progressPanel != null) {
                    this.remove((Component)this.progressPanel);
                }
                String errMsg = "Unknown error!";
                if (status2 != null) {
                    errMsg = status2.getMessage().localize();
                }
                this.setMessage(errMsg);
                JOptionPane.showMessageDialog(this, errMsg, "Audio applet loading error", 0);
            } else if (status2 != null) {
                if (status2.isDone()) {
                    if (this.progressPanel != null) {
                        this.remove((Component)this.progressPanel);
                    }
                    VectorBuffer vb = this.vbOut.getVectorBuffer();
                    VectorBufferAudioSource vbAudioSource = new VectorBufferAudioSource(vb);
                    this.audioSource = vbAudioSource;
                    try {
                        this.process();
                    }
                    catch (AudioSourceException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Could not process audio file: " + e.getMessage(), "Audio processing error", 0);
                        return;
                    }
                    this.enableAudio();
                    this.makeReady();
                    if (this.autoPlayOnLoad) {
                        this.playSelection();
                    }
                } else {
                    this.setMessage("Download audio source " + status2.getPercentProgress() + "%");
                }
            }
        } else if (evSrc == this.annotationLoader && (status = progressEvent.getProgressStatus()).isDone()) {
            Charset charset;
            VectorBufferedInputStream annoIs;
            block26: {
                if (this.debug) {
                    System.out.println("Annotation loaded.");
                }
                annoIs = new VectorBufferedInputStream(this.annotionFileContent);
                ContentType contentType = this.annotationLoader.getContentType();
                charset = this.textGridCharset;
                if (charset == null) {
                    charset = Charset.forName("ISO-8859-1");
                    if (this.debug) {
                        System.out.println("Default charset: " + charset.name());
                    }
                } else if (this.debug) {
                    System.out.println("Forced charset : " + charset.name());
                }
                if (contentType != null) {
                    String charsetName = contentType.getCharsetParameter();
                    if (this.debug) {
                        System.out.println("Charset string from content type header: " + charsetName);
                    }
                    if (charsetName != null && !"".equals(charsetName)) {
                        try {
                            charset = Charset.forName(charsetName);
                            if (this.debug) {
                                System.out.println("Charset from content type: " + charset.name());
                            }
                        }
                        catch (IllegalArgumentException iae) {
                            if (!this.debug) break block26;
                            System.err.println("Could not create charset object from content type header: " + charsetName + ":");
                            iae.printStackTrace();
                        }
                    }
                }
            }
            if (this.debug) {
                System.out.println("Annotation charset: " + charset.name());
            }
            this.annotationreader = new InputStreamReader((InputStream)annoIs, charset);
            this.createAnnotation();
        }
    }

    public void makeReady() {
        if (this.bundle == null && this.annotationreader != null) {
            this.createAnnotation();
        }
        this.revalidate();
        this.repaint();
        this.status = AudioPlayerBean.Status.READY;
        this.setMessage("Audio player ready.");
    }

    private void clearScreen() {
        if (this.progressPanel != null) {
            this.remove((Component)this.progressPanel);
        }
        if (this.scrollPane != null) {
            this.remove((Component)this.scrollPane);
        }
    }

    private void process() throws AudioSourceException {
        this.status = AudioPlayerBean.Status.PROCESS;
        this.clearScreen();
        this.playbackSource = this.audioSource;
        String m = "Processing audio data ...";
        if (this.debug) {
            System.out.println(m);
        }
        this.setMessage(m);
        this.audioClip.setAudioSource(this.audioSource);
        this.audioClip.setSelection(this.selection);
        this.add((Component)this.scrollPane, "Center");
        this.validate();
        this.playerPanel.validate();
        this.uiContainer.xZoomFitToPanel();
        this.uiContainer.validate();
        this.validate();
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    private void enableAudio() {
        if (this.audioClip != null) {
            if (this.player != null) {
                try {
                    this.player.setAudioSource(this.playbackSource);
                    this.startAction.setEnabled(true);
                    this.stopAction.setHighlighted(true);
                    this.updateTimer.start();
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                    this.setMessage("Could not set playback audio source !");
                }
            } else {
                this.setMessage("No audio player available.");
            }
        } else {
            this.setMessage("No audio clip available.");
        }
    }

    public void setAnnotationURL(URL annotationURL) {
        if (this.annotationLoader != null) {
            this.annotationLoader.removeProgressListener((ProgressListener)this);
            this.annotationLoader.cancel();
            try {
                this.annotationLoader.close();
                this.annotationLoader.reset();
            }
            catch (WorkerException e1) {
                e1.printStackTrace();
            }
        }
        this.annotationreader = null;
        this.bundle = null;
        this.annotationURL = annotationURL;
        if (this.annotationURL != null) {
            this.annotionFileContent = new VectorBufferedOutputStream();
            this.annotationLoader = new URLContentLoader(this.annotationURL, (OutputStream)this.annotionFileContent, "annotation loader");
            this.annotationLoader.addProgressListener((ProgressListener)this);
            try {
                this.annotationLoader.open();
            }
            catch (WorkerException e) {
                e.printStackTrace();
            }
            this.annotationLoader.start();
        }
    }

    public void setMessage(String message) {
        String oldMessage = this.message;
        this.message = message;
        this.pChTa.fireEvent((EventObject)new PropertyChangeEvent(this, "message", oldMessage, this.message));
    }

    private void createPopupMenu() {
        ActionTreeRoot ascActionTree = this.scrollPane.getActionTreeRoot();
        ActionFolder signalViewFolder = new ActionFolder("signalview", new LocalizableMessage("Signal view"));
        ActionTreeRoot shiftedAscActionTree = ascActionTree.shiftFromTopLevel(signalViewFolder);
        ActionTreeRoot afft = new ActionTreeRoot();
        ActionFolder avf = ActionFolder.buildTopLevelFolder((String)"view");
        ActionGroup subjectViewGroup = new ActionGroup("view.subjectGroup");
        avf.add((ActionNode)subjectViewGroup);
        afft.add((ActionNode)avf);
        afft.merge((ActionList)shiftedAscActionTree);
        JMenuBuilder pmb = new JMenuBuilder((ActionFolder)ascActionTree);
        JPopupMenu pm = pmb.buildJPopupMenu();
        JPopupMenuListener pml = new JPopupMenuListener(pm);
        this.scrollPane.addMouseListener((MouseListener)pml);
        this.uiContainer.addPopupMouseListener((MouseListener)pml);
    }

    public void setVisualizing() {
        this.signalUI = new AudioSignalUI();
        this.uiContainer = new AudioClipUIContainer();
        this.uiContainer.add((Component)this.signalUI);
        this.sonagram = new FourierUI();
        this.sonagram.setUseThread(true);
        this.uiContainer.add((Component)this.sonagram);
        this.fragmentActionBar = new FragmentActionBarUI();
        this.fragmentActionBar.setStartPlaybackAction(this.startAction);
        this.uiContainer.add((Component)this.fragmentActionBar);
        this.timeScale = new AudioTimeScaleUI();
        this.uiContainer.add((Component)this.timeScale);
        this.scrollPane = new AudioClipScrollPane(this.uiContainer);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.uiContainer.setAudioClip((AudioClip)this.audioClip);
        this.createPopupMenu();
    }

    public boolean isShowSonagram() {
        return this.sonagram.isVisible();
    }

    public void setShowSonagram(boolean showSonagram) {
        this.sonagram.setVisible(showSonagram);
    }

    public boolean isShowFragmentActionBar() {
        return this.fragmentActionBar.isVisible();
    }

    public void setShowFragmentActionBar(boolean showFragmentActionBar) {
        this.fragmentActionBar.setVisible(showFragmentActionBar);
    }

    public boolean isShowTimeScale() {
        return this.timeScale.isVisible();
    }

    public void setShowTimeScale(boolean showTimeScale) {
        this.timeScale.setVisible(showTimeScale);
    }

    public boolean isAutoPlayOnLoad() {
        return this.autoPlayOnLoad;
    }

    public void setAutoPlayOnLoad(boolean autoPlayOnLoad) {
        this.autoPlayOnLoad = autoPlayOnLoad;
    }

    public boolean isStartPlayOnSelect() {
        return this.startPlayOnSelect;
    }

    public void setStartPlayOnSelect(boolean startPlayOnSelect) {
        this.startPlayOnSelect = startPlayOnSelect;
    }

    public void setURL(URL source) {
        URL oldUrl = this.source;
        if (this.source != null && this.source.equals(source)) {
            return;
        }
        if (this.audioClip != null) {
            this.audioClip.setAudioSource(null);
        }
        this.source = source;
        this.closeAudio();
        this.selection = null;
        this.startAction.setEnabled(false);
        this.stopAction.setEnabled(false);
        this.closeAudioDownload();
        this.vbOut = null;
        this.clearScreen();
        this.load();
        this.pChTa.fireEvent((EventObject)new PropertyChangeEvent(this, "source", oldUrl, this.source));
    }

    public void deactivate() {
        this.closeAnnoDownload();
        if (AudioPlayerBean.Status.LOADING.equals((Object)this.status)) {
            this.closeAudioDownload();
            this.status = AudioPlayerBean.Status.INITIALIZED;
        } else {
            if (this.audioClip != null) {
                this.updateTimer.stop();
                this.startAction.setEnabled(false);
                this.audioClip.setAudioSource(null);
            }
            if (this.player != null) {
                try {
                    this.player.close();
                    this.setMessage("Audio player closed.");
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                    this.setMessage("Could not close audio player !");
                }
            }
            this.status = AudioPlayerBean.Status.DEACTIVATED;
        }
    }

    public void reactivate() {
        if (AudioPlayerBean.Status.DEACTIVATED.equals((Object)this.status)) {
            this.audioClip.setAudioSource(this.audioSource);
            this.enableAudio();
            this.makeReady();
        } else if (AudioPlayerBean.Status.INITIALIZED.equals((Object)this.status)) {
            this.load();
        }
    }

    private void load() {
        this.clearScreen();
        String urlProtocol = this.source.getProtocol();
        if (urlProtocol.equalsIgnoreCase("file")) {
            this.audioSource = new URLAudioSource(this.source);
            if (this.scrollPane != null) {
                this.scrollPane.setPreferredSize(new Dimension(200, 100));
            }
            try {
                this.process();
            }
            catch (AudioSourceException e) {
                JOptionPane.showMessageDialog(this, "Could not process audio file: " + e.getMessage(), "Audio processing error", 0);
                return;
            }
            this.enableAudio();
            this.makeReady();
            if (this.autoPlayOnLoad) {
                this.playSelection();
            }
        } else {
            this.status = AudioPlayerBean.Status.LOADING;
            this.vbOut = new VectorBufferedOutputStream();
            this.audioLoader = new URLContentLoader(this.source, (OutputStream)this.vbOut, "URL content loader");
            this.progressPanel = new JProgressDialogPanel((Worker)this.audioLoader, "title", "Loading audio ...");
            this.add((Component)this.progressPanel, "Center");
            this.revalidate();
            this.repaint();
            this.audioLoader.addProgressListener((ProgressListener)this);
            try {
                this.audioLoader.open();
            }
            catch (WorkerException e) {
                e.printStackTrace();
            }
            this.audioLoader.start();
        }
    }

    private void closeAnnoDownload() {
        if (this.annotationLoader != null) {
            this.annotationLoader.removeProgressListener((ProgressListener)this);
            this.annotationLoader.cancel();
            try {
                this.annotationLoader.close();
                this.annotationLoader.reset();
            }
            catch (WorkerException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void closeAudioDownload() {
        if (this.audioLoader != null) {
            this.audioLoader.removeProgressListener((ProgressListener)this);
            this.audioLoader.cancel();
            try {
                this.audioLoader.close();
                this.audioLoader.reset();
            }
            catch (WorkerException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void closeAudio() {
        this.updateTimer.stop();
        this.startAction.setEnabled(false);
        if (this.player != null) {
            try {
                this.player.close();
                this.setMessage("Audio player closed.");
            }
            catch (PlayerException e) {
                e.printStackTrace();
                this.setMessage("Could not close audio player !");
            }
        }
        this.audioSource = null;
        try {
            this.player.setAudioSource(null);
        }
        catch (PlayerException e) {
            e.printStackTrace();
        }
        this.audioClip.setAudioSource(null);
    }

    public void close() {
        this.status = AudioPlayerBean.Status.CLOSING;
        this.closeAudio();
        this.closeAudioDownload();
        this.closeAnnoDownload();
        if (this.updateTimer != null) {
            this.updateTimer.stop();
        }
        if (this.uiContainer != null) {
            this.uiContainer.close();
        }
        if (this.audioClip != null) {
            this.audioClip.removeAudioSampleListener(this);
        }
        this.clearScreen();
        this.status = AudioPlayerBean.Status.CLOSED;
    }

    public void audioClipChanged(AudioClipChangedEvent event) {
        if (event instanceof SelectionChangedEvent) {
            SelectionChangedEvent selEvent = (SelectionChangedEvent)event;
            Selection s = selEvent.getSelection();
            if (this.player == null) {
                return;
            }
            if (this.audioClip != null) {
                if (s != null) {
                    this.player.setStartFramePosition(s.getLeft());
                    this.player.setStopFramePosition(s.getRight());
                    if (this.startPlayOnSelect && !this.player.isOpen()) {
                        try {
                            this.player.open();
                            this.setMessage("Audio player open.");
                            this.player.play();
                        }
                        catch (PlayerException e) {
                            e.printStackTrace();
                            this.setMessage("Cannot play audio !");
                        }
                    }
                } else {
                    this.player.setStartFramePosition(0L);
                    this.player.setStopFramePosition(-1L);
                }
            }
        }
    }

    public void update(PlayerEvent playerEvent) {
        if (playerEvent instanceof PlayerStartEvent) {
            this.setMessage("Audio player playing...");
            this.stopAction.setEnabled(true);
            this.stopAction.setHighlighted(false);
            this.pauseAction.setEnabled(true);
            this.pauseAction.setHighlighted(false);
            this.startAction.setEnabled(false);
            this.startAction.setHighlighted(true);
        } else if (playerEvent instanceof PlayerPauseEvent) {
            this.setMessage("Audio player paused.");
            this.stopAction.setEnabled(true);
            this.stopAction.setHighlighted(false);
            this.pauseAction.setEnabled(true);
            this.pauseAction.setHighlighted(true);
            this.startAction.setEnabled(false);
            this.startAction.setHighlighted(true);
        } else if (playerEvent instanceof PlayerStopEvent) {
            if (AudioPlayerBean.Status.READY.equals((Object)this.status)) {
                this.stopAction.setEnabled(false);
                this.stopAction.setHighlighted(true);
                this.pauseAction.setEnabled(false);
                this.pauseAction.setHighlighted(false);
                this.startAction.setEnabled(false);
                this.startAction.setHighlighted(false);
                this.setMessage("Audio player stopped.");
            }
            this.setMessage("Audio player stopped.");
            try {
                this.player.close();
            }
            catch (PlayerException e) {
                e.printStackTrace();
                this.setMessage("Could not close audio player !");
            }
        } else if (playerEvent instanceof PlayerCloseEvent) {
            if (AudioPlayerBean.Status.READY.equals((Object)this.status)) {
                this.stopAction.setEnabled(false);
                this.stopAction.setHighlighted(true);
                this.startAction.setEnabled(true);
                this.startAction.setHighlighted(false);
            } else if (!AudioPlayerBean.Status.CLOSING.equals((Object)this.status)) {
                this.setMessage("Internal error state ");
            }
            this.setMessage("Audio player closed.");
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        String actionCommand = arg0.getActionCommand();
        if (src == this.updateTimer) {
            this.audioClip.setFramePosition(this.player.getFramePosition());
        } else if (actionCommand == StartPlaybackAction.ACTION_COMMAND) {
            if (arg0 instanceof StartPlaybackActionEvent) {
                StartPlaybackActionEvent spae = (StartPlaybackActionEvent)arg0;
                this.player.setStartFramePosition(spae.getStartFramePosition());
                this.player.setStopFramePosition(spae.getStopFramePosition());
                if (this.player != null && !this.player.isOpen()) {
                    try {
                        this.player.open();
                        this.setMessage("Audio player open.");
                        this.player.play();
                    }
                    catch (PlayerException e) {
                        e.printStackTrace();
                        this.setMessage("Cannot play audio !");
                    }
                }
            } else {
                this.playSelection();
            }
        } else if (actionCommand == StopAction.ACTION_COMMAND) {
            this.player.stop();
        } else if (actionCommand == PauseAction.ACTION_COMMAND) {
            this.player.pause();
        } else if (actionCommand == LoopAction.ACTION_COMMAND) {
            this.player.setLooping(((Boolean)this.loopAction.getValue("SwingSelectedKey")).booleanValue());
        }
    }

    private void playSelection() {
        if (this.player == null || this.player.isOpen()) {
            return;
        }
        if (this.audioClip != null) {
            Selection s = this.audioClip.getSelection();
            if (s != null) {
                this.player.setStartFramePosition(s.getLeft());
                this.player.setStopFramePosition(s.getRight());
            } else {
                this.player.setStartFramePosition(0L);
                this.player.setStopFramePosition(-1L);
            }
            try {
                this.player.open();
                this.setMessage("Audio player open.");
                this.player.play();
            }
            catch (PlayerException e) {
                e.printStackTrace();
                this.setMessage("Cannot play audio !");
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: AudioPlayerBean audioURL annotationURL");
            System.exit(-1);
        }
        try {
            final URL audioUrl = new URL(args[0]);
            final URL annotationURL = new URL(args[1]);
            Runnable show = new Runnable(){

                @Override
                public void run() {
                    JFrame f = new JFrame("Test audio player bean");
                    final AnnotatedAudioPlayerBean aBean = new AnnotatedAudioPlayerBean();
                    aBean.setShowSonagram(false);
                    aBean.setShowFragmentActionBar(true);
                    aBean.setShowTimeScale(false);
                    aBean.setStartPlayOnSelect(true);
                    f.getContentPane().add(aBean);
                    f.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            aBean.close();
                        }

                        @Override
                        public void windowClosed(WindowEvent e) {
                            System.exit(0);
                        }
                    });
                    f.pack();
                    f.setVisible(true);
                    f.setDefaultCloseOperation(2);
                    aBean.setURL(audioUrl);
                    aBean.setAnnotationURL(annotationURL);
                    f.pack();
                }
            };
            SwingUtilities.invokeAndWait(show);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.exit(-2);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            System.exit(-3);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setTextGridCharset(Charset cs) {
        this.textGridCharset = cs;
    }
}

