/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.autoannotator.impl.ws.bas.g2p;

import ips.annot.autoannotator.AutoAnnotation;
import ips.annot.autoannotator.AutoAnnotationServiceDescriptor;
import ips.annot.autoannotator.AutoAnnotator;
import ips.annot.autoannotator.AutoAnnotatorException;
import ips.annot.autoannotator.BundleAutoAnnotation;
import ips.annot.autoannotator.impl.ws.bas.BasicBasServiceClient;
import ips.annot.autoannotator.impl.ws.bas.g2p.G2PAnnotatorServiceDescriptor;
import ips.annot.model.PredefinedLevelDefinition;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.LinkDefinition;
import ips.annot.partitur.PartiturParser;
import ipsk.io.StreamCopy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class G2PServiceClient
extends BasicBasServiceClient {
    public static final G2PAnnotatorServiceDescriptor DESCRIPTOR = new G2PAnnotatorServiceDescriptor();
    private static final boolean DEBUG = false;
    protected static String URL = BASE_URL + "/runG2P";
    public static final String RESPONSE_XML_TOP_ELEM = "WebServiceResponseLink";
    public static final String RESPONSE_XML_DOWNLOAD_ELEM = "downloadLink";
    public static final String RESPONSE_XML_SUCCESS_ELEM = "success";

    public G2PServiceClient() {
        this.docBuilderFactory = DocumentBuilderFactory.newInstance();
    }

    public AutoAnnotation g2pClient(String orthography, Locale loc) throws AutoAnnotatorException {
        try {
            this.getServerCaps();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httppost = new HttpPost(URL);
        String iso639ThreeLetters = loc.getISO3Language();
        StringBody languageBody = new StringBody(iso639ThreeLetters, DEFAULT_TEXT_CONTENT_TYPE);
        MultipartEntityBuilder reqEntityBuilder = MultipartEntityBuilder.create();
        reqEntityBuilder.addPart("lng", (ContentBody)languageBody);
        ByteArrayBody ib = new ByteArrayBody(orthography.getBytes(DEFAULT_CHARSET), DEFAULT_TEXT_CONTENT_TYPE, "SpeechDatabaseTools_input" + UUID.randomUUID() + ".txt");
        reqEntityBuilder.addPart("i", (ContentBody)ib);
        HttpEntity reqEntity = reqEntityBuilder.build();
        httppost.setEntity(reqEntity);
        try {
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            StatusLine sl = response.getStatusLine();
            int status = sl.getStatusCode();
            if (status >= 200 && status < 300) {
                BundleAutoAnnotation baa;
                HttpEntity resEntity = response.getEntity();
                InputStream content = resEntity.getContent();
                URL dlUrl = this.downloadLinkFromResponse(content);
                URLConnection dlConn = dlUrl.openConnection();
                InputStream is = dlConn.getInputStream();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                StreamCopy.copy((InputStream)is, (OutputStream)bos);
                byte[] bin = bos.toByteArray();
                ByteArrayInputStream bisd = new ByteArrayInputStream(bin);
                ByteArrayInputStream bis = new ByteArrayInputStream(bin);
                InputStreamReader kanCont = new InputStreamReader((InputStream)bis, DEFAULT_CHARSET);
                PartiturParser pp = new PartiturParser();
                HashSet<LinkDefinition> linkDefs = new HashSet<LinkDefinition>();
                LinkDefinition ortKanLd = new LinkDefinition();
                ortKanLd.setSuperLevel(PredefinedLevelDefinition.ORT.getLevelDefinition());
                ortKanLd.setSubLevel(PredefinedLevelDefinition.KAN.getLevelDefinition());
                linkDefs.add(ortKanLd);
                pp.setLinkDefinitions(linkDefs);
                Bundle inb = null;
                if (this.annotationRequest != null) {
                    inb = this.annotationRequest.getBundle();
                }
                Bundle resBundle = pp.parse(inb, kanCont);
                BundleAutoAnnotation bundleAutoAnnotation = baa = new BundleAutoAnnotation(resBundle);
                return bundleAutoAnnotation;
            }
        }
        catch (IOException e) {
            throw new AutoAnnotatorException(e);
        }
        return null;
    }

    public static void main(String[] args) {
        G2PServiceClient g2pc = new G2PServiceClient();
        String example2Txt = "Einzelzimmer 248 Mark.";
        try {
            AutoAnnotation aa = g2pc.g2pClient(example2Txt, Locale.GERMAN);
            System.out.println(aa);
        }
        catch (AutoAnnotatorException e) {
            e.printStackTrace();
        }
    }

    @Override
    public AutoAnnotation call() throws Exception {
        Bundle inputBundle = this.annotationRequest.getBundle();
        String orthography = this.orthoGraphyTextFromTemplateLevel(inputBundle);
        if (orthography != null) {
            Locale loc = inputBundle.getLocale();
            return this.g2pClient(orthography, loc);
        }
        throw new AutoAnnotatorException();
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void setAnnotationRequest(AutoAnnotator.AnnotationRequest ar) {
        this.annotationRequest = ar;
    }

    @Override
    public AutoAnnotationServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public boolean isBundleSupported(Bundle bundle) throws IOException {
        boolean basicSupp = super.isBundleSupported(bundle);
        if (!basicSupp) {
            return basicSupp;
        }
        String orthography = this.orthoGraphyTextFromTemplateLevel(bundle);
        return orthography != null;
    }
}

