/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.model.db;

import ips.annot.model.db.Label;
import ips.annot.model.db.Level;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class Item {
    @Id
    @SequenceGenerator(name="keys", sequenceName="KEYS", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="keys")
    private int id;
    private Integer bundleId = null;
    private Set<Item> fromItems = new HashSet<Item>();
    private Set<Item> toItems = new HashSet<Item>();
    private Integer position;
    private Long sampleStart;
    private Long samplepoint;
    private Long sampleDur;
    @ManyToOne
    private transient Level level;
    private Map<String, Object> labels = new HashMap<String, Object>();

    @XmlTransient
    @Transient
    public Set<Item> getFromItems() {
        return this.fromItems;
    }

    @XmlTransient
    @Transient
    public Set<Item> getToItems() {
        return this.toItems;
    }

    @XmlTransient
    @Transient
    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    @XmlTransient
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @XmlElement(name="id")
    public Integer getBundleId() {
        return this.bundleId;
    }

    public void setBundleId(Integer bundleId) {
        this.bundleId = bundleId;
    }

    public Long getSamplepoint() {
        return this.samplepoint;
    }

    public void setSamplepoint(Long samplepoint) {
        this.samplepoint = samplepoint;
    }

    public Long getSampleStart() {
        return this.sampleStart;
    }

    public void setSampleStart(Long sampleStart) {
        this.sampleStart = sampleStart;
    }

    public Long getSampleDur() {
        return this.sampleDur;
    }

    public void setSampleDur(Long sampleDur) {
        this.sampleDur = sampleDur;
    }

    @XmlTransient
    public Long getSampleEnd() {
        if (this.sampleStart != null && this.sampleDur != null) {
            return this.sampleStart + this.sampleDur;
        }
        return null;
    }

    public Long sampleDur() {
        if (this.sampleDur != null) {
            return this.sampleDur + 1L;
        }
        return null;
    }

    @XmlTransient
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level tier) {
        this.level = tier;
    }

    @XmlTransient
    public String getType() {
        if (this.level != null) {
            return this.level.getType();
        }
        return null;
    }

    @XmlTransient
    public Map<String, Object> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, Object> labels) {
        this.labels = labels;
    }

    public void setLabel(String name, Object value) {
        this.labels.put(name, value);
    }

    @XmlElement(name="labels")
    public List<Label> getLabelsList() {
        ArrayList<Label> ll = new ArrayList<Label>();
        for (String key : this.labels.keySet()) {
            Object v = this.labels.get(key);
            Label l = new Label();
            l.setName(key);
            l.setValue(v);
            ll.add(l);
        }
        return ll;
    }

    public void setLabelsList(List<Label> labelsList) {
        this.labels.clear();
        for (Label l : labelsList) {
            this.labels.put(l.getName(), l.getValue());
        }
    }

    public Collection<Object> getLabelValues() {
        return this.labels.values();
    }

    public String getLabelText() {
        StringBuffer buffer = new StringBuffer();
        Set<String> labelsKeySet = this.labels.keySet();
        int ksSize = labelsKeySet.size();
        int c = 0;
        for (String key : labelsKeySet) {
            buffer.append(key + ":");
            if (this.labels.get(key) != null) {
                buffer.append(this.labels.get(key).toString());
            } else {
                buffer.append("NN");
            }
            if (c < ksSize - 1) {
                buffer.append(";");
            }
            ++c;
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.bundleId != null) {
            buffer.append("(");
            buffer.append(this.bundleId);
            buffer.append(") ");
        }
        buffer.append(this.getLabelText());
        if ("SEGMENT".equals(this.getType())) {
            Long st = this.getSampleStart();
            Long se = this.getSampleEnd();
            buffer.append(" [");
            if (st != null) {
                buffer.append(st);
            }
            buffer.append(':');
            if (se != null) {
                buffer.append(se);
            }
            buffer.append(']');
        } else if ("EVENT".equals(this.getType())) {
            Long st = this.getSampleStart();
            buffer.append(" [");
            if (st != null) {
                buffer.append(st);
            }
            buffer.append(']');
        }
        return buffer.toString();
    }
}

