/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.model.db;

import ips.annot.model.db.Item;
import ips.annot.model.db.LevelDefinition;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;

public class LinkDefinition {
    public static final String INIT = "INIT";
    public static final String ONE_TO_MANY = "ONE_TO_MANY";
    public static final String MANY_TO_ONE = "MANY_TO_ONE";
    public static final String MANY_TO_MANY = "MANY_TO_MANY";
    private LevelDefinition superLevel;
    private LevelDefinition subLevel;
    private String type;

    @XmlElement(name="superlevelName")
    @XmlIDREF
    public LevelDefinition getSuperLevel() {
        return this.superLevel;
    }

    public void setSuperLevel(LevelDefinition superTier) {
        this.superLevel = superTier;
    }

    @XmlElement(name="sublevelName")
    @XmlIDREF
    public LevelDefinition getSubLevel() {
        return this.subLevel;
    }

    public void setSubLevel(LevelDefinition subTier) {
        this.subLevel = subTier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isValidTierLinkDefinition(LevelDefinition superTier, LevelDefinition subTier) {
        if (!this.getType().equals(INIT) && this.getSuperLevel().equals(superTier) && this.getSubLevel().equals(subTier)) {
            System.out.println("validTierLinkDefinition(): " + superTier.getName() + " -> " + subTier.getName());
            return true;
        }
        return false;
    }

    public boolean isValidItemLinkDefinition(Item i1, Item i2) {
        LevelDefinition t1 = i1.getLevel().getDefinition();
        LevelDefinition t2 = i2.getLevel().getDefinition();
        return this.isValidTierLinkDefinition(t1, t2);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("LinkDefinition");
        if (this.getType().equals(INIT)) {
            buffer.append("root: ");
            buffer.append(this.getSubLevel().getName());
        } else {
            buffer.append(this.getSuperLevel().getName() + " -> " + this.getSubLevel().getName() + ": ");
            buffer.append(this.getType());
        }
        return buffer.toString();
    }
}

