/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.view;

import ips.annot.model.AnnotatedAudioClip;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.EventItem;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.annot.model.db.LevelDefinition;
import ips.annot.model.event.BundleChangedEvent;
import ips.annot.model.event.BundleListener;
import ipsk.audio.actions.StartPlaybackAction;
import ipsk.audio.arr.Selection;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.ui.BasicAudioClipUI;
import ipsk.audio.events.StartPlaybackActionEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AnnotationActionsAudioClipUI
extends BasicAudioClipUI
implements BundleListener,
MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private Bundle bundle;
    private MouseEvent pressedEvent = null;
    private MouseEvent dragStartEvent = null;
    private MouseEvent selEndMoveEvent;
    private MouseEvent selStartMoveEvent;
    private MouseEvent mouseOverResizeWest;
    private MouseEvent mouseOverResizeEast;
    private int selectorWidth = 5;
    private boolean changeSelectionOnDrag = false;
    private boolean snapToSegments = true;
    private int separatorHeight = 1;
    private List<JLabel> yLabels = new ArrayList<JLabel>();
    private JPanel yScalesComponent;
    private StartPlaybackAction startPlaybackAction;

    public String getName() {
        return "Annotation";
    }

    public AnnotationActionsAudioClipUI(AnnotatedAudioClip annotatedAudioClip) {
        this.setAnnotatedAudioClip(annotatedAudioClip);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.yScalesComponent = new JPanel();
        this.yScalesComponent.setLayout(null);
    }

    public void setAnnotatedAudioClip(AnnotatedAudioClip annotatedAudioClip) {
        AudioClip currAudioClip = this.getAudioSample();
        if (currAudioClip != null && currAudioClip instanceof AnnotatedAudioClip) {
            ((AnnotatedAudioClip)currAudioClip).removeBundleListener(this);
        }
        if (annotatedAudioClip != null) {
            annotatedAudioClip.addBundleListener(this);
        }
        super.setAudioSample((AudioClip)annotatedAudioClip);
        if (annotatedAudioClip != null) {
            Bundle b = annotatedAudioClip.getBundle();
            this.setBundle(b);
        }
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
        if (bundle != null) {
            List<Level> levels = bundle.getLevels();
            this.yScalesComponent.removeAll();
            this.yLabels.clear();
            for (Level level : levels) {
                JLabel yLabel = new JLabel(level.getName());
                this.yLabels.add(yLabel);
                this.yScalesComponent.add(yLabel);
            }
            this.doScalesLayout();
        }
        this.revalidate();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Font of;
        int prefHeight = 500;
        int tiersCount = 0;
        if (this.bundle != null) {
            List<Level> tiers = this.bundle.getLevels();
            tiersCount = tiers.size();
        }
        if ((of = this.getFont()) != null) {
            Font f = of.deriveFont(1);
            FontMetrics fontMetrics = this.getFontMetrics(f);
            int fontHeight = fontMetrics.getHeight();
            prefHeight = tiersCount * (fontHeight + 4);
            if (tiersCount > 1) {
                prefHeight += tiersCount - 1 * this.separatorHeight;
            }
        }
        return new Dimension(0, prefHeight);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        g.setColor(Color.BLACK);
        if (this.bundle != null) {
            List<Level> tiers = this.bundle.getLevels();
            int tiersCount = tiers.size();
            int availHeight = h;
            if (tiersCount > 1) {
                availHeight -= tiersCount - 1;
            }
            int tierHeight = availHeight / tiersCount;
            Font of = this.getFont();
            Font f = of.deriveFont(1);
            g.setFont(f);
            FontMetrics fontMetrics = this.getFontMetrics(f);
            int tierY = 0;
            for (int t = 0; t < tiersCount; ++t) {
                int itemXposition = 0;
                String lType = "ITEM";
                Level annotationTier = tiers.get(t);
                LevelDefinition ld = annotationTier.getDefinition();
                if (ld != null) {
                    lType = ld.getType();
                }
                List<Item> itemsList = annotationTier.getItems();
                int itemsCnt = itemsList.size();
                for (int i = 0; i < itemsCnt; ++i) {
                    Item item = itemsList.get(i);
                    if ("SEGMENT".equals(lType)) {
                        Item segItem = item;
                        int xl = this.mapFrameToPixel(segItem.getSampleStart());
                        int xr = this.mapFrameToPixel(segItem.getSampleStart() + segItem.getSampleDur());
                        Collection<Object> labelObjs = item.getLabelValues();
                        int labelsWidth = 0;
                        int labelsHeight = 0;
                        ArrayList<String> labelList = new ArrayList<String>();
                        for (Object labelObj : labelObjs) {
                            String label = labelObj.toString();
                            labelList.add(label);
                            Rectangle2D labelBounds = fontMetrics.getStringBounds(label, g);
                            int labelWidth = (int)labelBounds.getWidth();
                            if (labelsWidth < labelWidth) {
                                labelsWidth = labelWidth;
                            }
                            int labelHeight = (int)labelBounds.getHeight();
                            labelsHeight += labelHeight;
                            labelsHeight += 2;
                        }
                        int segmentWidth = xr - xl;
                        if (i > 0) {
                            g.drawLine(xl, tierY, xl, tierY + tierHeight);
                        }
                        int midx = xl + segmentWidth / 2 - labelsWidth / 2;
                        int midy = tierY + tierHeight / 2 + labelsHeight / 2;
                        for (String label : labelList) {
                            g.drawString(label, midx, midy);
                            Rectangle2D labelBounds = fontMetrics.getStringBounds(label, g);
                            int lblHeight = (int)labelBounds.getHeight();
                            midx -= lblHeight;
                        }
                        continue;
                    }
                    if ("EVENT".equals(lType)) {
                        EventItem m = (EventItem)item;
                        int x = this.mapFrameToPixel(m.getSamplepoint());
                        Collection<Object> labelObjs = item.getLabelValues();
                        Iterator<Object> objsIt = labelObjs.iterator();
                        Object lblObj = objsIt.next();
                        if (lblObj == null) continue;
                        String label = lblObj.toString();
                        Rectangle2D labelBounds = fontMetrics.getStringBounds(label, g);
                        int labelWidth = (int)labelBounds.getWidth();
                        int labelHeight = (int)labelBounds.getHeight();
                        g.drawLine(x, tierY, x, tierY + tierHeight);
                        int midx = x - labelWidth / 2;
                        int midy = tierY + tierHeight / 2 + labelHeight / 2;
                        g.drawString(label, midx, midy);
                        continue;
                    }
                    Collection<Object> labelObjs = item.getLabelValues();
                    Iterator<Object> objsIt = labelObjs.iterator();
                    Object lblObj = objsIt.next();
                    if (lblObj == null) continue;
                    String label = lblObj.toString();
                    Rectangle2D labelBounds = fontMetrics.getStringBounds(label, g);
                    int labelWidth = (int)labelBounds.getWidth();
                    int labelHeight = (int)labelBounds.getHeight();
                    g.drawLine(itemXposition, tierY, itemXposition, tierY + tierHeight);
                    int midy = tierY + tierHeight / 2 + labelHeight / 2;
                    g.drawString(label, itemXposition, midy);
                    itemXposition += labelWidth;
                    if (i >= itemsCnt - 1) continue;
                    g.drawLine(itemXposition, tierY, itemXposition, tierY + tierHeight);
                }
                tierY += tierHeight;
                if (t >= tiersCount - 1) continue;
                g.drawLine(0, tierY, w, tierY);
                ++tierY;
            }
        }
    }

    @Override
    public void bundleChanged(BundleChangedEvent event) {
        AudioClip currAudioClip = this.getAudioSample();
        Bundle b = null;
        if (currAudioClip != null && currAudioClip instanceof AnnotatedAudioClip) {
            b = ((AnnotatedAudioClip)currAudioClip).getBundle();
        }
        this.setBundle(b);
        this.revalidate();
        this.repaint();
    }

    public boolean isPreferredFixedHeight() {
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        long samplePosition = this.mapPixelToFrame(arg0.getX());
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    private boolean isInSelectorStart(int x) {
        int xStart = this.viewSelection.getXStart();
        return x >= xStart - this.selectorWidth && x <= xStart + this.selectorWidth;
    }

    private boolean isInSelectorEnd(int x) {
        int xEnd = this.viewSelection.getXEnd();
        return x >= xEnd - this.selectorWidth && x <= xEnd + this.selectorWidth;
    }

    private boolean isInSelectorLeft(int x) {
        int xLeft = this.viewSelection.getXLeft();
        return x >= xLeft - this.selectorWidth && x <= xLeft + this.selectorWidth;
    }

    private boolean isInSelectorRight(int x) {
        int xRight = this.viewSelection.getXRight();
        return x >= xRight - this.selectorWidth && x <= xRight + this.selectorWidth;
    }

    private Level tierAtViewPosition(int y) {
        Level tierAtViewPos = null;
        if (this.bundle != null) {
            List<Level> tiers = this.bundle.getLevels();
            int tiersCount = tiers.size();
            int h = this.getHeight();
            int tierandSepHeight = h / tiersCount;
            int tierIndx = y / tierandSepHeight;
            if (tierIndx >= tiersCount) {
                tierIndx = tiersCount - 1;
            }
            tierAtViewPos = tiers.get(tierIndx);
        }
        return tierAtViewPos;
    }

    private Item segmentAtPosition(Level selTier, long pos, boolean leftAligned) {
        if (this.bundle == null) {
            return null;
        }
        List<Item> items = selTier.getItems();
        Iterator<Item> iterator = items.iterator();
        while (iterator.hasNext()) {
            Item item;
            Item intervalItem = item = iterator.next();
            long sBeg = intervalItem.getSampleStart();
            long sEnd = sBeg + intervalItem.getSampleDur();
            if (!(leftAligned ? pos >= sBeg && pos < sEnd : pos > sBeg && pos <= sEnd)) continue;
            return intervalItem;
        }
        return null;
    }

    private void selectionByMouse(MouseEvent me) {
        if (this.dragStartEvent != null) {
            if (this.viewSelection != null) {
                Level selTier;
                this.viewSelection.limitTo(0L, this.length);
                Object sel = this.viewSelection.getSelection();
                if (this.snapToSegments && (selTier = this.tierAtViewPosition(me.getY())) != null) {
                    long selLeft = sel.getLeft();
                    Item leftSeg = this.segmentAtPosition(selTier, selLeft, true);
                    long selRight = sel.getRight();
                    Item rightSeg = this.segmentAtPosition(selTier, selRight, false);
                    sel = leftSeg != null && rightSeg != null ? new Selection(leftSeg.getSampleStart().longValue(), rightSeg.getSampleStart() + rightSeg.getSampleDur()) : null;
                }
                this.audioSample.setSelection(sel);
                this.repaint();
            }
            this.checkMouseResizeSelection(me);
        }
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.dragStartEvent = null;
        this.pressedEvent = null;
        this.selStartMoveEvent = null;
        this.selEndMoveEvent = null;
        if (arg0.isPopupTrigger()) {
            this.getParent().dispatchEvent(arg0);
        } else {
            int x = arg0.getX();
            if (this.viewSelection != null) {
                if (this.isInSelectorStart(x)) {
                    this.selStartMoveEvent = arg0;
                } else if (this.isInSelectorEnd(x)) {
                    this.selEndMoveEvent = arg0;
                } else {
                    this.pressedEvent = arg0;
                }
                this.repaint();
            } else {
                this.pressedEvent = arg0;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.getParent().dispatchEvent(arg0);
        } else {
            this.selectionByMouse(arg0);
        }
        this.dragStartEvent = null;
    }

    @Override
    public synchronized void mouseDragged(MouseEvent arg0) {
        if (this.pressedEvent != null) {
            this.dragStartEvent = this.pressedEvent;
            if (this.viewSelection == null) {
                this.viewSelection = new BasicAudioClipUI.ViewSelection((BasicAudioClipUI)this);
            }
            this.viewSelection.setXStart(this.dragStartEvent.getX());
            this.viewSelection.setXEnd(arg0.getX());
            this.repaint();
        } else if (this.selStartMoveEvent != null) {
            this.dragStartEvent = this.selStartMoveEvent;
            this.viewSelection.setXStart(arg0.getX());
            this.setCursor();
            this.repaint();
        } else if (this.selEndMoveEvent != null) {
            this.dragStartEvent = this.selEndMoveEvent;
            this.viewSelection.setXEnd(arg0.getX());
            this.setCursor();
            this.repaint();
        }
        if (this.changeSelectionOnDrag) {
            this.selectionByMouse(arg0);
        }
    }

    private void checkMouseResizeSelection(MouseEvent arg0) {
        int x = arg0.getX();
        if (this.viewSelection != null) {
            if (this.isInSelectorLeft(x)) {
                this.mouseOverResizeEast = null;
                this.mouseOverResizeWest = arg0;
            } else if (this.isInSelectorRight(x)) {
                this.mouseOverResizeEast = arg0;
                this.mouseOverResizeWest = null;
            } else {
                this.mouseOverResizeEast = null;
                this.mouseOverResizeWest = null;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        this.checkMouseResizeSelection(arg0);
        this.setCursor();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        StartPlaybackActionEvent pae = null;
        pae = new StartPlaybackActionEvent((Object)this, this.selection.getLeft(), this.selection.getRight());
        if (pae != null) {
            this.startPlaybackAction.actionPerformed((ActionEvent)pae);
        }
    }

    public void setStartPlaybackAction(StartPlaybackAction startPlaybackAction) {
        this.startPlaybackAction = startPlaybackAction;
        startPlaybackAction.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean enabled = ((Action)evt.getSource()).isEnabled();
    }

    private void setCursor() {
        if (this.dragStartEvent != null) {
            if (this.dragStartEvent == this.selStartMoveEvent) {
                this.setCursor(Cursor.getPredefinedCursor(10));
            } else if (this.dragStartEvent == this.selStartMoveEvent) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            }
        } else if (this.mouseOverResizeWest != null) {
            this.setCursor(Cursor.getPredefinedCursor(10));
        } else if (this.mouseOverResizeEast != null) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void doScalesLayout() {
        int compH = this.getSize().height;
        int borderLength = 2;
        int yLblCnt = this.yLabels.size();
        if (yLblCnt > 0) {
            JLabel yLabel;
            int i;
            int scaleHeight = (compH - 2 * borderLength) / yLblCnt;
            int scaleWidth = 0;
            for (i = 0; i < yLblCnt; ++i) {
                yLabel = this.yLabels.get(i);
                if (yLabel == null) continue;
                Dimension scalePrefSize = yLabel.getPreferredSize();
                int sW = scalePrefSize.width;
                if (sW <= scaleWidth) continue;
                scaleWidth = sW;
            }
            for (i = 0; i < yLblCnt; ++i) {
                yLabel = this.yLabels.get(i);
                if (yLabel == null) continue;
                int sYPos = borderLength + scaleHeight * i;
                Dimension scalePrefSize = yLabel.getPreferredSize();
                int sW = scalePrefSize.width;
                yLabel.setBounds(scaleWidth - sW, sYPos, sW, scaleHeight);
                yLabel.doLayout();
            }
            Dimension preferredSize = new Dimension(scaleWidth, compH);
            this.yScalesComponent.setPreferredSize(preferredSize);
        } else {
            Dimension preferredSize = new Dimension(0, compH);
            this.yScalesComponent.setPreferredSize(preferredSize);
        }
        this.yScalesComponent.doLayout();
        this.yScalesComponent.repaint();
    }

    public void doLayout() {
        super.doLayout();
        this.doScalesLayout();
    }

    public JComponent[] getYScales() {
        return new JComponent[]{this.yScalesComponent};
    }
}

