/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.autoannotator.impl.ws.bas;

import ips.annot.autoannotator.AutoAnnotation;
import ips.annot.autoannotator.AutoAnnotationServiceDescriptor;
import ips.annot.autoannotator.AutoAnnotator;
import ips.annot.autoannotator.AutoAnnotatorException;
import ips.annot.model.PredefinedLevelDefinition;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.dom.DocUtils;
import ipsk.audio.ThreadSafeAudioSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class BasicBasServiceClient
implements AutoAnnotator {
    private static final boolean DEBUG = false;
    protected static String BASE_URL = "https://clarin.phonetik.uni-muenchen.de/BASWebServices/services";
    protected static String CMDI_URL = "http://clarin.phonetik.uni-muenchen.de/BASRepository/Public/WebServices/BAS_Webservices.cmdi.xml";
    private static String PARAM_LANG = "LANGUAGE";
    public static final String RESPONSE_XML_TOP_ELEM = "WebServiceResponseLink";
    public static final String RESPONSE_XML_DOWNLOAD_ELEM = "downloadLink";
    public static final String RESPONSE_XML_SUCCESS_ELEM = "success";
    public static final String RESPONSE_XML_OUTPUT_ELEM = "output";
    public static final String RESPONSE_XML_WARNINGS_ELEM = "warnings";
    protected AutoAnnotator.AnnotationRequest annotationRequest;
    protected ServerCaps serverCaps = null;
    protected static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    protected static final ContentType DEFAULT_TEXT_CONTENT_TYPE = ContentType.create((String)"text/plain", (Charset)DEFAULT_CHARSET);
    protected DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();

    protected synchronized void getServerCaps() throws ParserConfigurationException, SAXException, IOException {
        if (this.serverCaps == null) {
            ArrayList<String> supportedLangs = new ArrayList<String>();
            DocumentBuilder db = this.docBuilderFactory.newDocumentBuilder();
            Document cmdiDoc = db.parse(CMDI_URL);
            DocUtils docUtils = new DocUtils(cmdiDoc);
            List basServiceElems = docUtils.getElementsByTagName(new String[]{"CMD", "Components"}, "BASWebService");
            if (basServiceElems != null && basServiceElems.size() == 1) {
                Element paramElem;
                Element inputElement;
                Element opElem;
                Element opsElem;
                Element serviceElem = DocUtils.getFirstElementByTagNameWith((Element)((Element)basServiceElems.get(0)), (String)"Service", (String)"Name", (String)"BAS Webservices");
                if (serviceElem != null && (opsElem = DocUtils.getFirstElementByTagName((Element)serviceElem, (String)"Operations")) != null && (opElem = DocUtils.getFirstElementByTagNameWith((Element)opsElem, (String)"Operation", (String)"Name", (String)"runMAUSBasic")) != null && (inputElement = DocUtils.getFirstElementByTagName((Element)opElem, (String)"Input")) != null && (paramElem = DocUtils.getFirstElementByTagNameWith((Element)opElem, (String)"Parameter", (String)"Name", (String)PARAM_LANG)) != null) {
                    List valueElems = DocUtils.getElementsByTagName((Element)paramElem, (String)"ParameterValue");
                    for (Element valE : valueElems) {
                        Element vEl = DocUtils.getFirstElementByTagName((Element)valE, (String)"Value");
                        String langISO639ThreeLetter = vEl.getTextContent();
                        supportedLangs.add(langISO639ThreeLetter);
                    }
                }
                this.serverCaps = new ServerCaps();
                this.serverCaps.setSupportedLangs(supportedLangs);
            }
        }
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void setAnnotationRequest(AutoAnnotator.AnnotationRequest ar) {
        this.annotationRequest = ar;
    }

    protected boolean isMediafileSupported(File mediaFile) throws IOException {
        try {
            AudioFileFormat aff = ThreadSafeAudioSystem.getAudioFileFormat((File)mediaFile);
            AudioFormat af = aff.getFormat();
            return AudioFormat.Encoding.PCM_SIGNED.equals(af.getEncoding()) && af.getChannels() == 1;
        }
        catch (UnsupportedAudioFileException e) {
            return false;
        }
    }

    protected boolean isLanguageSupported(Locale reqLocale) {
        try {
            this.getServerCaps();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.serverCaps != null) {
            String reqISO_3_lang = reqLocale.getISO3Language();
            List<String> suppLangsISO639_3 = this.serverCaps.getSupportedLangs();
            return suppLangsISO639_3.contains(reqISO_3_lang);
        }
        return false;
    }

    @Override
    public boolean isBundleSupported(Bundle bundle) throws IOException {
        Locale l = bundle.getLocale();
        if (l == null) {
            return false;
        }
        boolean langSupp = this.isLanguageSupported(l);
        List<String> sigPaths = bundle.getSignalpaths();
        if (sigPaths.size() == 0) {
            return false;
        }
        File sigFile = new File(sigPaths.get(0));
        boolean mSupp = this.isMediafileSupported(sigFile);
        return langSupp && mSupp;
    }

    protected void parseResponseHeader(HttpEntity resEntity) {
        Header contentTypeHeader = resEntity.getContentType();
        if (contentTypeHeader != null) {
            String ctHeNm = contentTypeHeader.getName();
            String ctHeVal = contentTypeHeader.getValue();
            HeaderElement[] hes = contentTypeHeader.getElements();
            if (hes != null) {
                HeaderElement[] headerElementArray = hes;
                int n = hes.length;
                int n2 = 0;
                while (n2 < n) {
                    HeaderElement he = headerElementArray[n2];
                    String heName = he.getName();
                    String heval = he.getValue();
                    int pc = he.getParameterCount();
                    int i = 0;
                    while (i < pc) {
                        NameValuePair nameValuePair = he.getParameter(i);
                        ++i;
                    }
                    ++n2;
                }
            }
        }
    }

    protected URL downloadLinkFromResponse(InputStream response) throws AutoAnnotatorException {
        Element e;
        Node n;
        String downloadLink = null;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(response);
        }
        catch (ParserConfigurationException e1) {
            throw new AutoAnnotatorException(e1);
        }
        catch (SAXException e2) {
            throw new AutoAnnotatorException(e2);
        }
        catch (IOException e3) {
            throw new AutoAnnotatorException(e3);
        }
        NodeList wsResLnkNl = doc.getElementsByTagName(RESPONSE_XML_TOP_ELEM);
        int wsResLnkNlLen = wsResLnkNl.getLength();
        if (wsResLnkNlLen < 1) {
            throw new AutoAnnotatorException("Expected one XML element \"WebServiceResponseLink\"");
        }
        if (wsResLnkNlLen > 1) {
            throw new AutoAnnotatorException("Expected exactly one XML element \"WebServiceResponseLink\". Found " + wsResLnkNlLen + " elements.");
        }
        Node wsResLnkN = wsResLnkNl.item(0);
        NodeList nl = wsResLnkN.getChildNodes();
        int dlLen = nl.getLength();
        boolean success = false;
        String output = null;
        String warnings = null;
        int i = 0;
        while (i < dlLen) {
            n = nl.item(i);
            if (n instanceof Element) {
                String successStr;
                e = (Element)n;
                if (RESPONSE_XML_SUCCESS_ELEM.equals(e.getNodeName()) && !(success = Boolean.parseBoolean(successStr = e.getTextContent()))) {
                    System.out.println(doc.toString());
                }
                if (RESPONSE_XML_OUTPUT_ELEM.equals(e.getNodeName())) {
                    output = e.getTextContent();
                }
                if (RESPONSE_XML_WARNINGS_ELEM.equals(e.getNodeName())) {
                    warnings = e.getTextContent();
                }
            }
            ++i;
        }
        if (!success) {
            String msg = "Bas web service result unsuccessful";
            if (output != null && !"".equals(output)) {
                msg = msg.concat(",output: " + output);
            }
            if (warnings != null && !"".equals(warnings)) {
                msg = msg.concat(",warnings: " + warnings);
            }
            throw new AutoAnnotatorException(msg);
        }
        i = 0;
        while (i < dlLen) {
            n = nl.item(i);
            if (n instanceof Element && RESPONSE_XML_DOWNLOAD_ELEM.equals((e = (Element)n).getNodeName())) {
                URL dlUrl;
                if (downloadLink != null) {
                    throw new AutoAnnotatorException("Expected exactly one XML element \"downloadLink\" in WebMAUS response.");
                }
                downloadLink = e.getTextContent();
                try {
                    dlUrl = new URL(downloadLink);
                }
                catch (MalformedURLException e1) {
                    throw new AutoAnnotatorException(e1);
                }
                return dlUrl;
            }
            ++i;
        }
        return null;
    }

    protected File masterSignalFile(Bundle bundle) {
        String sigPath;
        File audioFile;
        List<String> sigPaths = bundle.getSignalpaths();
        if (sigPaths != null && sigPaths.size() == 1 && (audioFile = new File(sigPath = sigPaths.get(0))) != null && audioFile.exists()) {
            return audioFile;
        }
        return null;
    }

    protected String orthoGraphyTextFromTemplateLevel(Bundle bundle) {
        String templateText;
        Item it;
        Map<String, Object> itLbls;
        Object itLbl;
        List<Item> its;
        Level tplLvl = bundle.getTierByName(PredefinedLevelDefinition.TPL.getKeyName());
        if (tplLvl != null && (its = tplLvl.getItems()).size() == 1 && (itLbl = (itLbls = (it = its.get(0)).getLabels()).get(PredefinedLevelDefinition.TPL.getKeyName())) instanceof String && (templateText = (String)itLbl) != null) {
            return templateText;
        }
        return null;
    }

    @Override
    public boolean needsWorker() {
        return true;
    }

    @Override
    public abstract AutoAnnotation call() throws Exception;

    public abstract AutoAnnotationServiceDescriptor getServiceDescriptor();

    public class ServerCaps {
        private List<String> supportedLangs;

        public List<String> getSupportedLangs() {
            return this.supportedLangs;
        }

        public void setSupportedLangs(List<String> supportedLangs) {
            this.supportedLangs = supportedLangs;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.supportedLangs != null) {
                sb.append("Supported languages: ");
                int suppLanglen = this.supportedLangs.size();
                int i = 0;
                while (i < suppLanglen) {
                    String suppLang = this.supportedLangs.get(i);
                    sb.append(suppLang);
                    if (i < suppLanglen - 1) {
                        sb.append(',');
                    }
                    ++i;
                }
            }
            return sb.toString();
        }
    }
}

