/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.partitur;

import ips.annot.model.PredefinedLevelDefinition;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.Item;
import ips.annot.model.db.Label;
import ips.annot.model.db.Level;
import ips.annot.model.db.LevelDefinition;
import ips.annot.model.db.Link;
import ips.annot.model.db.LinkDefinition;
import ipsk.text.Version;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioFormat;
import org.apache.http.ParseException;

public class PartiturParser {
    public static Version PARTITUR_VERSION = new Version(new int[]{1, 3});
    public static long VOID_SYM_LINK = -1L;
    private AudioFormat audioFormat = null;
    private String recordingLocation = null;
    private String speakerID = null;
    private Set<LinkDefinition> linkDefinitions;
    private Pattern whiteSpacePattern = Pattern.compile("\\s+");

    public Set<LinkDefinition> getLinkDefinitions() {
        return this.linkDefinitions;
    }

    public void setLinkDefinitions(Set<LinkDefinition> linkDefinitions) {
        this.linkDefinitions = linkDefinitions;
    }

    public PartiturParser() {
    }

    public PartiturParser(AudioFormat audioFormat) {
        this(audioFormat, "", "");
    }

    public PartiturParser(AudioFormat audioFormat, String recordingLocation, String speakerID) {
        this();
        this.audioFormat = audioFormat;
        this.recordingLocation = recordingLocation;
        this.speakerID = speakerID;
    }

    private Level levelByNameCreateIfNotExists(Bundle bundle, String name, String type) {
        List<Level> lvls = bundle.getLevels();
        Level lvl = null;
        for (Level l : lvls) {
            if (!name.equals(l.getName())) continue;
            lvl = l;
            break;
        }
        if (lvl == null) {
            lvl = new Level();
            lvl.setName(name);
            lvl.setType(type);
            lvls.add(lvl);
        }
        return lvl;
    }

    public Bundle parse(Bundle bundle, Reader kanCont) throws IOException {
        LineNumberReader lnr = new LineNumberReader(kanCont);
        String line = null;
        if (bundle == null) {
            bundle = new Bundle();
        }
        Integer hstId = bundle.highestID();
        int idOffset = 0;
        if (hstId != null) {
            idOffset = hstId;
        }
        int idCnt = idOffset;
        ArrayList<Item> parIts = new ArrayList<Item>();
        while ((line = lnr.readLine()) != null) {
            String trimmedLine = line.trim();
            if ("".equals(trimmedLine)) continue;
            String[] splt = trimmedLine.split(":", 2);
            String lvlNm = splt[0];
            Item pi = null;
            if ("KAN".equals(lvlNm) || "ORT".equals(lvlNm)) {
                String liStr = splt[1].trim();
                String[] stringArray = liStr.split("\\s+", 2);
                String lnkStr = stringArray[0];
                String lbl = stringArray[1].trim();
                long lnkId = Long.parseLong(lnkStr);
                pi = lnkId == VOID_SYM_LINK ? new PartiturItem(lvlNm, lbl) : new PartiturItem(lvlNm, lbl, lnkId);
                Level lvl = this.levelByNameCreateIfNotExists(bundle, lvlNm, "ITEM");
                pi.setLevel(lvl);
                lvl.getItems().add(pi);
            } else if ("MAU".equals(lvlNm)) {
                String segStr = splt[1].trim();
                String[] stringArray = segStr.split("\\s+", 4);
                long start = Long.parseLong(stringArray[0]);
                long dur = Long.parseLong(stringArray[1]);
                String lnkStr = stringArray[2];
                String string = stringArray[3].trim();
                long lnkId = Long.parseLong(lnkStr);
                pi = lnkId == VOID_SYM_LINK ? new PartiturItem(lvlNm, string) : new PartiturItem(lvlNm, string, lnkId);
                pi.setSampleStart(start);
                pi.setSampleDur(dur);
                Level lvl = this.levelByNameCreateIfNotExists(bundle, lvlNm, "SEGMENT");
                pi.setLevel(lvl);
                lvl.getItems().add(pi);
            }
            if (pi == null) continue;
            pi.setBundleId(++idCnt);
            parIts.add(pi);
        }
        HashSet<Link> links = new HashSet<Link>();
        if (this.linkDefinitions != null) {
            for (LinkDefinition ld : this.linkDefinitions) {
                LevelDefinition fromLvl = ld.getSuperLevel();
                LevelDefinition toLvl = ld.getSubLevel();
                for (PartiturItem partiturItem : parIts) {
                    Long parSl;
                    Label pLbl = partiturItem.getLabelsList().get(0);
                    String lvlNm = pLbl.getName();
                    if (!lvlNm.equals(fromLvl.getName()) || (parSl = partiturItem.getBpfSymLink()) == null) continue;
                    String parSlstr = parSl.toString();
                    for (PartiturItem partiturItem2 : parIts) {
                        String parSlTostr;
                        Long parSlTo;
                        Label pLblTo = partiturItem2.getLabelsList().get(0);
                        String lvlNmTo = pLblTo.getName();
                        if (!lvlNmTo.equals(toLvl.getName()) || (parSlTo = partiturItem2.getBpfSymLink()) == null || !parSlstr.equals(parSlTostr = parSlTo.toString())) continue;
                        Link nl = new Link();
                        nl.setLabel(parSlstr);
                        nl.setFrom(partiturItem);
                        nl.setTo(partiturItem2);
                        links.add(nl);
                    }
                }
            }
        }
        bundle.getLinksAsSet().addAll(links);
        return bundle;
    }

    private String buildHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("LHD: Partitur " + PARTITUR_VERSION.toString());
        if (this.recordingLocation != null) {
            sb.append("REP: " + this.recordingLocation);
        }
        if (this.audioFormat != null) {
            sb.append("SNB: " + this.audioFormat.getFrameSize() / this.audioFormat.getChannels());
            sb.append("SAM: " + this.audioFormat.getSampleRate());
            String sbf = this.audioFormat.isBigEndian() ? "01" : "10";
            sb.append("SBF: " + sbf);
            sb.append("SSB: " + this.audioFormat.getSampleSizeInBits());
            sb.append("NCH: " + this.audioFormat.getChannels());
        }
        if (this.speakerID != null) {
            sb.append("SPN: " + this.speakerID);
        }
        sb.append("LBD:");
        return sb.toString();
    }

    public String write(Bundle bundle) {
        StringBuffer parContBuf = new StringBuffer();
        parContBuf.append(this.buildHeader());
        List<Level> lvls = bundle.getLevels();
        String lvlCont = this.writeLevels(lvls, bundle.getLinksAsSet());
        parContBuf.append(lvlCont);
        return parContBuf.toString();
    }

    public String writeLevels(List<Level> levelList, Set<Link> links) {
        StringBuffer parContBuf = new StringBuffer();
        int symLinkCnt = 0;
        HashSet<Link> linksCopy = new HashSet<Link>();
        for (Link l : links) {
            Link lc = new Link();
            lc.setFrom(l.getFrom());
            lc.setTo(l.getTo());
            linksCopy.add(lc);
        }
        for (Level level : levelList) {
            String lvlType = level.getType();
            List<Item> its = level.getItems();
            for (Item it : its) {
                String llbl = null;
                Integer itId = it.getBundleId();
                for (Link link : linksCopy) {
                    int fromId = link.getFromID();
                    int toId = link.getToID();
                    if (fromId != itId && toId != itId || (llbl = link.getLabel()) != null) continue;
                    llbl = Integer.toString(symLinkCnt++);
                    link.setLabel(llbl);
                }
                List<Label> lblsList = it.getLabelsList();
                for (Label lbl : lblsList) {
                    String key = lbl.getName();
                    String val = lbl.getValueString();
                    parContBuf.append(key);
                    parContBuf.append(": ");
                    if ("ITEM".equals(lvlType)) {
                        if (llbl != null) {
                            parContBuf.append(llbl);
                            parContBuf.append(" ");
                        }
                        parContBuf.append(val);
                        parContBuf.append("\n");
                        continue;
                    }
                    throw new ParseException("Writing of level type " + lvlType + " currenty not supported!");
                }
            }
        }
        return parContBuf.toString();
    }

    public static void main(String[] args) {
        StringBuffer test = new StringBuffer("KAN: 0 ?aInts@ltsIm6\nKAN: 1 tsvaIhUnd6t?axtUntfi:rtsIC\nKAN: 2 mark\n");
        test.append("ORT: 0 Einzelzimmer\nORT: 1 zweihundertachtundvierzig\nORT: 2 Mark\n");
        test.append("MAU:    0   639 -1  <p:>\nMAU:    640 479 0   ?\nMAU:    1120    799 0   aI\nMAU:    1920    639 0   n\n");
        StringReader sr = new StringReader(test.toString());
        PartiturParser pp = new PartiturParser();
        HashSet<LinkDefinition> linkDefs = new HashSet<LinkDefinition>();
        LinkDefinition kanMauLd = new LinkDefinition();
        kanMauLd.setSuperLevel(PredefinedLevelDefinition.KAN.getLevelDefinition());
        kanMauLd.setSubLevel(PredefinedLevelDefinition.MAU.getLevelDefinition());
        kanMauLd.setType("ONE_TO_MANY");
        linkDefs.add(kanMauLd);
        pp.setLinkDefinitions(linkDefs);
        try {
            Bundle bundle = pp.parse(null, sr);
            System.out.println(bundle);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class PartiturItem
    extends Item {
        private Long bpfSymLink = null;

        public Long getBpfSymLink() {
            return this.bpfSymLink;
        }

        public void setBpfSymLink(Long bpfSymLink) {
            this.bpfSymLink = bpfSymLink;
        }

        public PartiturItem() {
        }

        public PartiturItem(String lvl, String label, Long symLink) {
            this();
            this.getLabels().put(lvl, label);
            this.bpfSymLink = symLink;
        }

        public PartiturItem(String lvl, String label) {
            this(lvl, label, null);
        }
    }
}

