/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.textgrid;

import ips.annot.io.BundleAnnotationFilePersistor;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.Level;
import ips.annot.model.db.LevelDefinition;
import ips.annot.textgrid.TextGridFileParser;
import ipsk.audio.ajs.AJSAudioSystem;
import ipsk.text.EncodeException;
import ipsk.text.ParserException;
import ipsk.text.Version;
import ipsk.util.LocalizableMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.UnsupportedAudioFileException;

public class TextGridFilePersistor
implements BundleAnnotationFilePersistor {
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private File file;
    private LevelDefinition levelDefinition;
    private Charset charset = Charset.forName("UTF-8");
    private TextGridFileParser parser;

    @Override
    public boolean isLossless() {
        return false;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    private float deriveSampleRate(Bundle bundle) throws EncodeException, IOException, UnsupportedAudioFileException {
        Float bSr = bundle.getSampleRate();
        if (bSr != null) {
            return bSr.floatValue();
        }
        List<String> sps = bundle.getSignalpaths();
        if (sps == null || sps.size() == 0) {
            throw new EncodeException("Bundle has no audio file! Cannot determine sample rate for TextGrid.");
        }
        String sp = sps.get(0);
        File sf = new File(sp);
        if (!sf.exists()) {
            throw new EncodeException("Bundle audio file " + sf + " does not exist.");
        }
        AudioFileFormat aff = AJSAudioSystem.getAudioFileFormat((File)sf);
        return aff.getFormat().getSampleRate();
    }

    @Override
    public void write(Bundle bundle) throws IOException, EncodeException {
        float sr;
        List<Level> lvls = bundle.getLevels();
        if (lvls == null || lvls.size() == 0) {
            throw new EncodeException("Praat TextGrid file must have at least one level (tier)");
        }
        try {
            sr = this.deriveSampleRate(bundle);
        }
        catch (UnsupportedAudioFileException e) {
            throw new EncodeException((Throwable)e);
        }
        FileOutputStream fos = new FileOutputStream(this.file);
        try (OutputStreamWriter wr = new OutputStreamWriter((OutputStream)fos, this.charset);){
            TextGridFileParser parser = new TextGridFileParser(sr);
            parser.write(bundle, wr);
        }
    }

    @Override
    public String getPreferredFileExtension() {
        return "TextGrid";
    }

    @Override
    public Bundle load() throws IOException, ParserException {
        throw new ParserException("TextGrid parser requires existing bundle to get samplerate from signal file. Use load(Bundle) method instead.");
    }

    @Override
    public Bundle load(Bundle bundle) throws IOException, ParserException {
        float sampleRate;
        if (bundle == null) {
            throw new ParserException("TextGrid parser requires existing non-null bundle to get samplerate from signal file.");
        }
        try {
            sampleRate = this.deriveSampleRate(bundle);
        }
        catch (EncodeException e) {
            throw new ParserException((Throwable)e);
        }
        catch (UnsupportedAudioFileException e) {
            throw new ParserException((Throwable)e);
        }
        TextGridFileParser parser = new TextGridFileParser(sampleRate);
        Bundle b = parser.parse(this.file, this.charset);
        bundle.getLevels().addAll(b.getLevels());
        return bundle;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public LevelDefinition getLevelDefinition() {
        return this.levelDefinition;
    }

    public void setLevelDefinition(LevelDefinition levelDefinition) {
        this.levelDefinition = levelDefinition;
    }

    public void setLevelDefinitionKeyName(String levelDefinitionKeyName) {
        this.levelDefinition = new LevelDefinition();
        this.levelDefinition.setName(levelDefinitionKeyName);
    }

    public String getServiceImplementationClassname() {
        return this.getClass().getName();
    }

    public LocalizableMessage getTitle() {
        return new LocalizableMessage("TextGrid loader/writer");
    }

    public LocalizableMessage getDescription() {
        return new LocalizableMessage("Loader/writer for Praat TextGrid annotation files.");
    }

    public String getVendor() {
        return "Institut of Phonetics and Speech Processing";
    }

    public Version getSpecificationVersion() {
        int[] nArray = new int[3];
        nArray[2] = 1;
        return new Version(nArray);
    }

    public Version getImplementationVersion() {
        int[] nArray = new int[3];
        nArray[2] = 1;
        return new Version(nArray);
    }

    @Override
    public String getPreferredFilenameSuffix() {
        return "";
    }

    public String[] getLinks() {
        return new String[]{"http://www.praat.org"};
    }

    @Override
    public boolean isWritable(Bundle bundle) {
        List<Level> lvls = bundle.getLevels();
        return lvls != null && lvls.size() > 0;
    }
}

