/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.view;

import ips.annot.model.AnnotatedAudioClip;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.EventItem;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.annot.model.db.LevelDefinition;
import ips.annot.model.db.Link;
import ips.annot.model.event.BundleChangedEvent;
import ips.annot.model.event.BundleListener;
import ipsk.audio.actions.StartPlaybackAction;
import ipsk.audio.arr.Selection;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.ui.BasicAudioClipUI;
import ipsk.audio.events.StartPlaybackActionEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AnnotationAudioClipUI
extends BasicAudioClipUI
implements BundleListener,
MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private Bundle bundle;
    private MouseEvent pressedEvent = null;
    private MouseEvent dragStartEvent = null;
    private MouseEvent selEndMoveEvent;
    private MouseEvent selStartMoveEvent;
    private MouseEvent mouseOverResizeWest;
    private MouseEvent mouseOverResizeEast;
    private int selectorWidth = 5;
    private boolean changeSelectionOnDrag = false;
    private boolean snapToSegments = true;
    private int separatorHeight = 1;
    private List<JLabel> yLabels = new ArrayList<JLabel>();
    private JPanel yScalesComponent = new JPanel();
    private StartPlaybackAction startPlaybackAction;

    public String getName() {
        return "Annotation";
    }

    public AnnotationAudioClipUI(AnnotatedAudioClip annotatedAudioClip) {
        this.yScalesComponent.setLayout(null);
        this.setAnnotatedAudioClip(annotatedAudioClip);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setAnnotatedAudioClip(AnnotatedAudioClip annotatedAudioClip) {
        AudioClip currAudioClip = this.getAudioSample();
        if (currAudioClip != null && currAudioClip instanceof AnnotatedAudioClip) {
            ((AnnotatedAudioClip)currAudioClip).removeBundleListener(this);
        }
        if (annotatedAudioClip != null) {
            annotatedAudioClip.addBundleListener(this);
        }
        super.setAudioSample((AudioClip)annotatedAudioClip);
        Bundle b = null;
        if (annotatedAudioClip != null) {
            b = annotatedAudioClip.getBundle();
        }
        this.setBundle(b);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
        this.yScalesComponent.removeAll();
        this.yLabels.clear();
        if (bundle != null) {
            List<Level> levels = bundle.getLevels();
            for (Level level : levels) {
                JLabel yLabel = new JLabel(level.getName());
                this.yLabels.add(yLabel);
                this.yScalesComponent.add(yLabel);
            }
            this.doScalesLayout();
        }
        this.yScalesComponent.repaint();
        this.revalidate();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Font of;
        int prefHeight = 500;
        int tiersCount = 0;
        if (this.bundle != null) {
            List<Level> tiers = this.bundle.getLevels();
            tiersCount = tiers.size();
        }
        if ((of = this.getFont()) != null) {
            Font f = of.deriveFont(1);
            FontMetrics fontMetrics = this.getFontMetrics(f);
            int fontHeight = fontMetrics.getHeight();
            prefHeight = tiersCount * (fontHeight + 4);
            if (tiersCount > 1) {
                prefHeight += tiersCount - 1 * this.separatorHeight;
            }
        }
        return new Dimension(0, prefHeight);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, w, h);
        g.setColor(Color.BLACK);
        if (this.bundle != null) {
            List<Level> tiers = this.bundle.getLevels();
            int tiersCount = tiers.size();
            int availHeight = h;
            if (tiersCount > 1) {
                availHeight -= tiersCount - 1;
            }
            int tierHeight = availHeight / tiersCount;
            Font of = this.getFont();
            Font f = of.deriveFont(1);
            g.setFont(f);
            FontMetrics fontMetrics = this.getFontMetrics(f);
            int tierY = 0;
            int t = 0;
            while (t < tiersCount) {
                int itemXposition = 0;
                String lType = "ITEM";
                Level annotationTier = tiers.get(t);
                LevelDefinition ld = annotationTier.getDefinition();
                if (ld != null) {
                    lType = ld.getType();
                }
                List<Item> itemsList = annotationTier.getItems();
                int itemsCnt = itemsList.size();
                int i = 0;
                while (i < itemsCnt) {
                    Collection<Object> labelObjs;
                    Item item = itemsList.get(i);
                    Long sampleStart = null;
                    Long sampleEnd = null;
                    if ("SEGMENT".equals(lType)) {
                        sampleStart = item.getSampleStart();
                        sampleEnd = sampleStart + item.getSampleDur();
                    } else {
                        sampleStart = this.bundle.startByLinkedSegmentItems(item);
                        if (sampleStart != null) {
                            sampleEnd = this.bundle.endByLinkedSegmentItems(item);
                        }
                    }
                    if (sampleStart != null && sampleEnd != null) {
                        int xl = this.mapFrameToPixel(sampleStart);
                        int xr = this.mapFrameToPixel(sampleEnd);
                        labelObjs = item.getLabelValues();
                        int labelsWidth = 0;
                        int labelsHeight = 0;
                        ArrayList<String> labelList = new ArrayList<String>();
                        for (Object labelObj : labelObjs) {
                            String label = labelObj.toString();
                            labelList.add(label);
                            Rectangle2D labelBounds = fontMetrics.getStringBounds(label, g);
                            int labelWidth = (int)labelBounds.getWidth();
                            if (labelsWidth < labelWidth) {
                                labelsWidth = labelWidth;
                            }
                            int labelHeight = (int)labelBounds.getHeight();
                            labelsHeight += labelHeight;
                            labelsHeight += 2;
                        }
                        int segmentWidth = xr - xl;
                        g.setColor(Color.WHITE);
                        g.fillRect(xl, tierY, segmentWidth, tierHeight);
                        g.setColor(Color.BLACK);
                        g.drawLine(xl, tierY, xl, tierY + tierHeight);
                        g.drawLine(xr, tierY, xr, tierY + tierHeight);
                        int midx = xl + segmentWidth / 2 - labelsWidth / 2;
                        int midy = tierY + tierHeight / 2 + labelsHeight / 2;
                        for (String label : labelList) {
                            g.drawString(label, midx, midy);
                            Rectangle2D labelBounds = fontMetrics.getStringBounds(label, g);
                            int lblHeight = (int)labelBounds.getHeight();
                            midx -= lblHeight;
                        }
                    } else if ("EVENT".equals(lType)) {
                        EventItem m = (EventItem)item;
                        int x = this.mapFrameToPixel(m.getSamplepoint());
                        labelObjs = item.getLabelValues();
                        Iterator<Object> objsIt = labelObjs.iterator();
                        Object lblObj = objsIt.next();
                        if (lblObj != null) {
                            String label = lblObj.toString();
                            Rectangle2D labelBounds = fontMetrics.getStringBounds(label, g);
                            int labelWidth = (int)labelBounds.getWidth();
                            int labelHeight = (int)labelBounds.getHeight();
                            int midx = x - labelWidth / 2;
                            int midy = tierY + tierHeight / 2 + labelHeight / 2;
                            g.setColor(Color.WHITE);
                            g.fillRect(midx - labelWidth / 2, tierY, labelWidth, tierHeight);
                            g.setColor(Color.BLACK);
                            g.drawLine(x, tierY, x, tierY + tierHeight);
                            g.drawString(label, midx, midy);
                        }
                    } else {
                        Object lblObj;
                        Collection<Object> labelObjs2 = item.getLabelValues();
                        Iterator<Object> objsIt = labelObjs2.iterator();
                        if (objsIt.hasNext() && (lblObj = objsIt.next()) != null) {
                            String label = lblObj.toString();
                            Rectangle2D labelBounds = fontMetrics.getStringBounds(label, g);
                            int labelWidth = (int)labelBounds.getWidth();
                            int labelHeight = (int)labelBounds.getHeight();
                            g.drawLine(itemXposition, tierY, itemXposition, tierY + tierHeight);
                            int midy = tierY + tierHeight / 2 + labelHeight / 2;
                            g.setColor(Color.WHITE);
                            g.fillRect(0, tierY, w, tierHeight);
                            g.setColor(Color.BLACK);
                            g.drawString(label, itemXposition, midy);
                            itemXposition += labelWidth;
                            if (i < itemsCnt - 1) {
                                g.drawLine(itemXposition, tierY, itemXposition, tierY + tierHeight);
                            }
                        }
                    }
                    ++i;
                }
                tierY += tierHeight;
                if (t < tiersCount - 1) {
                    g.drawLine(0, tierY, w, tierY);
                    ++tierY;
                }
                ++t;
            }
        }
    }

    @Override
    public void bundleChanged(BundleChangedEvent event) {
        AudioClip currAudioClip = this.getAudioSample();
        Bundle b = null;
        if (currAudioClip != null && currAudioClip instanceof AnnotatedAudioClip) {
            b = ((AnnotatedAudioClip)currAudioClip).getBundle();
        }
        this.setBundle(b);
        this.revalidate();
        this.repaint();
    }

    public boolean isPreferredFixedHeight() {
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        long samplePosition = this.mapPixelToFrame(arg0.getX());
        Level sLvl = this.tierAtViewPosition(arg0.getY());
        if (sLvl != null) {
            Long start = 0L;
            Long end = -1L;
            Item sIt = this.segmentAtPosition(sLvl, samplePosition);
            if (sIt != null) {
                Long itEnd;
                Long itStart = this.bundle.startByLinkedSegmentItems(sIt);
                if (itStart != null && (itEnd = this.bundle.endByLinkedSegmentItems(sIt)) != null) {
                    start = itStart;
                    end = itEnd;
                }
                StartPlaybackActionEvent spae = new StartPlaybackActionEvent((Object)this, start.longValue(), end.longValue());
                if (this.startPlaybackAction.isEnabled()) {
                    this.startPlaybackAction.actionPerformed((ActionEvent)spae);
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    private boolean isInSelectorStart(int x) {
        int xStart = this.viewSelection.getXStart();
        return x >= xStart - this.selectorWidth && x <= xStart + this.selectorWidth;
    }

    private boolean isInSelectorEnd(int x) {
        int xEnd = this.viewSelection.getXEnd();
        return x >= xEnd - this.selectorWidth && x <= xEnd + this.selectorWidth;
    }

    private boolean isInSelectorLeft(int x) {
        int xLeft = this.viewSelection.getXLeft();
        return x >= xLeft - this.selectorWidth && x <= xLeft + this.selectorWidth;
    }

    private boolean isInSelectorRight(int x) {
        int xRight = this.viewSelection.getXRight();
        return x >= xRight - this.selectorWidth && x <= xRight + this.selectorWidth;
    }

    private Level tierAtViewPosition(int y) {
        Level tierAtViewPos = null;
        if (this.bundle != null) {
            List<Level> tiers = this.bundle.getLevels();
            int tiersCount = tiers.size();
            int h = this.getHeight();
            int tierandSepHeight = h / tiersCount;
            int tierIndx = y / tierandSepHeight;
            if (tierIndx >= tiersCount) {
                tierIndx = tiersCount - 1;
            }
            tierAtViewPos = tiers.get(tierIndx);
        }
        return tierAtViewPos;
    }

    private Item segmentAtPosition(Level selTier, long pos) {
        return this.segmentAtPosition(selTier, pos, true);
    }

    private Item segmentAtPosition(Level selTier, long pos, boolean leftAligned) {
        Item singleItem;
        Set<Link> lks;
        Long sEnd;
        Long sBeg;
        if (this.bundle == null) {
            return null;
        }
        List<Item> items = selTier.getItems();
        for (Item item : items) {
            sBeg = item.getSampleStart();
            if (sBeg == null || (sEnd = Long.valueOf(sBeg + item.getSampleDur())) == null || !(leftAligned ? pos >= sBeg && pos < sEnd : pos > sBeg && pos <= sEnd)) continue;
            return item;
        }
        for (Item item : items) {
            sBeg = item.getSampleStart();
            if (sBeg != null || (sBeg = this.bundle.startByLinkedSegmentItems(item)) == null || (sEnd = this.bundle.endByLinkedSegmentItems(item)) == null || !(leftAligned ? pos >= sBeg && pos < sEnd : pos > sBeg && pos <= sEnd)) continue;
            return item;
        }
        if (items.size() == 1 && (lks = this.bundle.linksOfItem(singleItem = items.get(0))).size() == 0) {
            return singleItem;
        }
        return null;
    }

    private void selectionByMouse(MouseEvent me) {
        if (this.dragStartEvent != null) {
            if (this.viewSelection != null) {
                Level selTier;
                this.viewSelection.limitTo(0L, this.length);
                Selection vSel = this.viewSelection.getSelection();
                if (this.snapToSegments && (selTier = this.tierAtViewPosition(me.getY())) != null) {
                    long selLeft = vSel.getLeft();
                    Item leftSeg = this.segmentAtPosition(selTier, selLeft, true);
                    long selRight = vSel.getRight();
                    Item rightSeg = this.segmentAtPosition(selTier, selRight, false);
                    if (leftSeg != null && rightSeg != null) {
                        Long sampleStart = leftSeg.getSampleStart();
                        Long sampleEnd = null;
                        if (sampleStart != null) {
                            Long rSDur;
                            Long rSStart = rightSeg.getSampleStart();
                            if (rSStart != null && (rSDur = rightSeg.getSampleDur()) != null) {
                                sampleEnd = rSStart + rSDur;
                            }
                        } else {
                            sampleStart = this.bundle.startByLinkedSegmentItems(leftSeg);
                            sampleEnd = this.bundle.endByLinkedSegmentItems(rightSeg);
                        }
                        if (sampleStart != null && sampleEnd != null) {
                            vSel = new Selection(sampleStart.longValue(), sampleEnd.longValue());
                        }
                    } else {
                        vSel = null;
                    }
                }
                this.audioSample.setSelection(vSel);
                this.repaint();
            }
            this.checkMouseResizeSelection(me);
        }
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.dragStartEvent = null;
        this.pressedEvent = null;
        this.selStartMoveEvent = null;
        this.selEndMoveEvent = null;
        if (arg0.isPopupTrigger()) {
            this.getParent().dispatchEvent(arg0);
        } else {
            int x = arg0.getX();
            if (this.viewSelection != null) {
                if (this.isInSelectorStart(x)) {
                    this.selStartMoveEvent = arg0;
                } else if (this.isInSelectorEnd(x)) {
                    this.selEndMoveEvent = arg0;
                } else {
                    this.pressedEvent = arg0;
                }
                this.repaint();
            } else {
                this.pressedEvent = arg0;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.getParent().dispatchEvent(arg0);
        } else {
            this.selectionByMouse(arg0);
        }
        this.dragStartEvent = null;
    }

    @Override
    public synchronized void mouseDragged(MouseEvent arg0) {
        if (this.pressedEvent != null) {
            this.dragStartEvent = this.pressedEvent;
            if (this.viewSelection == null) {
                this.viewSelection = new BasicAudioClipUI.ViewSelection((BasicAudioClipUI)this);
            }
            this.viewSelection.setXStart(this.dragStartEvent.getX());
            this.viewSelection.setXEnd(arg0.getX());
            this.repaint();
        } else if (this.selStartMoveEvent != null) {
            this.dragStartEvent = this.selStartMoveEvent;
            this.viewSelection.setXStart(arg0.getX());
            this.setCursor();
            this.repaint();
        } else if (this.selEndMoveEvent != null) {
            this.dragStartEvent = this.selEndMoveEvent;
            this.viewSelection.setXEnd(arg0.getX());
            this.setCursor();
            this.repaint();
        }
        if (this.changeSelectionOnDrag) {
            this.selectionByMouse(arg0);
        }
    }

    private void checkMouseResizeSelection(MouseEvent arg0) {
        int x = arg0.getX();
        if (this.viewSelection != null) {
            if (this.isInSelectorLeft(x)) {
                this.mouseOverResizeEast = null;
                this.mouseOverResizeWest = arg0;
            } else if (this.isInSelectorRight(x)) {
                this.mouseOverResizeEast = arg0;
                this.mouseOverResizeWest = null;
            } else {
                this.mouseOverResizeEast = null;
                this.mouseOverResizeWest = null;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        this.checkMouseResizeSelection(arg0);
        this.setCursor();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        StartPlaybackActionEvent pae = null;
        pae = new StartPlaybackActionEvent((Object)this, this.selection.getLeft(), this.selection.getRight());
        if (pae != null) {
            this.startPlaybackAction.actionPerformed((ActionEvent)pae);
        }
    }

    public void setStartPlaybackAction(StartPlaybackAction startPlaybackAction) {
        this.startPlaybackAction = startPlaybackAction;
        startPlaybackAction.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean enabled = ((Action)evt.getSource()).isEnabled();
    }

    private void setCursor() {
        if (this.dragStartEvent != null) {
            if (this.dragStartEvent == this.selStartMoveEvent) {
                this.setCursor(Cursor.getPredefinedCursor(10));
            } else if (this.dragStartEvent == this.selStartMoveEvent) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            }
        } else if (this.mouseOverResizeWest != null) {
            this.setCursor(Cursor.getPredefinedCursor(10));
        } else if (this.mouseOverResizeEast != null) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void doScalesLayout() {
        int compH = this.getSize().height;
        int borderLength = 2;
        int yLblCnt = this.yLabels.size();
        if (yLblCnt > 0) {
            JLabel yLabel;
            int scaleHeight = (compH - 2 * borderLength) / yLblCnt;
            int scaleWidth = 0;
            int i = 0;
            while (i < yLblCnt) {
                yLabel = this.yLabels.get(i);
                if (yLabel != null) {
                    Dimension scalePrefSize = yLabel.getPreferredSize();
                    int sW = scalePrefSize.width;
                    if (sW > scaleWidth) {
                        scaleWidth = sW;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < yLblCnt) {
                yLabel = this.yLabels.get(i);
                if (yLabel != null) {
                    int sYPos = borderLength + scaleHeight * i;
                    Dimension scalePrefSize = yLabel.getPreferredSize();
                    int sW = scalePrefSize.width;
                    yLabel.setBounds(scaleWidth - sW, sYPos, sW, scaleHeight);
                    yLabel.doLayout();
                }
                ++i;
            }
            Dimension preferredSize = new Dimension(scaleWidth, compH);
            this.yScalesComponent.setPreferredSize(preferredSize);
        } else {
            Dimension preferredSize = new Dimension(0, compH);
            this.yScalesComponent.setPreferredSize(preferredSize);
        }
        this.yScalesComponent.doLayout();
        this.yScalesComponent.repaint();
    }

    public void doLayout() {
        super.doLayout();
        this.doScalesLayout();
    }

    public JComponent[] getYScales() {
        return new JComponent[]{this.yScalesComponent};
    }
}

