/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.view;

import ips.annot.model.db.SegmentItem;
import ips.annot.view.ItemViewer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class IntervalItemViewer
extends ItemViewer {
    private final int X_SPACE = 5;
    private final int Y_SPACE = 2;
    private Font font = new Font("Sans-serif", 0, 12);
    private FontMetrics fontMetrics = this.getFontMetrics(this.font);
    private int lineHeight;
    private int height;
    private int width;
    private int labelWidth;
    private int beginWidth;
    private int endWidth;
    private float xFactor = 1.0f;
    private float yFactor = 1.0f;
    private SegmentItem intervalItem;

    public IntervalItemViewer(SegmentItem intervalItem) {
        super(intervalItem);
        this.intervalItem = intervalItem;
        this.createGUI();
    }

    private void createGUI() {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.lineHeight = this.fontMetrics.getHeight() + this.fontMetrics.getLeading() + this.fontMetrics.getDescent();
        this.width = (int)((float)this.computeWidth() * this.xFactor) + 1;
        this.height = 2 + 3 * this.lineHeight + 2;
        this.setSize(this.width, this.height);
    }

    public float getxFactor() {
        return this.xFactor;
    }

    public void setxFactor(float xFactor) {
        this.xFactor = xFactor;
    }

    public float getyFactor() {
        return this.yFactor;
    }

    public void setyFactor(float yFactor) {
        this.yFactor = yFactor;
    }

    private int computeWidth() {
        this.labelWidth = this.fontMetrics.stringWidth(this.intervalItem.getLabelText());
        this.beginWidth = this.fontMetrics.stringWidth("" + this.intervalItem.getSampleStart());
        this.endWidth = this.fontMetrics.stringWidth("" + this.intervalItem.getSampleDur());
        int contentWidth = 0;
        contentWidth = this.labelWidth < this.beginWidth ? (this.beginWidth < this.endWidth ? this.endWidth : this.beginWidth) : this.labelWidth;
        return 5 + contentWidth + 5;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isMarked()) {
            g.setColor(Color.RED);
        } else if (this.isHighlighted()) {
            g.setColor(Color.YELLOW);
        } else {
            g.setColor(Color.WHITE);
        }
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.BLACK);
        g.drawString(this.intervalItem.getLabelText(), (this.width - this.labelWidth) / 2, this.lineHeight);
        g.drawString("" + this.intervalItem.getSampleStart(), this.width - this.beginWidth - 2, 2 * this.lineHeight);
        g.drawString("" + this.intervalItem.getSampleDur(), this.width - this.endWidth - 2, 3 * this.lineHeight);
        g.drawRect(0, 0, this.width - 1, this.height - 1);
    }
}

