/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.applet;

import ips.annot.view.AnnotatedAudioPlayerBean;
import ipsk.swing.applet.JAppletDispatchThreadWrapper;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;

public class AnnotatedAudioPlayerBeanApplet
extends JAppletDispatchThreadWrapper
implements PropertyChangeListener {
    public boolean debug = false;
    public static final String VERSION = AnnotatedAudioPlayerBeanApplet.class.getPackage().getImplementationVersion();
    protected AnnotatedAudioPlayerBean audioPlayer = null;
    protected URL audioURL;
    protected URL annotationURL;
    protected static String[][] pInfo = new String[][]{{"url", "url", "Audio URL (required)"}, {"textGridAnnotationUrl", "textGridAnnotationUrl", "TextGrid Annotation URL (required)"}, {"textGridAnnotationCharset", "textGridAnnotationCharset", "TextGrid Annotation charset (default ISO-8859-1 or set by Content-type header)"}, {"ui", "string", "Optional comma separated list of UI modules: signal,sonagram,timescale"}, {"debug", "boolean", "Print debug infos"}};

    public String[][] getParameterInfo() {
        return pInfo;
    }

    public void initByDT() {
        Charset cs;
        String debugParamStr = this.getParameter("debug");
        if (debugParamStr != null) {
            this.debug = Boolean.parseBoolean(debugParamStr);
        }
        if (this.debug) {
            System.out.println(this.getClass().getName() + " " + VERSION);
            System.out.println("Init...");
        }
        this.audioPlayer = new AnnotatedAudioPlayerBean();
        this.audioPlayer.setDebug(this.debug);
        String tgAnnoCs = this.getParameter("textGridAnnotationCharset");
        if (tgAnnoCs != null && !"".equals(tgAnnoCs) && (cs = Charset.forName(tgAnnoCs)) != null) {
            this.audioPlayer.setTextGridCharset(cs);
            if (this.debug) {
                System.out.println("TextGrid charset set: " + cs.name());
            }
        }
        this.getContentPane().add(this.audioPlayer);
        String uiConfig = this.getParameter("ui");
        boolean showDSPInfo = false;
        boolean showAudioSignal = false;
        boolean showSona = false;
        boolean showTimeScale = false;
        if (uiConfig != null) {
            String[] uiModuls;
            for (String uiModstr : uiModuls = uiConfig.split(",")) {
                String uiModul = uiModstr.toUpperCase(Locale.ENGLISH).trim();
                if (uiModul.equals("SIGNAL")) {
                    showAudioSignal = true;
                    continue;
                }
                if (uiModul.equals("SONAGRAM")) {
                    showSona = true;
                    continue;
                }
                if (!uiModul.equals("TIMESCALE")) continue;
                showTimeScale = true;
            }
        } else {
            showAudioSignal = true;
            showTimeScale = true;
        }
        this.audioPlayer.setShowSonagram(showSona);
        this.audioPlayer.setShowTimeScale(showTimeScale);
        String audioURLStr = this.getParameter("url");
        try {
            this.audioURL = new URL(audioURLStr);
        }
        catch (MalformedURLException e) {
            String m = new String("Malformed audio URL: '" + this.audioURL + "'");
            if (this.debug) {
                System.err.println(m);
                e.printStackTrace();
            }
            this.showStatus(m);
            return;
        }
        String annotationURLStr = this.getParameter("textGridAnnotationUrl");
        if (annotationURLStr != null && !"".equals(annotationURLStr)) {
            try {
                this.annotationURL = new URL(annotationURLStr);
            }
            catch (MalformedURLException e) {
                String m = new String("Malformed annotation URL: '" + this.annotationURL + "'");
                if (this.debug) {
                    System.err.println(m);
                    e.printStackTrace();
                }
                this.showStatus(m);
                return;
            }
        }
        this.audioPlayer.addPropertyChangeListener(this);
        if (this.debug) {
            System.out.println("Initialized.");
        }
    }

    public void startByDT() {
        if (this.debug) {
            System.out.println("Start...");
        }
        this.audioPlayer.setURL(this.audioURL);
        this.audioPlayer.setAnnotationURL(this.annotationURL);
        this.audioPlayer.reactivate();
        this.getContentPane().validate();
        if (this.debug) {
            System.out.println("Started.");
        }
    }

    public void stopByDT() {
        if (this.debug) {
            System.out.println("Stop...");
        }
        this.audioPlayer.deactivate();
        if (this.debug) {
            System.out.println("Stopped.");
        }
    }

    public void destroyByDT() {
        if (this.debug) {
            System.out.println("Destroy...");
        }
        this.getContentPane().removeAll();
        this.audioPlayer.close();
        if (this.debug) {
            System.out.println("Destroyed.");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pName;
        if (evt != null && "message".equals(pName = evt.getPropertyName())) {
            String msg = (String)evt.getNewValue();
            if (msg != null) {
                this.showStatus(msg);
            } else {
                this.showStatus("");
            }
        }
    }

    public static enum Status {
        EXISTING,
        INITIALIZED,
        LOADING,
        PROCESS,
        READY,
        APPLET_STOPPED,
        APPLET_DESTROYED;

    }
}

