/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.autoannotator.impl.ws.bas.maus;

import ips.annot.autoannotator.AutoAnnotation;
import ips.annot.autoannotator.AutoAnnotationServiceDescriptor;
import ips.annot.autoannotator.AutoAnnotator;
import ips.annot.autoannotator.AutoAnnotatorException;
import ips.annot.autoannotator.impl.maus.BasicMAUSAnnotation;
import ips.annot.autoannotator.impl.ws.bas.BasicBasServiceClient;
import ips.annot.autoannotator.impl.ws.bas.maus.BasicMAUSAnnotatorServiceDescriptor;
import ips.annot.model.PredefinedLevelDefinition;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.annot.textgrid.TextGridFileParser;
import ipsk.io.StreamCopy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class BasicMAUSWebServiceClient
extends BasicBasServiceClient {
    public static final BasicMAUSAnnotatorServiceDescriptor DESCRIPTOR = new BasicMAUSAnnotatorServiceDescriptor();
    private static final boolean DEBUG = false;
    private static String URL = BASE_URL + "/runMAUSBasic";
    private static String PARAM_LANG = "LANGUAGE";
    private AutoAnnotator.AnnotationRequest annotationRequest;
    private boolean insertKanonicalTier = true;
    private boolean insertOrthographyTier = true;
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final ContentType DEFAULT_TEXT_CONTENT_TYPE = ContentType.create((String)"text/plain", (Charset)DEFAULT_CHARSET);
    private DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();

    public boolean isInsertKanonicalTier() {
        return this.insertKanonicalTier;
    }

    public void setInsertKanonicalTier(boolean insertKanonicalTier) {
        this.insertKanonicalTier = insertKanonicalTier;
    }

    public boolean isInsertOrthographyTier() {
        return this.insertOrthographyTier;
    }

    public void setInsertOrthographyTier(boolean insertOrthographyTier) {
        this.insertOrthographyTier = insertOrthographyTier;
    }

    public AutoAnnotation webMAUSClient(File audioFile, String orthoGraphy, Locale loc) throws AutoAnnotatorException {
        String audioFilename = audioFile.getName();
        String audioFilenameBody = audioFilename.replaceFirst("[.][^.]*$", "");
        String orthoGraphyFilename = audioFilenameBody + ".txt";
        return this.webMAUSClient(audioFile, orthoGraphy, orthoGraphyFilename, loc);
    }

    public AutoAnnotation webMAUSClient(File audioFile, String orthoGraphy, String orthoGraphyFilename, Locale loc) throws AutoAnnotatorException {
        byte[] orthoBytes = orthoGraphy.getBytes(DEFAULT_CHARSET);
        ByteArrayBody textBody = new ByteArrayBody(orthoBytes, DEFAULT_TEXT_CONTENT_TYPE, orthoGraphyFilename);
        return this.webMAUSClient(audioFile, (ContentBody)textBody, loc);
    }

    public AutoAnnotation webMAUSClient(File audioFile, File orthoGraphyFile, Locale loc) throws AutoAnnotatorException {
        FileBody textBody = new FileBody(orthoGraphyFile, DEFAULT_TEXT_CONTENT_TYPE, orthoGraphyFile.getName());
        return this.webMAUSClient(audioFile, (ContentBody)textBody, loc);
    }

    public AutoAnnotation webMAUSClient(File audioFile, ContentBody textBody, Locale loc) throws AutoAnnotatorException {
        try {
            this.getServerCaps();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BasicMAUSAnnotation anno = null;
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httppost = new HttpPost(URL);
        AudioFileFormat aff = null;
        try {
            aff = AudioSystem.getAudioFileFormat(audioFile);
        }
        catch (UnsupportedAudioFileException e1) {
            e1.printStackTrace();
            throw new AutoAnnotatorException(e1);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw new AutoAnnotatorException(e1);
        }
        AudioFormat af = aff.getFormat();
        float sampleRate = af.getSampleRate();
        FileBody audio = new FileBody(audioFile, ContentType.create((String)"audio/wav"), audioFile.getName());
        String iso639ThreeLetters = loc.getISO3Language();
        StringBody languageBody = new StringBody(iso639ThreeLetters, DEFAULT_TEXT_CONTENT_TYPE);
        StringBody trueBody = new StringBody("true", ContentType.TEXT_PLAIN);
        MultipartEntityBuilder reqEntityBuilder = MultipartEntityBuilder.create();
        reqEntityBuilder.addPart("LANGUAGE", (ContentBody)languageBody);
        reqEntityBuilder.addPart("TEXT", textBody);
        reqEntityBuilder.addPart("SIGNAL", (ContentBody)audio);
        if (this.insertKanonicalTier) {
            reqEntityBuilder.addPart("INSKANTEXTGRID", (ContentBody)trueBody);
        }
        if (this.insertOrthographyTier) {
            reqEntityBuilder.addPart("INSORTTEXTGRID", (ContentBody)trueBody);
        }
        HttpEntity reqEntity = reqEntityBuilder.build();
        httppost.setEntity(reqEntity);
        try {
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            StatusLine sl = response.getStatusLine();
            int status = sl.getStatusCode();
            if (status >= 200 && status < 300) {
                HttpEntity resEntity = response.getEntity();
                InputStream content = resEntity.getContent();
                URL dlUrl = this.downloadLinkFromResponse(content);
                URLConnection dlConn = dlUrl.openConnection();
                InputStream is = dlConn.getInputStream();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                StreamCopy.copy((InputStream)is, (OutputStream)bos);
                byte[] textGridBinData = bos.toByteArray();
                ByteArrayInputStream bis = new ByteArrayInputStream(textGridBinData);
                InputStreamReader conReader = new InputStreamReader((InputStream)bis, DEFAULT_CHARSET);
                TextGridFileParser tgfp = new TextGridFileParser(sampleRate);
                Bundle bundle = tgfp.parse(conReader);
                conReader.close();
                anno = new BasicMAUSAnnotation(textGridBinData, bundle.getLevels());
            }
        }
        catch (IOException e) {
            throw new AutoAnnotatorException(e);
        }
        return anno;
    }

    public static void main(String[] args) {
        BasicMAUSWebServiceClient wmc = new BasicMAUSWebServiceClient();
        String example2Txt = "Einzelzimmer 248 Mark.";
        try {
            AutoAnnotation aa = wmc.webMAUSClient(new File("/homes/klausj/examples-WebMAUS/example2.wav"), example2Txt, Locale.GERMAN);
            BasicMAUSAnnotation basicMAUSAnnotation = (BasicMAUSAnnotation)aa;
        }
        catch (AutoAnnotatorException e) {
            e.printStackTrace();
        }
    }

    @Override
    public AutoAnnotation call() throws Exception {
        String templateText;
        Item it;
        Map<String, Object> itLbls;
        Object itLbl;
        List<Item> its;
        Level tplLvl;
        String sigPath;
        File audioFile;
        Bundle inputBundle = this.annotationRequest.getBundle();
        List<String> sigPaths = inputBundle.getSignalpaths();
        if (sigPaths != null && sigPaths.size() == 1 && (audioFile = new File(sigPath = sigPaths.get(0))) != null && audioFile.exists() && (tplLvl = inputBundle.getTierByName(PredefinedLevelDefinition.TPL.getKeyName())) != null && (its = tplLvl.getItems()).size() == 1 && (itLbl = (itLbls = (it = its.get(0)).getLabels()).get(PredefinedLevelDefinition.TPL.getKeyName())) instanceof String && (templateText = (String)itLbl) != null) {
            return this.webMAUSClient(audioFile, templateText, inputBundle.getLocale());
        }
        throw new AutoAnnotatorException();
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void setAnnotationRequest(AutoAnnotator.AnnotationRequest ar) {
        this.annotationRequest = ar;
    }

    @Override
    public boolean isBundleSupported(Bundle bundle) throws IOException {
        Locale l = bundle.getLocale();
        boolean langSupp = this.isLanguageSupported(l);
        List<String> sigPaths = bundle.getSignalpaths();
        if (sigPaths.size() == 0) {
            return false;
        }
        File sigFile = new File(sigPaths.get(0));
        boolean mSupp = this.isMediafileSupported(sigFile);
        return langSupp && mSupp;
    }

    @Override
    public AutoAnnotationServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }

    public AutoAnnotation webMAUSClient(File audioFile, String transcript, String textFilename) throws AutoAnnotatorException {
        return this.webMAUSClient(audioFile, transcript, textFilename, null);
    }

    public class ServerCaps {
        private List<String> supportedLangs;

        public List<String> getSupportedLangs() {
            return this.supportedLangs;
        }

        public void setSupportedLangs(List<String> supportedLangs) {
            this.supportedLangs = supportedLangs;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.supportedLangs != null) {
                sb.append("Supported languages: ");
                int suppLanglen = this.supportedLangs.size();
                for (int i = 0; i < suppLanglen; ++i) {
                    String suppLang = this.supportedLangs.get(i);
                    sb.append(suppLang);
                    if (i >= suppLanglen - 1) continue;
                    sb.append(',');
                }
            }
            return sb.toString();
        }
    }
}

