/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.model.db;

import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.annot.model.db.Link;
import ips.annot.model.db.LinkDefinition;
import ips.annot.model.db.Session;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="bundle", propOrder={"name", "annotates", "sampleRate", "levels", "links"})
public class Bundle {
    private transient Session session;
    @Id
    @SequenceGenerator(name="keys", sequenceName="KEYS", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="keys")
    private int id;
    private String name;
    private String annotates = null;
    private Float sampleRate;
    private Long frameLength;
    private List<String> signalpaths = new Vector<String>();
    @OneToMany(mappedBy="tier")
    private List<Level> levels = new ArrayList<Level>();
    private Set<Link> linksSet = new HashSet<Link>();
    private Locale locale;

    @XmlTransient
    public Long getFrameLength() {
        return this.frameLength;
    }

    public void setFrameLength(Long frameLength) {
        this.frameLength = frameLength;
    }

    @XmlTransient
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @XmlTransient
    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAnnotates() {
        if (this.annotates != null) {
            return this.annotates;
        }
        if (this.signalpaths != null && this.signalpaths.size() > 0) {
            String masterSignalPath = this.signalpaths.get(0);
            File masterFile = new File(masterSignalPath);
            return masterFile.getName();
        }
        return null;
    }

    public void setAnnotates(String annotates) {
        this.annotates = annotates;
    }

    public Float getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(Float sampleRate) {
        this.sampleRate = sampleRate;
    }

    @XmlTransient
    public List<String> getSignalpaths() {
        return this.signalpaths;
    }

    public void setSignalpaths(List<String> signalurls) {
        this.signalpaths = signalurls;
    }

    @XmlElements(value={@XmlElement(name="levels")})
    public List<Level> getLevels() {
        return this.levels;
    }

    public void setLevels(List<Level> levels) {
        this.levels = levels;
    }

    @XmlElement(name="links")
    public List<Link> getLinks() {
        ArrayList<Link> ll = new ArrayList<Link>();
        for (Link l : this.linksSet) {
            ll.add(l);
        }
        return ll;
    }

    public void setLinks(List<Link> linkList) {
        this.linksSet.clear();
        for (Link l : linkList) {
            this.linksSet.add(l);
        }
    }

    @XmlTransient
    public Set<Link> getLinksAsSet() {
        return this.linksSet;
    }

    @Transient
    @XmlTransient
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean isValidConstraint(Item fromItem, Item toItem) {
        Level fromTier = fromItem.getLevel();
        Level toTier = toItem.getLevel();
        if (this.session != null) {
            for (LinkDefinition c : this.session.getDatabase().getSchema().getConstraints()) {
                if (!c.isValidTierLinkDefinition(fromTier.getDefinition(), toTier.getDefinition())) continue;
                return true;
            }
        }
        return false;
    }

    public Set<Link> linksOfItem(Item it) {
        HashSet<Link> linksOfItem = new HashSet<Link>();
        for (Link l : this.getLinksAsSet()) {
            if (!l.getFrom().equals(it) && !l.getTo().equals(it)) continue;
            linksOfItem.add(l);
        }
        return linksOfItem;
    }

    public Long startByLinkedSegmentItems(Item item, boolean forward) {
        Long minStart = null;
        if ("SEGMENT".equals(item.getType()) || item.getSampleStart() != null) {
            return item.getSampleStart();
        }
        for (Link l : this.getLinksAsSet()) {
            Long minLinkStart;
            Integer itId = item.getBundleId();
            if (itId == null) continue;
            int lfId = l.getFromID();
            int ltId = l.getToID();
            Item linkIt = null;
            if (forward && lfId == itId) {
                linkIt = l.getTo();
            } else if (!forward && ltId == itId) {
                linkIt = l.getFrom();
            }
            if (linkIt == null || (minLinkStart = this.startByLinkedSegmentItems(linkIt, forward)) == null) continue;
            if (minStart == null) {
                minStart = minLinkStart;
                continue;
            }
            if (minLinkStart >= minStart) continue;
            minStart = minLinkStart;
        }
        return minStart;
    }

    public Long endByLinkedSegmentItems(Item item, boolean forward) {
        Long maxEnd = null;
        if ("SEGMENT".equals(item.getType()) || item.getSampleStart() != null) {
            return item.getSampleStart() + item.getSampleDur();
        }
        for (Link l : this.getLinksAsSet()) {
            Long maxLinkEnd;
            Integer itId = item.getBundleId();
            if (itId == null) continue;
            int lfId = l.getFromID();
            int ltId = l.getToID();
            Item linkIt = null;
            if (forward && lfId == itId) {
                linkIt = l.getTo();
            } else if (!forward && ltId == itId) {
                linkIt = l.getFrom();
            }
            if (linkIt == null || (maxLinkEnd = this.endByLinkedSegmentItems(linkIt, forward)) == null) continue;
            if (maxEnd == null) {
                maxEnd = maxLinkEnd;
                continue;
            }
            if (maxLinkEnd <= maxEnd) continue;
            maxEnd = maxLinkEnd;
        }
        return maxEnd;
    }

    public Level getTierByName(String name) {
        for (Level tier : this.getLevels()) {
            if (!tier.getName().equalsIgnoreCase(name)) continue;
            return tier;
        }
        return null;
    }

    public Set<Integer> itemIdsInUse() {
        HashSet<Integer> idsInUse = new HashSet<Integer>();
        List<Level> lvls = this.getLevels();
        for (Level lvl : lvls) {
            List<Item> its = lvl.getItems();
            for (Item it : its) {
                Integer itemId = it.getBundleId();
                if (itemId == null) continue;
                idsInUse.add(itemId);
            }
        }
        return idsInUse;
    }

    public Item itemByBundleScopeId(int bundleScopeId) {
        Item item = null;
        for (Level lvl : this.getLevels()) {
            for (Item it : lvl.getItems()) {
                Integer bsId = it.getBundleId();
                if (bsId == null || bsId != bundleScopeId) continue;
                return it;
            }
        }
        return item;
    }

    public void resolveLinkReferences() {
        for (Link l : this.linksSet) {
            int fromId = l.getFromID();
            Item fromIt = this.itemByBundleScopeId(fromId);
            int toId = l.getToID();
            Item toIt = this.itemByBundleScopeId(toId);
            toIt.getFromItems().add(fromIt);
            fromIt.getToItems().add(toIt);
            if (l.getFrom() == null) {
                l.setFrom(fromIt);
            }
            if (l.getTo() != null) continue;
            l.setTo(toIt);
        }
    }

    public void applyLevelsToItems() {
        for (Level l : this.getLevels()) {
            for (Item it : l.getItems()) {
                it.setLevel(l);
            }
        }
    }

    public void applyBundleToLevels() {
        for (Level l : this.getLevels()) {
            l.setBundle(this);
        }
    }

    public void applyItemPositions() {
        for (Level l : this.getLevels()) {
            List<Item> items = l.getItems();
            for (int i = 0; i < items.size(); ++i) {
                Item it = items.get(i);
                it.setPosition(i);
            }
        }
    }

    public Integer highestID() {
        Set<Integer> idsInUse = this.itemIdsInUse();
        Integer hId = null;
        for (Integer id : idsInUse) {
            if (id == null || hId != null && id <= hId) continue;
            hId = id;
        }
        return hId;
    }

    public void removeLinksForItem(Item item) {
        HashSet<Link> linksToRemove = new HashSet<Link>();
        Set<Link> linksSet = this.getLinksAsSet();
        for (Link l : linksSet) {
            Item lf = l.getFrom();
            Item lt = l.getTo();
            if (!item.equals(lf) && !item.equals(lt)) continue;
            linksToRemove.add(l);
        }
        for (Link l : linksToRemove) {
            linksSet.remove(l);
        }
    }

    public void removeLevelAndAssociatedLinks(Level level) {
        List<Item> its = level.getItems();
        for (Item it : its) {
            this.removeLinksForItem(it);
        }
        this.levels.remove(level);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Bundle: " + this.name + "\n");
        buffer.append("Levels:\n");
        for (Level tier : this.levels) {
            buffer.append(tier.toString());
        }
        buffer.append("Links (" + this.getLinks().size() + "):\n");
        for (Link link : this.getLinks()) {
            buffer.append(link.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public void toXML() {
        String xmlFilename = "/Users/draxler/Bundle.xml";
        File xml = new File(xmlFilename);
        JAXB.marshal((Object)this, (File)xml);
    }

    public Bundle fromXML() {
        String xmlFilename = "/Users/draxler/Bundle.xml";
        File xml = new File(xmlFilename);
        Bundle b = (Bundle)JAXB.unmarshal((File)xml, Bundle.class);
        for (Level tier : b.getLevels()) {
            tier.setBundle(b);
            for (Item item : tier.getItems()) {
                item.setLevel(tier);
            }
        }
        return b;
    }

    public Long startByLinkedSegmentItems(Item item) {
        Long startFwd = this.startByLinkedSegmentItems(item, true);
        if (startFwd != null) {
            return startFwd;
        }
        return this.startByLinkedSegmentItems(item, false);
    }

    public Long endByLinkedSegmentItems(Item item) {
        Long endFwd = this.endByLinkedSegmentItems(item, true);
        if (endFwd != null) {
            return endFwd;
        }
        return this.endByLinkedSegmentItems(item, false);
    }

    public Long startByContext(Item item) {
        Long startByLks = this.startByLinkedSegmentItems(item);
        if (startByLks != null) {
            return startByLks;
        }
        Level lvl = item.getLevel();
        if (lvl != null && "ITEM".equals(lvl.getType())) {
            List<Item> its = lvl.getItems();
            int itCnt = its.size();
            for (int i = 0; i < itCnt; ++i) {
                Long fl;
                Item lIt = its.get(i);
                if (item != lIt || (fl = this.getFrameLength()) == null) continue;
                long pos = fl * (long)i / (long)itCnt;
                return pos;
            }
        }
        return null;
    }

    public Long endByContext(Item item) {
        Long endByLks = this.endByLinkedSegmentItems(item);
        if (endByLks != null) {
            return endByLks;
        }
        Level lvl = item.getLevel();
        if (lvl != null && "ITEM".equals(lvl.getType())) {
            List<Item> its = lvl.getItems();
            int itCnt = its.size();
            for (int i = 0; i < itCnt; ++i) {
                Long fl;
                Item lIt = its.get(i);
                if (item != lIt || (fl = this.getFrameLength()) == null) continue;
                long pos = fl * (long)(itCnt - i) / (long)itCnt;
                return pos;
            }
        }
        return null;
    }
}

