/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.model.emu;

import ips.annot.model.db.Bundle;
import ips.annot.model.db.EventItem;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.annot.model.db.Link;
import ips.annot.model.db.SegmentItem;
import java.util.HashMap;
import java.util.Vector;

public class EmuLabelFileConverter {
    public static final String EMU_HIERARCHY_HEADER = "**EMU hierarchical labels**";

    public void importSegments(Vector<String> lines, Bundle bundle, String tiername) {
        if (!lines.get(0).matches("signal \\w+")) {
            return;
        }
        if (!lines.get(1).matches("nfields [0-9]+")) {
            return;
        }
        if (!lines.get(2).matches("#")) {
            return;
        }
        String[] fields = lines.get(3).split("\\s");
        long beginSegment = 0L;
        if (fields.length != 3 || !fields[2].equals("H#")) {
            return;
        }
        double beginTmp = Double.parseDouble(fields[0]) * 1000.0;
        beginSegment = Math.round(beginTmp);
        Level segmentTier = bundle.getTierByName(tiername);
        int index = 0;
        for (int i = 4; i < lines.size(); ++i) {
            fields = lines.get(i).split("\\s+");
            if (fields.length != 3) continue;
            SegmentItem segment = new SegmentItem();
            segment.setLabel(tiername, fields[2]);
            segment.setLevel(segmentTier);
            double tmp = Double.parseDouble(fields[0]) * 1000.0;
            long endSegment = Math.round(tmp);
            segment.setSampleStart(beginSegment);
            segment.setSampleDur(endSegment - beginSegment - 1L);
            Item oldItem = segmentTier.getItems().get(index);
            for (Link link : bundle.getLinksAsSet()) {
                if (!link.getTo().equals(oldItem)) continue;
                link.setTo(segment);
            }
            segmentTier.getItems().remove(index);
            segmentTier.getItems().add(index, segment);
            beginSegment = endSegment;
            ++index;
        }
    }

    public void importEvents(Vector<String> lines, Bundle bundle, String tiername) {
        if (!lines.get(0).matches("signal \\w+")) {
            return;
        }
        if (!lines.get(1).matches("nfields [0-9]+")) {
            return;
        }
        if (!lines.get(2).matches("#")) {
            return;
        }
        String[] fields = lines.get(3).split("\\s");
        Level eventTier = bundle.getTierByName(tiername);
        int index = 0;
        for (int i = 3; i < lines.size(); ++i) {
            fields = lines.get(i).split("\\s+");
            if (fields.length != 3) continue;
            EventItem event = new EventItem();
            event.setLabel(tiername, fields[2]);
            event.setLevel(eventTier);
            double tmp = Double.parseDouble(fields[0]) * 1000.0;
            long samplePoint = Math.round(tmp);
            event.setSamplepoint(samplePoint);
            Item oldItem = eventTier.getItems().get(index);
            for (Link link : bundle.getLinksAsSet()) {
                if (!link.getTo().equals(oldItem)) continue;
                link.setTo(event);
            }
            eventTier.getItems().remove(index);
            eventTier.getItems().add(index, event);
            ++index;
        }
    }

    public void importItems(Vector<String> lines, Bundle bundle) {
        String context = "";
        String[] attributes = null;
        Level tier = null;
        boolean validContext = false;
        HashMap<Integer, Item> items = new HashMap<Integer, Item>();
        if (!lines.get(0).equals(EMU_HIERARCHY_HEADER)) {
            return;
        }
        try {
            Integer maxItemNo = Integer.valueOf(lines.get(1).trim(), 10);
        }
        catch (NumberFormatException e) {
            return;
        }
        for (int lineNo = 2; lineNo < lines.size(); ++lineNo) {
            String line = lines.get(lineNo).trim();
            String[] fields = line.split("\\s+");
            if (fields[0].matches("")) {
                validContext = false;
                continue;
            }
            if (fields[0].matches("[a-zA-Z_]+")) {
                context = fields[0];
                attributes = line.split(" ");
                tier = bundle.getTierByName(context);
                if (tier != null) {
                    validContext = true;
                    continue;
                }
                validContext = false;
                continue;
            }
            if (!fields[0].matches("[0-9]+")) continue;
            Integer itemNo = Integer.valueOf(fields[0], 10);
            if (itemNo == 0) {
                return;
            }
            if (validContext) {
                Item item = new Item();
                item.setLevel(tier);
                String[] values = line.split(" ");
                if (attributes.length == values.length) {
                    for (int i = 0; i < attributes.length; ++i) {
                        item.setLabel(attributes[i], values[i]);
                    }
                } else {
                    item.setLabel(attributes[1], "");
                }
                items.put(itemNo, item);
                tier.getItems().add(item);
                continue;
            }
            Item fromItem = (Item)items.get(itemNo);
            for (int i = 1; i < fields.length; ++i) {
                Integer index = Integer.valueOf(fields[i], 10);
                Item toItem = (Item)items.get(index);
                if (!bundle.isValidConstraint(fromItem, toItem)) continue;
                Link link = new Link();
                link.setFrom(fromItem);
                link.setTo(toItem);
                link.setLabel(fromItem.getLevel().getName() + "-" + toItem.getLevel().getName());
                bundle.getLinksAsSet().add(link);
                System.out.println("Link " + fromItem.getLevel().getName() + "." + fromItem.toString() + " -> " + toItem.getLevel().getName() + "." + toItem.toString());
            }
        }
    }
}

