/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.view;

import ips.annot.model.db.EventItem;
import ips.annot.view.ItemViewer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class EventItemViewer
extends ItemViewer {
    private final int MIN_WIDTH = 32;
    private final int MIN_HEIGHT = 16;
    private final int X_PADDING = 4;
    private final int Y_PADDING = 2;
    private Font font = new Font("Sans-serif", 0, 12);
    private FontMetrics fontMetrics = this.getFontMetrics(this.font);
    private int lineHeight;
    private int width = 32;
    private int height = 16;
    private EventItem eventItem;

    public EventItemViewer(EventItem eventItem) {
        super(eventItem);
        this.eventItem = eventItem;
        this.createGUI();
    }

    private void createGUI() {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.width = this.fontMetrics.stringWidth(this.eventItem.getLabelText()) + 8;
        if (this.width < 32) {
            this.width = 32;
        }
        this.lineHeight = this.fontMetrics.getHeight() + this.fontMetrics.getLeading() + this.fontMetrics.getDescent();
        this.height = 2 * this.lineHeight + 4;
        if (this.height < 16) {
            this.height = 16;
        }
        this.setSize(this.width, this.height);
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.BLACK);
        g.drawString(this.eventItem.getLabelText(), 1, this.lineHeight);
        g.drawString("" + this.eventItem.getSamplepoint(), 1, 2 * this.lineHeight);
        g.drawRect(0, 0, this.width - 1, this.height - 1);
    }
}

