package ips.annot.model.emu.webapp;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlType;

@XmlType( propOrder = {"activeButtons","perspectives"})
public class EMUwebAppConfig {
    
    public static class ActiveButtons{
        public boolean isSaveBundle() {
            return saveBundle;
        }
        public void setSaveBundle(boolean saveBundle) {
            this.saveBundle = saveBundle;
        }
        public boolean isShowHierarchy() {
            return showHierarchy;
        }
        public void setShowHierarchy(boolean showHierarchy) {
            this.showHierarchy = showHierarchy;
        }
        public ActiveButtons(){
            super();
        }
        
        boolean saveBundle=true;
        boolean showHierarchy=true;
    }
    
//    "EMUwebAppConfig": {
//    "activeButtons": {
//      "saveBundle": true,
//      "showHierarchy": true
//    }
//  }

    private ActiveButtons activeButtons=new ActiveButtons();

    public ActiveButtons getActiveButtons() {
        return activeButtons;
    }

    public void setActiveButtons(ActiveButtons activeButtons) {
        this.activeButtons = activeButtons;
    }
   
    
    private List<Perspective> perspectives=new ArrayList<Perspective>();

    public List<Perspective> getPerspectives() {
        return perspectives;
    }

    public void setPerspectives(List<Perspective> perspectives) {
        this.perspectives = perspectives;
    }
    
    public static EMUwebAppConfig defaultWithDefaultPerspective(){
        EMUwebAppConfig cfg=new EMUwebAppConfig();
        Perspective pers=new Perspective();
        pers.setName("default");
        SignalCanvases sc=new SignalCanvases();
        sc.getOrder().add("OSCI");
        sc.getOrder().add("SPEC");
        pers.setSignalCanvases(sc);
        cfg.getPerspectives().add(pers);
        return cfg;
    }
    
}
