/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.model.emu;

import ips.annot.model.db.AttributeDefinition;
import ips.annot.model.db.Database;
import ips.annot.model.db.LevelDefinition;
import ips.annot.model.db.LinkDefinition;
import ips.annot.model.db.Schema;
import ips.annot.model.emu.EmuPathInfo;
import ips.annot.model.emu.EmuTierInfo;
import ips.annot.model.emu.EmuTrackInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;

public class EmuTemplateConverter {
    public static final String SEGMENT = "SEGMENT";
    public static final String EVENT = "EVENT";
    private HashMap<String, EmuTierInfo> segmentTiers = new HashMap();
    private HashMap<String, EmuTierInfo> eventTiers = new HashMap();
    private HashMap<String, EmuPathInfo> filePaths = new HashMap();
    private HashMap<String, EmuTrackInfo> tracks = new HashMap();
    private Schema schema;

    public EmuTemplateConverter(Database database) {
        this.schema = database.getSchema();
    }

    public HashMap<String, EmuTierInfo> getSegmentTiers() {
        return this.segmentTiers;
    }

    public HashMap<String, EmuTierInfo> getEventTiers() {
        return this.eventTiers;
    }

    public HashMap<String, EmuPathInfo> getFilePaths() {
        return this.filePaths;
    }

    public HashMap<String, EmuTrackInfo> getTracks() {
        return this.tracks;
    }

    private LevelDefinition addTierDefinitionByName(String tierName) {
        LevelDefinition tierDefinition = this.schema.getLevelDefinitionByName(tierName);
        for (AttributeDefinition aDef : tierDefinition.getAttributeDefinitions()) {
            if (!tierName.equals(aDef.getName())) continue;
            return tierDefinition;
        }
        AttributeDefinition attributeDefinition = new AttributeDefinition();
        attributeDefinition.setName(tierName);
        attributeDefinition.setType("TEXT");
        tierDefinition.addAttributeDefinition(attributeDefinition);
        return tierDefinition;
    }

    public Database importTemplate(Database database, Vector<String> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            String[] items = lines.get(i).split("[\\t ]+");
            if (items[0].equalsIgnoreCase("level")) {
                String tierName = items[1];
                LevelDefinition subTierDefinition = this.addTierDefinitionByName(tierName);
                LinkDefinition linkDefinition = new LinkDefinition();
                if (items.length == 2) {
                    linkDefinition.setSuperLevel(null);
                    linkDefinition.setSubLevel(subTierDefinition);
                    linkDefinition.setType("INIT");
                } else if (items.length == 3 || items.length == 4) {
                    String superTierName = items[2];
                    LevelDefinition superTierDefinition = this.addTierDefinitionByName(superTierName);
                    linkDefinition.setSuperLevel(superTierDefinition);
                    linkDefinition.setSubLevel(subTierDefinition);
                    if (items.length == 4) {
                        linkDefinition.setType("MANY_TO_MANY");
                    } else {
                        linkDefinition.setType("ONE_TO_MANY");
                    }
                }
                this.schema.getConstraints().add(linkDefinition);
                System.out.println(tierName.toString());
                continue;
            }
            if (items[0].equals("label")) {
                String tierName = items[1];
                LevelDefinition tierDefinition = this.schema.getLevelDefinitionByName(tierName);
                String attributeName = items[2];
                AttributeDefinition attributeDefinition = new AttributeDefinition();
                attributeDefinition.setName(attributeName);
                attributeDefinition.setType("TEXT");
                tierDefinition.addAttributeDefinition(attributeDefinition);
                continue;
            }
            if (items[0].equals("legal")) continue;
            if (items[0].equals("labfile")) {
                float timeFactor = Float.parseFloat(items[7]);
                EmuTierInfo tierInfo = new EmuTierInfo(items[1], items[3], items[5], timeFactor);
                if (items[3].equals(SEGMENT)) {
                    this.segmentTiers.put(items[1], tierInfo);
                    continue;
                }
                if (!items[3].equals(EVENT)) continue;
                this.eventTiers.put(items[1], tierInfo);
                continue;
            }
            if (items[0].equals("path")) {
                EmuPathInfo pathInfo = new EmuPathInfo(items[1], new File(items[2]));
                this.filePaths.put(items[1], pathInfo);
                continue;
            }
            if (items[0].equals("track")) {
                EmuTrackInfo trackInfo = new EmuTrackInfo(items[1], items[2]);
                this.tracks.put(items[1], trackInfo);
                continue;
            }
            if (!items[0].equals("set")) continue;
        }
        return database;
    }
}

