/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.view;

import ips.annot.model.db.Bundle;
import ips.annot.model.db.EventItem;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.annot.model.db.Link;
import ips.annot.model.db.SegmentItem;
import ips.annot.view.EventItemViewer;
import ips.annot.view.IntervalItemViewer;
import ips.annot.view.ItemViewer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.HashMap;
import javax.swing.JPanel;

public class BundleViewer
extends JPanel {
    private final int MIN_WIDTH = 800;
    private final int MIN_HEIGHT = 600;
    private final int PREF_WIDTH = 1200;
    private final int PREF_HEIGHT = 800;
    private final int MAX_WIDTH = 3072;
    private final int MAX_HEIGHT = 2048;
    private Bundle bundle;
    private HashMap<Item, ItemViewer> itemViewerMap = new HashMap();
    private HashMap<Level, Point> tierMap = new HashMap();
    private int width = 1200;
    private int height = 800;

    public BundleViewer(Bundle bundle) {
        this.bundle = bundle;
        this.createGUI();
    }

    private void createGUI() {
        this.setLayout(null);
        this.setOpaque(true);
        this.setSize(this.width, this.height);
        int i = 0;
        int tierHeight = this.height / this.bundle.getLevels().size();
        for (Level tier : this.bundle.getLevels()) {
            Point tierOrigin = new Point(0, i * tierHeight);
            ++i;
            this.tierMap.put(tier, tierOrigin);
            int sumViewerWidth = 0;
            for (Item item : tier.getItems()) {
                ItemViewer viewer = null;
                if (item instanceof SegmentItem) {
                    viewer = new IntervalItemViewer((SegmentItem)item);
                } else if (item instanceof EventItem) {
                    viewer = new EventItemViewer((EventItem)item);
                } else if (item instanceof Item) {
                    viewer = new ItemViewer(item);
                } else {
                    System.out.println("ERROR: other type of viewer: " + viewer.getClass().getName() + ", " + viewer.getHeight());
                }
                this.itemViewerMap.put(item, viewer);
                sumViewerWidth += viewer.getWidth();
            }
            int x_spacing = (this.width - sumViewerWidth) / tier.getItems().size();
            Point itemViewerLocation = new Point(tierOrigin.x + x_spacing / 2, tierOrigin.y);
            for (Item item : tier.getItems()) {
                ItemViewer viewer = this.itemViewerMap.get(item);
                this.add(viewer);
                viewer.setLocation(itemViewerLocation);
                itemViewerLocation.x = itemViewerLocation.x + viewer.getWidth() + x_spacing;
            }
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        for (Link link : this.bundle.getLinksAsSet()) {
            Item fromItem = link.getFrom();
            Level fromTier = fromItem.getLevel();
            ItemViewer fromItemViewer = this.itemViewerMap.get(fromItem);
            Item toItem = link.getTo();
            Level toTier = toItem.getLevel();
            ItemViewer toItemViewer = this.itemViewerMap.get(toItem);
            if (fromItemViewer == null || toItemViewer == null) continue;
            g.setColor(Color.RED);
            Point fromPoint = null;
            Point toPoint = null;
            if (this.tierMap.get((Object)fromTier).y < this.tierMap.get((Object)toTier).y) {
                fromPoint = fromItemViewer.getBottomMid();
                toPoint = toItemViewer.getTopMid();
            } else {
                fromPoint = fromItemViewer.getTopMid();
                toPoint = toItemViewer.getBottomMid();
            }
            g.drawLine(fromPoint.x, fromPoint.y, toPoint.x, toPoint.y);
        }
    }
}

