/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.view;

import ips.annot.model.db.LevelDefinition;
import ips.annot.model.db.LinkDefinition;
import ips.annot.view.TierDefinitionViewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JPanel;

public class LinkDefinitionViewer
extends JPanel
implements MouseMotionListener {
    private static final int HIERARCHICAL = 0;
    private static final int CIRCULAR = 1;
    private Set<LinkDefinition> linkDefinitions;
    private Map<LevelDefinition, TierDefinitionViewer> mapViewers = new HashMap<LevelDefinition, TierDefinitionViewer>();

    public LinkDefinitionViewer(Set<LinkDefinition> constraints) {
        this.setLinkDefinitions(constraints);
        this.createGUI();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(250, 600);
    }

    public void addViewer(LevelDefinition definition) {
        if (!this.mapViewers.containsKey(definition)) {
            TierDefinitionViewer tdv = new TierDefinitionViewer();
            tdv.setTierDefinition(definition);
            tdv.addMouseMotionListener(this);
            this.mapViewers.put(definition, tdv);
        }
    }

    public Set<LinkDefinition> getConstraints() {
        return this.linkDefinitions;
    }

    public List<LinkDefinition> getRootConstraints() {
        Vector<LinkDefinition> rootConstraints = new Vector<LinkDefinition>();
        for (LinkDefinition c : this.getConstraints()) {
            if (c.getType() != "INIT") continue;
            rootConstraints.add(c);
        }
        return rootConstraints;
    }

    public void setLinkDefinitions(Set<LinkDefinition> linkDefinition) {
        this.linkDefinitions = linkDefinition;
    }

    public void rearrange(int order) {
        boolean x = false;
        boolean y = false;
        if (order == 1 || order == 0) {
            // empty if block
        }
    }

    private List<List<LevelDefinition>> getAllPaths(Set<LinkDefinition> constraints) {
        Vector<List<LevelDefinition>> paths = new Vector<List<LevelDefinition>>();
        return paths;
    }

    private void createGUI() {
        this.setLayout(null);
        this.setOpaque(true);
        this.setSize(250, 800);
        for (LinkDefinition c : this.linkDefinitions) {
            System.out.println("LinkDefinitionViewer(): " + c.toString());
            if (!c.getType().equals("INIT")) {
                this.addViewer(c.getSuperLevel());
            }
            this.addViewer(c.getSubLevel());
        }
        int y = 0;
        int x = 0;
        for (TierDefinitionViewer tdv : this.mapViewers.values()) {
            this.add(tdv);
            tdv.setLocation(new Point(x, y));
            System.out.println("LinkDefinitionViewer.createGUI(): " + x + ", " + y);
            y += 20;
            x += 10;
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (LinkDefinition c : this.linkDefinitions) {
            Point lp2;
            Point lp1;
            if (c.getType().equals("INIT")) continue;
            TierDefinitionViewer tdv1 = this.mapViewers.get(c.getSuperLevel());
            TierDefinitionViewer tdv2 = this.mapViewers.get(c.getSubLevel());
            Point p1 = tdv1.getLocation();
            Point p2 = tdv2.getLocation();
            if (c.getType().equals("MANY_TO_MANY")) {
                g.setColor(Color.RED);
            } else {
                g.setColor(Color.BLACK);
            }
            if (p1.y < p2.y) {
                lp1 = tdv1.getBottomMid();
                lp2 = tdv2.getTopMid();
            } else {
                lp1 = tdv1.getTopMid();
                lp2 = tdv2.getBottomMid();
            }
            g.drawLine(lp1.x, lp1.y, lp2.x, lp2.y);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }
}

