/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.textgrid;

import ips.annot.model.db.Bundle;
import ips.annot.model.db.EventItem;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.annot.model.db.SegmentItem;
import ips.annot.textgrid.TextGridFileParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;

public class TextGridExporter {
    String[] filenames;

    public TextGridExporter(String dirName, float sampleRate, String tierName, BufferedWriter writer) throws IOException {
        File directory = new File(dirName);
        FilenameFilter textGridFilter = new FilenameFilter(){

            @Override
            public boolean accept(File directory, String name) {
                return name.matches(".*\\..ext.rid");
            }
        };
        this.filenames = directory.list(textGridFilter);
        TextGridFileParser parser = new TextGridFileParser(sampleRate);
        for (int i = 0; i < this.filenames.length; ++i) {
            String textGridFileName = directory + "/" + this.filenames[i];
            File textGridFile = new File(textGridFileName);
            Bundle bundle = parser.parse(textGridFile, Charset.forName("UTF-8"));
            Level tier = bundle.getTierByName(tierName);
            if (tier == null) continue;
            for (Item item : tier.getItems()) {
                if (item.getClass().equals(EventItem.class)) {
                    EventItem ei = (EventItem)item;
                    if (!ei.getLabelText().trim().matches(".+")) continue;
                    writer.write(this.filenames[i] + "\t" + ei.getSamplepoint() + "\t" + ei.getLabelText().trim() + "\n");
                    continue;
                }
                if (!item.getClass().equals(SegmentItem.class)) continue;
                SegmentItem ii = (SegmentItem)item;
                if (!item.getLabelText().trim().matches(".+")) continue;
                writer.write(this.filenames[i] + "\t" + ii.getSampleStart() + "\t" + ii.getSampleDur() + "\t" + ii.getLabelText().trim() + "\n");
                writer.flush();
            }
        }
    }

    public static void main(String[] args) {
        String directoryName = args[0];
        float sampleRate = Float.parseFloat(args[1]);
        String tierName = args[2];
        String outfileName = args[3];
        try {
            File outputFile = new File(directoryName + "/" + outfileName);
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
            File directory = new File(directoryName);
            if (directory.isDirectory()) {
                File[] files = directory.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File speakerDirectory = files[i];
                    if (!speakerDirectory.isDirectory()) continue;
                    String dirName = speakerDirectory.getAbsolutePath();
                    new TextGridExporter(speakerDirectory.getAbsolutePath(), sampleRate, tierName, writer);
                }
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

