/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.textgrid;

import ips.annot.model.db.Bundle;
import ips.annot.model.db.EventItem;
import ips.annot.model.db.Item;
import ips.annot.model.db.Label;
import ips.annot.model.db.Level;
import ips.annot.model.db.LevelDefinition;
import ips.annot.model.db.SegmentItem;
import ips.annot.view.Viewer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;

public class TextGridFileParser {
    private static final boolean DEBUG = false;
    private static final int TAB_SPACES = 4;
    private static final String FILE_TYPE_KEY = "File type";
    private static final String CLASS_KEY = "class";
    private static final String OBJECT_CLASS_KEY = "Object class";
    private static final String TIERS_SIZE_KEY = "size";
    private static final String TIER_ITEM_KEY = "item";
    private static final String NAME_KEY = "name";
    private static final String INTERVALS_KEY = "intervals";
    private static final String POINTS_KEY = "points";
    private static final String XMIN_KEY = "xmin";
    private static final String XMAX_KEY = "xmax";
    private static final String TEXT_KEY = "text";
    private static final String TIME_KEY = "time";
    private static final String FILE_TYPE_VAL_OO_TEXTFILE = "ooTextFile";
    private static final String OBJECT_CLASS_VAL_TEXTGRID = "TextGrid";
    private static final String TIER_CLASS_VAL_INTERVAL = "IntervalTier";
    private static final String TIER_CLASS_VAL_TEXT = "TextTier";
    private float sampleRate;
    private String fileType = null;
    private String objectClass = null;
    private Integer tiersCount = null;
    private boolean hasTiers = false;
    private int tierIndex = -1;
    private Bundle bundle;
    private Level currentTier = null;
    private String currentTierClass = null;
    private String currentTierName = null;
    private Integer currentTierSize = null;
    private SegmentItem currentIntervalItem = null;
    private EventItem currentEventItem = null;
    private Integer currentElementIndex = null;
    private String tabString;
    private double minXmin;
    private double maxXmax;

    public TextGridFileParser(float sampleRate) {
        this.sampleRate = sampleRate;
        StringBuffer tabStringSb = new StringBuffer();
        for (int t = 0; t < 4; ++t) {
            tabStringSb.append(' ');
        }
        this.tabString = tabStringSb.toString();
    }

    Property parseProperty(String line) {
        return this.parseProperty(line, false);
    }

    Property parseProperty(String line, boolean doublequoted) {
        return this.parseProperty(line, "=", doublequoted);
    }

    Property parseProperty(String line, String separator, boolean doublequoted) {
        Property p = null;
        String[] kv = line.trim().split(separator, 2);
        if (kv.length == 2) {
            String key = kv[0].trim();
            String val = kv[1].trim();
            if (doublequoted) {
                val = val.replaceFirst("^\"", "");
                val = val.replaceFirst("\"$", "");
            }
            p = new Property(key, val);
        }
        return p;
    }

    private void parseTier(String trimmedLine) {
        Property p;
        if (this.currentTierClass == null && (p = this.parseProperty(trimmedLine, true)) != null && CLASS_KEY.equals(p.key)) {
            this.currentTierClass = p.value;
            if (this.currentTierClass.equals(TIER_CLASS_VAL_INTERVAL)) {
                this.bundle.getLevels().add(this.currentTier);
            } else if (this.currentTierClass.equals(TIER_CLASS_VAL_TEXT)) {
                this.bundle.getLevels().add(this.currentTier);
            } else {
                System.err.println("TextGrid tiers of class \"" + this.currentTierClass + "\" not supported!");
            }
        }
        if (this.currentTierName == null && (p = this.parseProperty(trimmedLine, true)) != null && NAME_KEY.equals(p.key)) {
            this.currentTierName = p.value;
            this.currentTier.getDefinition().setName(p.value);
        }
        if (this.currentTierClass != null) {
            LevelDefinition ld = this.currentTier.getDefinition();
            if (ld == null) {
                ld = new LevelDefinition();
                this.currentTier.setDefinition(ld);
            }
            if (this.currentTierClass.equals(TIER_CLASS_VAL_INTERVAL)) {
                ld.setType("SEGMENT");
                this.parseIntervalTier(trimmedLine);
            } else if (this.currentTierClass.equals(TIER_CLASS_VAL_TEXT)) {
                ld.setType("EVENT");
                this.parseTextTier(trimmedLine);
            }
        }
    }

    private long timeToFrames(double time) {
        double contFramePosition = (double)this.sampleRate * time;
        return Math.round(contFramePosition);
    }

    private void parseTextTier(String trimmedLine) {
        String intervalsPropertyStr;
        Property intervalsProperty;
        if (this.currentTierSize == null && trimmedLine.matches("points\\s*:.*") && (intervalsProperty = this.parseProperty(intervalsPropertyStr = trimmedLine.replaceFirst("points\\s*:", "").trim())) != null && intervalsProperty.key.equals(TIERS_SIZE_KEY)) {
            this.currentTierSize = Integer.parseInt(intervalsProperty.value);
        }
        if (trimmedLine.matches("points\\s*\\[\\s*[0-9]+\\s*\\]\\s*:\\s*")) {
            String pointIndexStr = trimmedLine.replaceFirst("points\\s*\\[\\s*", "");
            pointIndexStr = pointIndexStr.replaceFirst("\\s*\\]\\s*:\\s*", "");
            this.currentElementIndex = Integer.parseInt(pointIndexStr);
            this.currentEventItem = new EventItem();
            this.currentTier.getItems().add(this.currentEventItem);
            this.currentEventItem.setLevel(this.currentTier);
        } else {
            Property p = this.parseProperty(trimmedLine, true);
            if (p != null && this.currentEventItem != null) {
                if (p.key.equals(TIME_KEY)) {
                    double time = Double.parseDouble(p.value);
                    long frames = this.timeToFrames(time);
                    this.currentEventItem.setSamplepoint(frames);
                } else if (p.key.equals("mark")) {
                    this.currentEventItem.setLabel(this.currentTier.getName(), p.value);
                } else if (p.key.equals(TEXT_KEY)) {
                    this.currentEventItem.setLabel(this.currentTier.getName(), p.value);
                }
            }
        }
    }

    private void parseIntervalTier(String trimmedLine) {
        String intervalsPropertyStr;
        Property intervalsProperty;
        if (this.currentTierSize == null && trimmedLine.matches("intervals\\s*:.*") && (intervalsProperty = this.parseProperty(intervalsPropertyStr = trimmedLine.replaceFirst("intervals\\s*:", "").trim())) != null && intervalsProperty.key.equals(TIERS_SIZE_KEY)) {
            this.currentTierSize = Integer.parseInt(intervalsProperty.value);
        }
        if (trimmedLine.matches("intervals\\s*\\[\\s*[0-9]+\\s*\\]\\s*:\\s*")) {
            String intervalIndexStr = trimmedLine.replaceFirst("intervals\\s*\\[\\s*", "");
            intervalIndexStr = intervalIndexStr.replaceFirst("\\s*\\]\\s*:\\s*", "");
            this.currentElementIndex = Integer.parseInt(intervalIndexStr);
            this.currentIntervalItem = new SegmentItem();
            this.currentTier.getItems().add(this.currentIntervalItem);
            this.currentIntervalItem.setLevel(this.currentTier);
        } else {
            Property p = this.parseProperty(trimmedLine, true);
            if (p != null && this.currentIntervalItem != null) {
                if (p.key.equals(XMIN_KEY)) {
                    double minTime = Double.parseDouble(p.value);
                    long minFrames = this.timeToFrames(minTime);
                    this.currentIntervalItem.setSampleStart(minFrames);
                } else if (p.key.equals(XMAX_KEY)) {
                    double maxTime = Double.parseDouble(p.value);
                    long maxFrames = this.timeToFrames(maxTime);
                    this.currentIntervalItem.setSampleDur(maxFrames - this.currentIntervalItem.getSampleStart() - 1L);
                } else if (p.key.equals(TEXT_KEY)) {
                    this.currentIntervalItem.setLabel(this.currentTier.getName(), p.value);
                }
            }
        }
    }

    public Bundle parse(File textGridFile, Charset charset) throws IOException {
        FileInputStream fis = new FileInputStream(textGridFile);
        InputStreamReader reader = new InputStreamReader((InputStream)fis, charset);
        return this.parse(reader);
    }

    public Bundle parse(Reader reader) throws IOException {
        this.bundle = new Bundle();
        this.bundle.setSampleRate(Float.valueOf(this.sampleRate));
        LineNumberReader lnr = new LineNumberReader(reader);
        String line = null;
        String trimmedLine = null;
        while ((line = lnr.readLine()) != null) {
            Property p;
            trimmedLine = line.trim();
            if (this.fileType == null) {
                p = this.parseProperty(line, true);
                if (p == null || !p.key.equals(FILE_TYPE_KEY)) continue;
                this.fileType = p.value;
                continue;
            }
            if (this.objectClass == null) {
                p = this.parseProperty(line, true);
                if (p == null || !p.key.equals(OBJECT_CLASS_KEY)) continue;
                this.objectClass = p.value;
                continue;
            }
            if (!this.fileType.equals(FILE_TYPE_VAL_OO_TEXTFILE) || !this.objectClass.equals(OBJECT_CLASS_VAL_TEXTGRID)) continue;
            if (!this.hasTiers) {
                p = this.parseProperty(line, "\\s+", false);
                this.hasTiers = p != null && p.key.equals("tiers?") && p.value.equals("<exists>");
                continue;
            }
            if (this.tiersCount == null) {
                p = this.parseProperty(line);
                if (p == null || !p.key.equals(TIERS_SIZE_KEY)) continue;
                this.tiersCount = Integer.parseInt(p.value);
                continue;
            }
            if (trimmedLine.startsWith(TIER_ITEM_KEY)) {
                String tierIndexStr = trimmedLine.replaceFirst("item\\s*", "");
                if (!(tierIndexStr = tierIndexStr.replaceFirst("\\s*:$", "")).matches("\\[\\s*[0-9]+\\s*\\]")) continue;
                tierIndexStr = tierIndexStr.replaceFirst("\\[\\s*", "");
                tierIndexStr = tierIndexStr.replaceFirst("\\s*\\]", "");
                this.tierIndex = Integer.parseInt(tierIndexStr);
                this.currentTier = new Level();
                this.currentTierClass = null;
                this.currentTierName = null;
                this.currentTierSize = null;
                this.currentIntervalItem = null;
                continue;
            }
            this.parseTier(trimmedLine);
        }
        reader.close();
        return this.bundle;
    }

    private String keyValueString(String key, Object value) {
        Object valueStr = null;
        valueStr = value instanceof String ? "\"" + value + "\"" : value.toString();
        return key + " = " + (String)valueStr + "\n";
    }

    private String keyValueString(String indent, String key, Object value) {
        return indent + this.keyValueString(key, value);
    }

    private String header() {
        return this.keyValueString(FILE_TYPE_KEY, FILE_TYPE_VAL_OO_TEXTFILE) + this.keyValueString(OBJECT_CLASS_KEY, OBJECT_CLASS_VAL_TEXTGRID);
    }

    private Float sampleRateFromBundle(Item item) {
        Bundle b;
        Float srFb = null;
        Level lvl = item.getLevel();
        if (lvl != null && (b = lvl.getBundle()) != null) {
            srFb = b.getSampleRate();
        }
        return srFb;
    }

    private float sampleRateOfItem(Item item) {
        Float srFb = this.sampleRateFromBundle(item);
        if (srFb != null) {
            return srFb.floatValue();
        }
        return this.sampleRate;
    }

    private double xminOfItem(Item item) {
        float sr = this.sampleRateOfItem(item);
        Long sampleStart = item.getSampleStart();
        if (sampleStart == null) {
            sampleStart = this.bundle.startByContext(item);
        }
        double xmin = sampleStart != null ? (double)sampleStart.longValue() / (double)sr : this.minXmin;
        return xmin;
    }

    private double xmaxOfItem(Item item) {
        float sr = this.sampleRateOfItem(item);
        Long sampleEnd = item.getSampleEnd();
        if (sampleEnd == null) {
            sampleEnd = this.bundle.endByContext(item);
        }
        double xmax = sampleEnd != null ? (double)sampleEnd.longValue() / (double)sr : this.maxXmax;
        return xmax;
    }

    private void writeSegment(Item intervalItem, Writer writer, String tab) throws IOException {
        double xmin = this.xminOfItem(intervalItem);
        double xmax = this.xmaxOfItem(intervalItem);
        String text = "";
        List<Label> lblsList = intervalItem.getLabelsList();
        if (lblsList != null && lblsList.size() > 0) {
            text = lblsList.get(0).getValueString();
        }
        writer.write(this.keyValueString(tab, XMIN_KEY, xmin));
        writer.write(this.keyValueString(tab, XMAX_KEY, xmax));
        writer.write(this.keyValueString(tab, TEXT_KEY, text));
    }

    private void writeEvent(Item eventItem, Writer writer, String tab) throws IOException {
        float sr = this.sampleRateOfItem(eventItem);
        double time = (float)eventItem.getSamplepoint().longValue() * sr;
        String text = "";
        List<Label> lblsList = eventItem.getLabelsList();
        if (lblsList != null && lblsList.size() > 0) {
            text = lblsList.get(0).getValueString();
        }
        writer.write(this.keyValueString(tab, TIME_KEY, time));
        writer.write(this.keyValueString(tab, TEXT_KEY, text));
    }

    private void write(Level tier, Writer writer, String tab) throws IOException {
        block3: {
            String tierName;
            String tierType;
            block2: {
                tierType = tier.getDefinition().getType();
                tierName = tier.getName();
                if (!"SEGMENT".equals(tierType) && !"ITEM".equals(tierType)) break block2;
                List<Item> itemList = tier.getItems();
                writer.write(this.keyValueString(tab, CLASS_KEY, TIER_CLASS_VAL_INTERVAL));
                writer.write(this.keyValueString(tab, NAME_KEY, tierName));
                double xmin = this.getXmin(tier);
                double xmax = this.getXmax(tier);
                writer.write(this.keyValueString(tab, XMIN_KEY, xmin));
                writer.write(this.keyValueString(tab, XMAX_KEY, xmax));
                int itemCount = itemList.size();
                writer.write(this.keyValueString(tab, "intervals: size", itemCount));
                for (int index = 0; index < itemCount; ++index) {
                    Item intervalItem = itemList.get(index);
                    writer.write(tab + "intervals [" + index + "]:\n");
                    this.writeSegment(intervalItem, writer, tab.concat(this.tabString));
                }
                break block3;
            }
            if (!"EVENT".equals(tierType)) break block3;
            List<Item> itemList = tier.getItems();
            writer.write(this.keyValueString(tab, CLASS_KEY, TIER_CLASS_VAL_TEXT));
            writer.write(this.keyValueString(tab, NAME_KEY, tierName));
            double xmin = this.getXmin(tier);
            double xmax = this.getXmax(tier);
            writer.write(this.keyValueString(tab, XMIN_KEY, xmin));
            writer.write(this.keyValueString(tab, XMAX_KEY, xmax));
            int segsCount = itemList.size();
            writer.write(this.keyValueString(tab, "points: size", segsCount));
            for (int sc = 0; sc < segsCount; ++sc) {
                EventItem eventItem = (EventItem)itemList.get(sc);
                writer.write(tab + "points[" + sc + "]:\n");
                this.writeEvent(eventItem, writer, tab.concat(this.tabString));
            }
        }
    }

    public double getXmin(Level tier) {
        List<Item> items;
        if (tier != null && (items = tier.getItems()).size() > 0) {
            Item item = items.get(0);
            String lType = tier.getType();
            if ("SEGMENT".equals(lType) || "ITEM".equals(lType)) {
                return this.xminOfItem(item);
            }
            if (tier.getDefinition().getType().equals("EVENT")) {
                float sr = this.sampleRateOfItem(item);
                return (double)item.getSamplepoint().longValue() * (double)sr;
            }
        }
        return 0.0;
    }

    public double getXmax(Level tier) {
        List<Item> items;
        if (tier != null && (items = tier.getItems()).size() > 0) {
            int lastIndex = tier.getItems().size() - 1;
            String lType = tier.getType();
            if ("SEGMENT".equals(lType) || "ITEM".equals(lType)) {
                Item item = tier.getItems().get(lastIndex);
                return this.xmaxOfItem(item);
            }
            if ("EVENT".equals(lType)) {
                Item item = tier.getItems().get(lastIndex);
                float sr = this.sampleRateOfItem(item);
                return (double)item.getSamplepoint().longValue() / (double)sr;
            }
        }
        return 0.0;
    }

    private double getMinXmin(List<Level> levels) {
        double xmin = Double.MAX_VALUE;
        for (Level tier : levels) {
            double xMinLvl = this.getXmin(tier);
            if (!(xMinLvl < xmin)) continue;
            xmin = xMinLvl;
        }
        return xmin;
    }

    private double getMaxXmax(List<Level> levels) {
        double xmax = Double.MIN_VALUE;
        for (Level tier : levels) {
            double xmaxLvl = this.getXmax(tier);
            if (!(xmaxLvl > xmax)) continue;
            xmax = xmaxLvl;
        }
        return xmax;
    }

    private double maxXmax() {
        return this.getMaxXmax(this.bundle.getLevels());
    }

    private double minXmin() {
        return this.getMinXmin(this.bundle.getLevels());
    }

    public void write(Bundle bundle, Writer writer) throws IOException {
        String tab = "";
        this.bundle = bundle;
        try {
            writer.write(this.header());
            writer.write("\n");
            List<Level> levels = bundle.getLevels();
            int tierCount = levels.size();
            if (tierCount > 0) {
                this.minXmin = this.minXmin();
                this.maxXmax = this.maxXmax();
                writer.write(this.keyValueString(tab, XMIN_KEY, this.minXmin));
                writer.write(this.keyValueString(tab, XMAX_KEY, this.maxXmax));
                writer.write("tiers? <exists>\n");
                writer.write(this.keyValueString(TIERS_SIZE_KEY, levels.size()));
                writer.write("item []:\n");
                tab = tab.concat(this.tabString);
                for (int tc = 0; tc < tierCount; ++tc) {
                    writer.write(this.tabString + "item [" + tc + "]:\n");
                    Level segmentLvl = levels.get(tc);
                    this.write(segmentLvl, writer, tab.concat(this.tabString));
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            writer.close();
        }
    }

    public static void main(String[] args) {
        Charset cs = Charset.forName("UTF-8");
        TextGridFileParser tfp = new TextGridFileParser(44100.0f);
        File tgf = new File(args[0]);
        try {
            Bundle bundle = tfp.parse(tgf, Charset.forName("UTF-8"));
            bundle.getSignalpaths().add(tgf.getAbsolutePath());
            System.out.println("Bundle: " + bundle.toString());
            Viewer viewer = new Viewer(tgf.getName(), bundle);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class Property {
        public String key;
        public String value;

        public Property(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

