/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.autoannotator.impl.ws.bas.maus;

import ips.annot.autoannotator.AutoAnnotation;
import ips.annot.autoannotator.AutoAnnotationServiceDescriptor;
import ips.annot.autoannotator.AutoAnnotator;
import ips.annot.autoannotator.AutoAnnotatorException;
import ips.annot.autoannotator.BundleAutoAnnotation;
import ips.annot.autoannotator.impl.ws.bas.BasicBasServiceClient;
import ips.annot.autoannotator.impl.ws.bas.maus.MAUSAnnotatorServiceDescriptor;
import ips.annot.model.PredefinedLevelDefinition;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.Level;
import ips.annot.model.db.LinkDefinition;
import ips.annot.partitur.PartiturParser;
import ipsk.io.StreamCopy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class MAUSServiceClient
extends BasicBasServiceClient {
    public static final MAUSAnnotatorServiceDescriptor DESCRIPTOR = new MAUSAnnotatorServiceDescriptor();
    private static final boolean DEBUG = false;
    private static final String URL = "https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/runMAUS";
    private static final String PARAM_LANGUAGE = "LANGUAGE";
    private static final String PARAM_INFORMAT = "INFORMAT";
    private static final String PARAM_OUTFORMAT = "OUTFORMAT";
    private static final String PARAM_BPF = "BPF";
    private static final String PARAM_USETRN = "USETRN";
    private static final String PARAM_SIGNAL = "SIGNAL";
    private static final String PARAM_INSKANTEXTGRID = "INSKANTEXTGRID";
    private static final String PARAM_INSORTTEXTGRID = "INSORTTEXTGRID";
    public static final String RESPONSE_XML_TOP_ELEM = "WebServiceResponseLink";
    public static final String RESPONSE_XML_DOWNLOAD_ELEM = "downloadLink";
    public static final String RESPONSE_XML_SUCCESS_ELEM = "success";
    private boolean insertKanonicalTier = false;
    private boolean insertOrthographyTier = false;

    public boolean isInsertKanonicalTier() {
        return this.insertKanonicalTier;
    }

    public void setInsertKanonicalTier(boolean insertKanonicalTier) {
        this.insertKanonicalTier = insertKanonicalTier;
    }

    public boolean isInsertOrthographyTier() {
        return this.insertOrthographyTier;
    }

    public void setInsertOrthographyTier(boolean insertOrthographyTier) {
        this.insertOrthographyTier = insertOrthographyTier;
    }

    public AutoAnnotation webMAUSClient(File audioFile, String kanCont, Locale loc) throws AutoAnnotatorException {
        try {
            this.getServerCaps();
        }
        catch (Exception exception) {
            // empty catch block
        }
        AutoAnnotation anno = null;
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httppost = new HttpPost(URL);
        FileBody audio = new FileBody(audioFile, ContentType.create((String)"audio/wav"), audioFile.getName());
        String iso639ThreeLetters = loc.getISO3Language();
        StringBody languageBody = new StringBody(iso639ThreeLetters, DEFAULT_TEXT_CONTENT_TYPE);
        StringBody trueBody = new StringBody("true", ContentType.TEXT_PLAIN);
        StringBody falseBody = new StringBody("false", ContentType.TEXT_PLAIN);
        MultipartEntityBuilder reqEntityBuilder = MultipartEntityBuilder.create();
        reqEntityBuilder.addPart(PARAM_LANGUAGE, (ContentBody)languageBody);
        reqEntityBuilder.addPart(PARAM_INFORMAT, (ContentBody)new StringBody("bpf", DEFAULT_TEXT_CONTENT_TYPE));
        reqEntityBuilder.addPart(PARAM_OUTFORMAT, (ContentBody)new StringBody("par", DEFAULT_TEXT_CONTENT_TYPE));
        ByteArrayBody ib = new ByteArrayBody(kanCont.getBytes(DEFAULT_CHARSET), DEFAULT_TEXT_CONTENT_TYPE, "SpeechDatabaseTools_input" + UUID.randomUUID() + ".par");
        reqEntityBuilder.addPart(PARAM_BPF, (ContentBody)ib);
        reqEntityBuilder.addPart(PARAM_USETRN, (ContentBody)falseBody);
        reqEntityBuilder.addPart(PARAM_SIGNAL, (ContentBody)audio);
        if (this.insertKanonicalTier) {
            reqEntityBuilder.addPart(PARAM_INSKANTEXTGRID, (ContentBody)trueBody);
        }
        if (this.insertOrthographyTier) {
            reqEntityBuilder.addPart(PARAM_INSORTTEXTGRID, (ContentBody)trueBody);
        }
        HttpEntity reqEntity = reqEntityBuilder.build();
        httppost.setEntity(reqEntity);
        try {
            HttpEntity resEntity;
            InputStream content;
            URL dlUrl;
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            StatusLine sl = response.getStatusLine();
            int status = sl.getStatusCode();
            if (status >= 200 && status < 300 && (dlUrl = this.downloadLinkFromResponse(content = (resEntity = response.getEntity()).getContent())) != null) {
                URLConnection dlConn = dlUrl.openConnection();
                InputStream is = dlConn.getInputStream();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                StreamCopy.copy((InputStream)is, (OutputStream)bos);
                byte[] mausBinData = bos.toByteArray();
                ByteArrayInputStream bisD = new ByteArrayInputStream(mausBinData);
                ByteArrayInputStream bis = new ByteArrayInputStream(mausBinData);
                InputStreamReader conReader = new InputStreamReader((InputStream)bis, DEFAULT_CHARSET);
                PartiturParser pp = new PartiturParser();
                HashSet<LinkDefinition> linkDefs = new HashSet<LinkDefinition>();
                LinkDefinition ortKanLd = new LinkDefinition();
                ortKanLd.setSuperLevel(PredefinedLevelDefinition.ORT.getLevelDefinition());
                ortKanLd.setSubLevel(PredefinedLevelDefinition.KAN.getLevelDefinition());
                ortKanLd.setType("ONE_TO_MANY");
                linkDefs.add(ortKanLd);
                LinkDefinition kanMauLd = new LinkDefinition();
                kanMauLd.setSuperLevel(PredefinedLevelDefinition.KAN.getLevelDefinition());
                kanMauLd.setSubLevel(PredefinedLevelDefinition.MAU.getLevelDefinition());
                kanMauLd.setType("ONE_TO_MANY");
                linkDefs.add(kanMauLd);
                pp.setLinkDefinitions(linkDefs);
                Bundle inputBundle = null;
                if (this.annotationRequest != null) {
                    inputBundle = this.annotationRequest.getBundle();
                    ArrayList<Level> lvlsToRemove = new ArrayList<Level>();
                    List<Level> lvls = inputBundle.getLevels();
                    for (Level lvl : lvls) {
                        String lvlNm = lvl.getName();
                        if (!PredefinedLevelDefinition.ORT.getKeyName().equals(lvlNm) && !PredefinedLevelDefinition.KAN.getKeyName().equals(lvlNm) && !PredefinedLevelDefinition.MAU.getKeyName().equals(lvlNm)) continue;
                        lvlsToRemove.add(lvl);
                    }
                    for (Level ltr : lvlsToRemove) {
                        inputBundle.removeLevelAndAssociatedLinks(ltr);
                    }
                }
                Bundle bundle = pp.parse(inputBundle, conReader);
                conReader.close();
                BundleAutoAnnotation baa = new BundleAutoAnnotation(bundle);
                return baa;
            }
        }
        catch (ClientProtocolException e) {
            throw new AutoAnnotatorException(e);
        }
        catch (IOException e) {
            throw new AutoAnnotatorException(e);
        }
        return anno;
    }

    public static void main(String[] args) {
        MAUSServiceClient wmc = new MAUSServiceClient();
        String exampleKan = new String("KAN: 0 ?aInts@ltsIm6\nKAN: 1 tsvaIhUnd6t?axtUntfi:rtsIC\nKAN: 2 mark\nORT: 0 Einzelzimmer\nORT: 1 zweihundertachtundvierzig\nORT: 2 Mark");
        try {
            AutoAnnotation aa = wmc.webMAUSClient(new File("/homes/klausj/examples-WebMAUS/example2.wav"), exampleKan, Locale.GERMAN);
            System.out.println(aa);
        }
        catch (AutoAnnotatorException e) {
            e.printStackTrace();
        }
    }

    @Override
    public AutoAnnotation call() throws Exception {
        String sigPath;
        File audioFile;
        List<String> sigPaths;
        Bundle inputBundle = this.annotationRequest.getBundle();
        if (inputBundle != null && (sigPaths = inputBundle.getSignalpaths()) != null && sigPaths.size() == 1 && (audioFile = new File(sigPath = sigPaths.get(0))) != null && audioFile.exists()) {
            Level ortLvl = inputBundle.getTierByName(PredefinedLevelDefinition.ORT.getKeyName());
            Level kanLvl = inputBundle.getTierByName(PredefinedLevelDefinition.KAN.getKeyName());
            ArrayList<Level> lvls = new ArrayList<Level>();
            if (ortLvl != null) {
                lvls.add(ortLvl);
            }
            if (kanLvl == null) {
                throw new AutoAnnotatorException("MAUS web service client requires valid KAN input tier/level");
            }
            lvls.add(kanLvl);
            PartiturParser pp = new PartiturParser();
            String ortKanCont = pp.writeLevels(lvls, inputBundle.getLinksAsSet());
            AutoAnnotation baa = this.webMAUSClient(audioFile, ortKanCont, inputBundle.getLocale());
            return baa;
        }
        throw new AutoAnnotatorException();
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isBundleSupported(Bundle bundle) throws IOException {
        boolean basicSupp = super.isBundleSupported(bundle);
        if (!basicSupp) {
            return basicSupp;
        }
        Level kanLvl = bundle.getTierByName(PredefinedLevelDefinition.KAN.getKeyName());
        return kanLvl != null;
    }

    @Override
    public void setAnnotationRequest(AutoAnnotator.AnnotationRequest ar) {
        this.annotationRequest = ar;
    }

    @Override
    public AutoAnnotationServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }
}

