/*
 * Decompiled with CFR 0.152.
 */
package ips.annot.view;

import ips.annot.model.db.Item;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class ItemViewer
extends JPanel
implements MouseListener {
    public static Color COL_NEUTRAL = Color.WHITE;
    public static Color COL_MARKED = Color.RED;
    public static Color COL_HIGHLIGHTED = Color.YELLOW;
    public static final String MARKED = "marked";
    public static final String HIGHLIGHTED = "highlighted";
    private final int X_PADDING = 4;
    private final int Y_PADDING = 2;
    private final int MIN_WIDTH = 32;
    private final int MIN_HEIGHT = 16;
    private Font font = new Font("Sans-serif", 0, 12);
    private FontMetrics fontMetrics = this.getFontMetrics(this.font);
    private Item item;
    private boolean marked = false;
    private boolean highlighted = false;
    private int width;
    private int height;

    public ItemViewer(Item item) {
        this.item = item;
        this.createGUI();
    }

    private void createGUI() {
        this.setLayout(null);
        this.setOpaque(true);
        this.setSize(this.getSize());
        this.addMouseListener(this);
        this.setBackground(COL_NEUTRAL);
    }

    public Item getItem() {
        return this.item;
    }

    private void toggleMarked() {
        if (this.isMarked()) {
            this.setMarked(false);
            this.setBackground(COL_NEUTRAL);
        } else {
            this.setMarked(true);
            this.setBackground(COL_MARKED);
        }
    }

    @Override
    public Dimension getSize() {
        this.width = this.fontMetrics.stringWidth(this.item.getLabelText()) + 8;
        if (this.width < 32) {
            this.width = 32;
        }
        this.height = this.fontMetrics.getHeight() + 4;
        if (this.height < 16) {
            this.height = 16;
        }
        return new Dimension(this.width, this.height);
    }

    public Point getTopMid() {
        int x = this.getLocation().x + this.width / 2;
        int y = this.getLocation().y;
        return new Point(x, y);
    }

    public Point getBottomMid() {
        int x = this.getLocation().x + this.width / 2;
        int y = this.getLocation().y + this.height;
        return new Point(x, y);
    }

    public Point getLeftMid() {
        int x = this.getLocation().x;
        int y = this.getLocation().y + this.height / 2;
        return new Point(x, y);
    }

    public Point getRightMid() {
        int x = this.getLocation().x + this.width;
        int y = this.getLocation().y + this.height / 2;
        return new Point(x, y);
    }

    @Override
    public void paintComponent(Graphics g) {
        int h = this.fontMetrics.getHeight();
        int l = this.fontMetrics.getLeading();
        int d = this.fontMetrics.getDescent();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.BLACK);
        g.drawString(this.item.getLabelText(), 4, 2 + h - d - l);
        g.drawRect(0, 0, this.width - 1, this.height - 1);
    }

    private void setMarked(boolean marked) {
        this.marked = marked;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        if (!this.isMarked()) {
            this.setBackground(COL_HIGHLIGHTED);
        } else {
            this.setBackground(COL_MARKED);
        }
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        if (!this.isMarked()) {
            this.setBackground(COL_NEUTRAL);
        } else {
            this.setBackground(COL_MARKED);
        }
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.toggleMarked();
    }
}

