//    Speechrecorder
// 	  (c) Copyright 2018
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.



package ipsk.apps.speechrecorder.db.export.emu;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;

import ipsk.apps.speechrecorder.SpeechRecorderException;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.project.ProjectManagerException;
import ipsk.awt.ProgressWorker;
import ipsk.awt.WorkerException;

/**
 * @author klausj
 *
 */
public class EmuExportWorker extends ProgressWorker {

        private EmuExporter emuExporter;
        private Path exportBasepath;
    
        public Path getExportBasepath() {
            return exportBasepath;
        }

        public void setExportBasepath(Path exportBasepath) {
            this.exportBasepath = exportBasepath;
        }

        public void setProjectContext(URL context) {
            emuExporter.setProjectContext(context);
        }

        public void config(ProjectConfiguration cfgProject) throws ProjectManagerException {
            emuExporter.config(cfgProject);
        }


        public EmuExportWorker(){
            super();
            emuExporter=new EmuExporter();
        }
        
        protected void doWork() throws WorkerException{
            try {
                emuExporter.exportProjectAsEmuDB(exportBasepath);
            } catch (IOException | URISyntaxException | SpeechRecorderException | ProjectManagerException e) {
               
                e.printStackTrace();
                throw new WorkerException("Error processing EMU export: "+e.getLocalizedMessage(),e);
            }
        }
        
        
        
}
