//    Speechrecorder
// 	  (c) Copyright 2018
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.



package ipsk.apps.speechrecorder.annotation.auto;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;

import ips.annot.autoannotator.AutoAnnotator;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.Session;
import ipsk.audio.AudioSourceException;
import ipsk.audio.ConvenienceFileAudioSource;
import ipsk.db.speech.Mediaitem;

/**
 * @author klausj
 *
 */
public class AutoAnnotationManager {
    
    private Session annotationSession;

    public Session getAnnotationSession() {
        return annotationSession;
    }
    public void setAnnotationSession(Session annotationSession) {
        this.annotationSession = annotationSession;
    }
    
    // TODO duplicate code in SessionManager
    public Bundle buildBundle(String bundleName,File[] recFiles) throws IOException, UnsupportedAudioFileException, AudioSourceException{
       
        // build Bundle
        Bundle bundle=new Bundle();
        bundle.setSession(annotationSession);
        bundle.setName(bundleName);
       
            if(recFiles!=null && recFiles.length>0){
                File masterFile=recFiles[0];
                bundle.setAnnotates(masterFile.getName());
                ConvenienceFileAudioSource cfas=new ConvenienceFileAudioSource(masterFile);
                AudioFormat af=cfas.getFormat();
                long fl=cfas.getFrameLength();
                bundle.setSampleRate(af.getSampleRate());
                bundle.setFrameLength(fl);
            }
            List<String> sigPathes=new ArrayList<String>();
            for(File rf:recFiles){
                sigPathes.add(rf.getAbsolutePath());
            }
            bundle.setSignalpaths(sigPathes);
            
           
        
        return bundle;
    }
}
