//    Speechrecorder
//    (c) Copyright 2009-2011
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.

//
//  ProjectManager.java
//  JSpeechRecorder
//
//  Created by Christoph Draxler on Thu Dec 05 2002.
//

package ipsk.apps.speechrecorder.project;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Handler;
import java.util.logging.Logger;

import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXB;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import ips.annot.BundleAnnotationPersistor;
import ips.annot.BundleAnnotationPersistorServiceDescriptor;
import ips.annot.autoannotator.AutoAnnotationServiceDescriptor;
import ips.annot.autoannotator.AutoAnnotator;
import ips.annot.model.PredefinedLevelDefinition;
import ips.annot.model.db.LevelDefinition;
import ips.annot.model.db.Schema;
import ipsk.apps.speechrecorder.PluginLoadingException;
import ipsk.apps.speechrecorder.SpeakerManager;
import ipsk.apps.speechrecorder.SpeechRecorder;
import ipsk.apps.speechrecorder.SpeechRecorderException;
import ipsk.apps.speechrecorder.SpeechRecorderUI;
import ipsk.apps.speechrecorder.TimeLogFormatter;
import ipsk.apps.speechrecorder.UIResources;
import ipsk.apps.speechrecorder.actions.EditScriptAction;
import ipsk.apps.speechrecorder.actions.ExportScriptAction;
import ipsk.apps.speechrecorder.actions.ImportScriptAction;
import ipsk.apps.speechrecorder.annotation.auto.AutoAnnotationPluginManager;
//import ipsk.apps.speechrecorder.annotation.auto.impl.PromptAutoAnnotator;
import ipsk.apps.speechrecorder.audio.AudioManager;
import ipsk.apps.speechrecorder.audio.AudioManagerException;
import ipsk.apps.speechrecorder.config.Annotation;
import ipsk.apps.speechrecorder.config.AnnotationPersistence;
import ipsk.apps.speechrecorder.config.AutoAnnotation;
import ipsk.apps.speechrecorder.config.BundleAnnotationPersistorConfig;
import ipsk.apps.speechrecorder.config.ChannelRouting;
import ipsk.apps.speechrecorder.config.ConfigHelper;
import ipsk.apps.speechrecorder.config.Format;
import ipsk.apps.speechrecorder.config.Formatter;
import ipsk.apps.speechrecorder.config.ItemcodeGeneratorConfiguration;
import ipsk.apps.speechrecorder.config.LoggingConfiguration;
import ipsk.apps.speechrecorder.config.MixerName;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.PromptBeep;
import ipsk.apps.speechrecorder.config.PromptConfiguration;
import ipsk.apps.speechrecorder.config.RecordingConfiguration;
import ipsk.apps.speechrecorder.config.RecordingConfiguration.CaptureScope;
import ipsk.apps.speechrecorder.monitor.StartStopSignal;
import ipsk.apps.speechrecorder.monitor.plugins.SimpleTrafficLight;
import ipsk.apps.speechrecorder.prompting.PromptPresenterPluginManager;
import ipsk.apps.speechrecorder.script.ItemcodeGenerator;
import ipsk.apps.speechrecorder.script.RecScriptManager;
import ipsk.apps.speechrecorder.script.RecScriptSchemaVersionNewerException;
import ipsk.apps.speechrecorder.script.RecScriptStoreStatusChanged;
import ipsk.apps.speechrecorder.script.RecscriptHandler;
import ipsk.apps.speechrecorder.script.RecscriptManagerEvent;
import ipsk.apps.speechrecorder.script.RecscriptManagerException;
import ipsk.apps.speechrecorder.script.RecscriptManagerListener;
import ipsk.apps.speechrecorder.session.SessionManager;
import ipsk.apps.speechrecorder.session.SessionManagerListener;
import ipsk.apps.speechrecorder.storage.ActiveSessionStorageManager;
import ipsk.apps.speechrecorder.storage.StorageManagerException;
import ipsk.apps.speechrecorder.workspace.WorkspaceException;
import ipsk.audio.AudioController4;
import ipsk.audio.AudioControllerException;
import ipsk.audio.DeviceInfo;
import ipsk.audio.FileAudioSource;
import ipsk.audio.ajs.AJSAudioSystem;
import ipsk.audio.ajs.AJSDevice;
import ipsk.audio.ajs.AJSDeviceInfo;
import ipsk.audio.ajs.MixerProviderServiceDescriptor;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.capture.PrimaryRecordTarget;
import ipsk.audio.mixer.MixerManager;
import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.samples.SampleManager;
import ipsk.beans.DOMCodec;
import ipsk.beans.DOMCodecException;
import ipsk.db.speech.Script;
import ipsk.db.speech.Section;
import ipsk.io.FileUtils;
import ipsk.io.StreamCopy;
import ipsk.net.SimplePasswordAuthentication;
import ipsk.net.URLContext;
import ipsk.net.Upload;
import ipsk.net.UploadCache;
import ipsk.net.UploadException;
import ipsk.net.UploadFile;
import ipsk.persistence.AtomicIntegerSequenceGenerator;
import ipsk.text.StringSequenceBuilder;
import ipsk.util.collections.ObservableArrayList;
import ipsk.util.collections.ObservableList;
import ipsk.util.logging.FileHandler;
import ipsk.util.services.ServicesInspector;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;


public class ActiveProjectManager extends ProjectManager implements RecscriptManagerListener,SessionManagerListener{

   
    public final static boolean DEBUG=false;
   
    // TODO comment out for new SpeechDB speakers XML format
	private final String SPEAKER_FILE_SUFFIX = "_speakers.xml";
//	private final String SPEAKER_FILE_SUFFIX = "_speakers.txt";

	private final String REC_SCRIPT_FILE_EXTENSION = "_script.xml";

	private final String LOG_FILE_SUFFIX = "_log.log";

	private final String TIME_LOG_FILE_SUFFIX = "_timelog.log";

	private final String TEMP_FILE_PREFIX = "IPSK_";
	
    private final String REC_SCRIPT_EXAMPLE = "ExampleRecScript_3.xml";
    
  
    public final String PREFERRED_START_STOP_SIGNAL_PLUGIN="ips.apps.speechrecorder.startstopsignal.Ampelmaennchen";

	private long SHUTDOWN_RETRY_DELAY = 2000;

	

	// private long CACHE_HOLD_SIZE=100000000; // 100 MB
	// private long CACHE_HOLD_SIZE =0; // 0 MB

	public String LOG_HANDLER_NAME = "default";

	public String TIMELOG_HANDLER_NAME = "timelog";

	public static ipsk.apps.speechrecorder.config.Handler[] DEF_LOG_HANDLERS = new ipsk.apps.speechrecorder.config.Handler[0];

	protected final static Formatter TIME_LOG_FORMATTER_CFG = new Formatter(
			TimeLogFormatter.class.getName(), "Time logger");

	public final static Formatter[] LOG_FORMATTERS = {
			new Formatter(null, "(Default)"),
			new Formatter("java.util.logging.SimpleFormatter", "Plain Text"),
			new Formatter("java.util.logging.XMLFormatter", "XML"),
			TIME_LOG_FORMATTER_CFG };

	private static final float PREFERRED_LINE_BUFFER_SIZE_MILLIS = 4000;



	public static ipsk.apps.speechrecorder.config.Logger[] AVAIL_LOGGERS = new ipsk.apps.speechrecorder.config.Logger[0];

	
	public static Action[] ACTIONS = new Action[0];

	private Logger logger;

//	private Level logLevel = Level.OFF;

	private ipsk.util.logging.FileHandler logFileHandler;

	private ipsk.util.logging.FileHandler timeLogFileHandler;

	private Logger timeLogger;

	private DOMCodec domCodec;

	private DOMConverter domConverter;


	private URL projectURL;


	private boolean projectConfigurationSaved;



	private GraphicsConfiguration speakerScreenConfig=null;

	private GraphicsConfiguration experimenterScreenConfig=null;

	protected ActiveSessionStorageManager storageManager;
	
	private SessionManager sessionManager;
	

	public SessionManager getSessionManager() {
        return sessionManager;
    }

    private AudioManager audioManager;
	private AudioController4 audioController;

	private boolean audioEnabled;
	


	private UIResources uiString;

	private SpeechRecorderUI speechRecorderUI;

	public void setSpeechRecorderUI(SpeechRecorderUI speechRecorderUI) {
        this.speechRecorderUI = speechRecorderUI;
        
        sessionManager.setSpeechRecorderUI(speechRecorderUI);
        
      
        Action[] sessionActions=sessionManager.getActions();
        
// TODO ugly !!        
        ACTIONS = new Action[sessionActions.length+3];
        int i=0;
        for(;i<sessionActions.length;i++){
            ACTIONS[i]=sessionActions[i];
        }
        ACTIONS[i++]=editScriptAction;
        ACTIONS[i++]=importScriptAction;
        ACTIONS[i++]=exportScriptAction;
        
    }

  





//	private URL sessionURL;



	private File lastPromptSelectionDir=null;



	// private File applicationDirectory;


//	private Properties properties;

//	private String labelFileExtension;


	


	private AudioFileFormat audioFileFormat;

	private String audioControllerClassName;

//	private int speakerID;

//	private String speakerCode;



	// private VectorBufferedOutputStream[] recordingOutputStreams;
//	private UploadCacheUI uploadCacheUI;

	private UploadCache uploadCache;

	private boolean useUploadCache;

	private boolean waitForCompleteUpload;

	private boolean uploadDuringSessionRecording=true;

	// private boolean useVectorBuffers;
//	private String user;

//	private String password;



//	private File webSessionLogFile = null;

	// thread to pass on status changes to RecStatus, timer to delay
	// execution of status changes
	// private int tmpStatus;
	

	// actions
    // TODO where to put the actions ?


	

	

	
	private EditScriptAction editScriptAction;
	public EditScriptAction getEditScriptAction() {
        return editScriptAction;
    }

    private ImportScriptAction importScriptAction;

	public ImportScriptAction getImportScriptAction() {
        return importScriptAction;
    }


//    private boolean promptPlayed=false;


//    private WorkspaceManager workspaceManager;
    
    
    
    private Player beepPlayer;

    private Mixer promptMixer;
    
//    private boolean promptAudioLineInUse=false;

   
 
   

//    private boolean useTempFile=false;
    private PrimaryRecordTarget primaryRecordTarget;
    
    private PromptPresenterPluginManager promptPresenterPluginManager;
    private AutoAnnotationPluginManager autoAnnotatorPluginManager;
    public AutoAnnotationPluginManager getAutoAnnotatorPluginManager() {
        return autoAnnotatorPluginManager;
    }

    
    private ItemcodeGenerator itemcodeGenerator;


	

    private Schema schema;

    
    private List<BundleAnnotationPersistor> bundleAnnotationPersistorList=new ArrayList<>();

    private List<BundleAnnotationPersistorServiceDescriptor> availableBundleAnnotationServiceDescriptors;



private ExportScriptAction exportScriptAction;

public ExportScriptAction getExportScriptAction() {
    return exportScriptAction;
}

private Integer lastSessionId=null;





private Set<String> itemCodesInUse=null;

private AtomicIntegerSequenceGenerator sequenceGenerator;
public AtomicIntegerSequenceGenerator getSequenceGenerator() {
	return sequenceGenerator;
}


private File workspaceDir;

private ProjectManagerListener listener=null;

protected List<AutoAnnotator> enabledAutoAnnotators;



	public List<AutoAnnotator> getEnabledAutoAnnotators() {
    return enabledAutoAnnotators;
}



    public ProjectManagerListener getListener() {
    return listener;
}



public void setListener(ProjectManagerListener listener) {
    this.listener = listener;
}



    /** Create Speechrecorder application
     * Must be called from AWT event thread ! 
     * @param projectFileURL URL of the project configuration file
     * @param user user for web authentication
     * @param password password for web authentication
     * @throws ClassNotFoundException
     * @throws DOMCodecException
     * @throws DOMConverterException
     * @throws IOException
     * @throws PluginLoadingException
     * @throws AudioControllerException
     * @throws ParserConfigurationException
     * @throws SAXException
     * @throws StorageManagerException
     * @throws InstantiationException
     * @throws IllegalAccessException
     * @throws WorkspaceException
     */
    public ActiveProjectManager(PromptPresenterPluginManager ppPm,AutoAnnotationPluginManager aaPm,String projectFileURL, String user, String password)
    throws ClassNotFoundException, DOMCodecException,
    DOMConverterException, IOException, PluginLoadingException,
    AudioControllerException, ParserConfigurationException,
    SAXException, StorageManagerException, InstantiationException,
    IllegalAccessException, WorkspaceException {
    
    	super();
    	storageManager = new ActiveSessionStorageManager();
		projectStorageManager=storageManager;
        this.promptPresenterPluginManager=ppPm;
        this.autoAnnotatorPluginManager=aaPm;
     
        // register shutdown thread to close storage manager
        Thread shutDownThread=new Thread(){
            public void run(){
                if(DEBUG)System.out.println("Shutdown thread");
                if(storageManager!=null){
                    try {
                        storageManager.close(true);
                    } catch (StorageManagerException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutDownThread);
        
        sessionManager=new SessionManager();
        sessionManager.setListener(this);
        AJSAudioSystem.init();
        
        // initialize the logging mechanism
        ipsk.apps.speechrecorder.config.Handler logHandler = new ipsk.apps.speechrecorder.config.Handler(
                LOG_HANDLER_NAME);
        ipsk.apps.speechrecorder.config.Handler timeLogHandler = new ipsk.apps.speechrecorder.config.Handler(
                TIMELOG_HANDLER_NAME);
        timeLogHandler.setFormatter(TIME_LOG_FORMATTER_CFG);
        DEF_LOG_HANDLERS = new ipsk.apps.speechrecorder.config.Handler[] {
                logHandler, timeLogHandler };
        ipsk.apps.speechrecorder.config.Logger defLogger = new ipsk.apps.speechrecorder.config.Logger();
        defLogger.setName("ipsk.apps.speechrecorder");
        defLogger.setHandlerName(logHandler.getName());
        ipsk.apps.speechrecorder.config.Logger defTimeLogger = new ipsk.apps.speechrecorder.config.Logger();
        defTimeLogger.setName("time");
        defTimeLogger
        .setHandlerName(timeLogHandler.getName());
        logger = Logger.getLogger("ipsk.apps.speechrecorder");
        AVAIL_LOGGERS = new ipsk.apps.speechrecorder.config.Logger[] {
                defLogger, defTimeLogger };

        timeLogger = Logger.getLogger("time");
        // logger.setLevel(logLevel);
        // logger.info("Starting up ProjectManager");

        uiString = UIResources.getInstance();
        
        itemcodeGenerator=new ItemcodeGenerator();
        
        sequenceGenerator=new AtomicIntegerSequenceGenerator();
      
        Package configBasePack = Class.forName(
        "ipsk.apps.speechrecorder.config.ProjectConfiguration")
        .getPackage();
        audioEnabled = false;
    	new MixerManager();
        domCodec = new DOMCodec(configBasePack);
        domConverter = new DOMConverter();
        speakerFileName = null;
 
        recScriptManager.setSequenceGenerator(sequenceGenerator);
        recScriptManager.addRecscriptManagerListener(this);
     
        projectConfigurationSaved = true;
        
        

        editScriptAction = new EditScriptAction(this, "Edit script...");
        editScriptAction.setEnabled(false);
        importScriptAction=new ImportScriptAction(this,"Import text table...");
        importScriptAction.setEnabled(false);
        exportScriptAction=new ExportScriptAction(this,"Export script as text table file...");
        exportScriptAction.setEnabled(false);

//        StartPromptPlaybackAction startPromptAction=speechRecorderUI.getPrompter().getStartPromptPlaybackAction();
//        StopPromptPlaybackAction stopPromptAction=speechRecorderUI.getPrompter().getStopPromptPlaybackAction();
//        
//        ACTIONS = new Action[] { startRecordAction, stopRecordAction,
//                startAutoRecordingAction, pauseAutoRecordingAction,
//                continueAutoRecordingAction, advanceToNextAction,
//                forwardAction, backwardAction, startPlaybackAction,
//                pausePlaybackAction, stopPlaybackAction, continuePlaybackAction ,closeSpeakerDisplayAction,setIndexAction,editScriptAction,importScriptAction,exportScriptAction};
//        
//        actions= new Action[] {startRecordAction, stopRecordAction,
//                startAutoRecordingAction, pauseAutoRecordingAction,
//                continueAutoRecordingAction, startPromptAction,stopPromptAction, advanceToNextAction,
//                forwardAction, backwardAction, startPlaybackAction,
//                pausePlaybackAction, stopPlaybackAction, continuePlaybackAction,closeSpeakerDisplayAction};

        if (user != null) {
            Authenticator.setDefault(new SimplePasswordAuthentication(user,
                    password));
            logger.info("Set authenticator for user " + user);
        }
        if (projectFileURL != null) {
            projectURL = new URL(projectFileURL);
            // For testing ??
            InputStream projectFileStream = projectURL.openStream();
            projectFileStream.close();
        }
        // after all components are in place get an instance of RecStatus
       
        //recStat.attach(this);
        


        //              now determine the graphics environment: one or two displays, what
        // resolution, etc.
        int experimenterScreenIdx=0;
        GraphicsEnvironment ge = GraphicsEnvironment
        .getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        GraphicsDevice defGd=ge.getDefaultScreenDevice();
        if(defGd==null && gds.length>0){
        	// fallback should not happen
        	defGd=gds[0];
        }
        if(gds==null || gds.length==0){
            logger.severe("No display connected!");
        }
        for(int i=0;i<gds.length;i++){
    		GraphicsDevice gd=gds[i];
    		GraphicsConfiguration gc=gd.getDefaultConfiguration();
    		Rectangle gb=gc.getBounds();
            logger.info("Display "+i+": "+ gb.getWidth() + " x "+ gb.getHeight());
        }
        
        if(defGd!=null){
        	for(int i=0;i<gds.length;i++){
        		GraphicsDevice gd=gds[i];
        		if(gd.equals(defGd)){
        			experimenterScreenConfig = defGd.getDefaultConfiguration();
        			experimenterScreenIdx=i;
        			logger.info("Selected default display "+i+" as experimenter screen");
        		}
        	}
        }
        if (gds.length == 1) {
            // only one display connected; both the experimenter and the
            // speaker display share the same display
            speakerScreenConfig = experimenterScreenConfig;
            logger.info("Selected default display 0 as speaker screen");
        } else if (gds.length >= 2) {
            // at least two displays connected
        	// Fix Bug ID 0049
        	// On Mac OS X the first display is not necessarily the default display
        	// Choose the first display which is not the default
            
        	for(int i=0;i<gds.length;i++){
        		GraphicsDevice gd=gds[i];
        		if(speakerScreenConfig==null && ! gd.equals(defGd)){
        			speakerScreenConfig = gd.getDefaultConfiguration();
        			logger.info("Selected display "+i+" as speaker screen");
        		}
        	}
          
        } 
 
    }


    public void init(){
    	super.init();
        sessionManager.init();
    }




    public Action getActionByActionCommand(String actionCmd) {
	    // TODO use hash
		for (int i = 0; i < ActiveProjectManager.ACTIONS.length; i++) {
			if (ActiveProjectManager.ACTIONS[i].getValue(Action.ACTION_COMMAND_KEY)
					.equals(actionCmd)) {
				return ActiveProjectManager.ACTIONS[i];
			}
		}
		return null;
	}
	



	public boolean configure(ProjectConfiguration cfgProject)
			throws PluginLoadingException, AudioControllerException,
			DOMConverterException, IOException, InstantiationException,
			IllegalAccessException, ClassNotFoundException, DOMCodecException, WorkspaceException, URISyntaxException, RecscriptManagerException, SpeechRecorderException{
	    if(DEBUG)System.out.println("Configure project");
	   
	    super.commonConfig(cfgProject);
	    
		String promptFileName = null;
		
		PromptConfiguration pc = project.getPromptConfiguration();
		boolean recManualPlay=pc.getRecManualPlay();
		sessionManager.setRecManualPlay(recManualPlay);
		
		sessionManager.setDefaultShowSpeakerWindow(pc.getShowPromptWindow());
		
		RecordingConfiguration recCfg = project.getRecordingConfiguration();
//		labelFileExtension = recCfg.getLabelExtension();
//		useTempFile = recCfg.isUseRawTempFile();
		primaryRecordTarget=recCfg.getPrimaryRecordTarget();
		boolean overwrite = recCfg.getOverwrite();
		sessionManager.setOverwrite(overwrite);
		
		boolean overwriteWarning=recCfg.isOverwriteWarning();
		sessionManager.setOverwriteWarning(overwriteWarning);
		
		Format aFormat = recCfg.getFormat();
//		AudioFormat audioFormat = new AudioFormat((float) aFormat
//				.getSampleRate(), aFormat.getSampleSizeInBits(), aFormat
//				.getChannels(), true, aFormat.getBigEndian());
		AudioFormat audioFormat=aFormat.toAudioFormat();
		audioFileFormat = new AudioFileFormat(AudioFileFormat.Type.WAVE,
				audioFormat, AudioSystem.NOT_SPECIFIED);
		// numLines = recCfg.getNumLines();
		// multi-line feature not supported yet !
		
		
		boolean forcePostRecPhase = recCfg.isForcePostRecDelayPhase();
		sessionManager.setForcePostRecPhase(forcePostRecPhase);
		
		sessionManager.setResetPeakOnRecording(recCfg.getResetPeakOnRecording());
		sessionManager.setProgressToNextUnrecorded(recCfg.getProgressToNextUnrecorded());
		
		Section.Mode defaultSectionMode=Section.Mode.getByValue(project.getRecordingConfiguration().getMode());
		sessionManager.setDefaultSectionMode(defaultSectionMode);
		
		project
        .getPromptConfiguration().getShowPromptWindow();
		
		promptFileName = pc.getPromptsUrl();

		// set instance variables to the values given as arguments
		if (promptFileName != null && !promptFileName.equals("")) {
		    
			promptFile = URLContext.getContextURL(projectContext,
					promptFileName);
		} else {
			JFileChooser chooser = new JFileChooser();
			chooser.setDialogTitle(uiString.getString("SelectPromptFile"));
			chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
			if(lastPromptSelectionDir!=null){
				chooser.setCurrentDirectory(lastPromptSelectionDir);
			}
			int returnVal = chooser.showOpenDialog(null);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				File selectedFile=chooser.getSelectedFile();
				lastPromptSelectionDir=selectedFile.getParentFile();
				promptFile = new URL("file:"
						+ selectedFile.getAbsolutePath());
				
			} else {
//				System.exit(0);
				return true;
			}
		}
		
		Class<? extends StartStopSignal> startStopSignalClass=null;
		String startStopSignalClassname=null;
		
		// project setting has highest priority
		ipsk.apps.speechrecorder.config.StartStopSignal startStopSConfig=pc.getStartStopSignal();
		if(startStopSConfig!=null){
		   String startStopSClassNameAttr=startStopSConfig.getClassname();
		   if(startStopSClassNameAttr!=null){
		       startStopSignalClassname=startStopSClassNameAttr;
		   }
		}
		// next priority property setting
		if(startStopSignalClassname==null){
		 String pluginInterfaceClassName=StartStopSignal.class.getName();
	     startStopSignalClassname=System.getProperty(pluginInterfaceClassName);
		}
		// use application preference
        if(startStopSignalClassname==null){
          try{
              Class.forName(PREFERRED_START_STOP_SIGNAL_PLUGIN);
              startStopSignalClassname=PREFERRED_START_STOP_SIGNAL_PLUGIN;
          }catch(ClassNotFoundException cnfe){
              // OK preferred not available
          }
        }
		// finally use the first one in list
		if(startStopSignalClassname==null){
	      ServicesInspector<StartStopSignal> startStopSignalPluginManager=new ServicesInspector<StartStopSignal>(StartStopSignal.class);
	      List<String> startStopSignalClassnames=startStopSignalPluginManager.getServiceImplementorClassnames();
	      if(startStopSignalClassnames!=null && startStopSignalClassnames.size()>0){
	          startStopSignalClassname=startStopSignalClassnames.get(0);
	      }
		}
		
		if(startStopSignalClassname!=null){
		    // we have a class name
		    try{
		        startStopSignalClass=Class.forName(startStopSignalClassname).asSubclass(StartStopSignal.class);
		    }catch(ClassNotFoundException cnfe){
		        speechRecorderUI.displayError("Start-Stop-Signal plugin error","Could not load start stop signal plugin: "+cnfe.getMessage()+"\nUsing default signal: simple traffic light.");
		    }
		}

		if(startStopSignalClass==null){
		    // fallback default is simple traffic light
		    startStopSignalClass=SimpleTrafficLight.class;
		}
		
		ItemcodeGeneratorConfiguration itemcodeGenCfg=pc.getItemcodeGeneratorConfiguration();
		// we need a copy of the configuration 
		// the script editor may change the configuration, but not for the project scope
		ipsk.apps.speechrecorder.script.ItemcodeGeneratorConfiguration itemcodeGenCfgSessionCopy=((ipsk.apps.speechrecorder.script.ItemcodeGeneratorConfiguration)itemcodeGenCfg).cloneTyped();
		itemcodeGenerator.setConfig(itemcodeGenCfgSessionCopy);
	   
		// Speaker currSpeaker=speakerManager.getSpeaker();
		String newSpeakerFilename = project.getSpeakers().getSpeakersUrl();
		if (speakerFileName == null
				|| !speakerFileName.equals(newSpeakerFilename)) {
			// speakers URL has changed
			speakerFileName = project.getSpeakers().getSpeakersUrl();

			if (speakerFileName != null && !speakerFileName.equals("")) {
				speakerURL = URLContext.getContextURL(projectContext,
						speakerFileName);
			} else {
				JFileChooser chooser = new JFileChooser();
				chooser.setDialogTitle(uiString.getString("SelectSpeakerFile"));
				chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
				int returnVal = chooser.showOpenDialog(null);
				if (returnVal == JFileChooser.APPROVE_OPTION) {
					speakerURL = new URL("file:"
							+ chooser.getSelectedFile().getAbsolutePath());
				} else {
					return true;
				}
			}
			
			// storageManager.setSpeakerCode(speakerManager.getSpeaker().getCode());
			// currSpeaker=null;
		}
		// Speaker database is closed when project is closed
		// therefore we always have to (re)load speaker db
		speakerManager.loadURL(speakerURL);
		
		
		
		if (!recBaseURL.getProtocol().equalsIgnoreCase("file")){
			// enable upload cache (and "webrecording"), if destination is
			// remote
			useUploadCache = true;
		}
		sessionManager.setUseUploadCache(useUploadCache);
		speechRecorderUI.setFileSystemWorkspaceEnabled(!useUploadCache);
		
		
		
		
		storageManager.setUseAsCache(useUploadCache);
		if(useUploadCache){
			// Default StorageManager NaturalNumberFormat supports only 4 numbers !!
			storageManager.setSessionIDFormat(new DecimalFormat("0"));
		}
		storageManager.setNumLines(numLines);
		
		speakerManager.setStorageManager(storageManager);
//		speakerManager.setSessionPersonIDFormat(storageManager.getSpeakerIDFormat());
		// create logger

		LoggingConfiguration logCfg = project.getLoggingConfiguration();
		ipsk.apps.speechrecorder.config.Logger[] loggers = logCfg.getLogger();
		Logger rootLogger = Logger.getLogger("");
		Handler[] defHandlers = rootLogger.getHandlers();
		File logFile = null;
		File timeLogFile = null;
		// remove all default handlers set by JVM
		for (int i = 0; i < defHandlers.length; i++) {
			rootLogger.removeHandler(defHandlers[i]);
		}
		ipsk.apps.speechrecorder.config.Handler[] handlers = logCfg
				.getHandler();

		for (int i = 0; i < handlers.length; i++) {
			Formatter formatterCfg = handlers[i].getFormatter();
			java.util.logging.Formatter formatter = null;
			if (formatterCfg != null) {
				String formatterClassName = formatterCfg
						.getClassName();
				if (formatterClassName != null) {
					Class<?> fClass = Class.forName(formatterClassName);
					Object formatterObj=fClass.newInstance();
					if(formatterObj instanceof java.util.logging.Formatter){
					    formatter=(java.util.logging.Formatter)formatterObj;
					}
				}
			}
			if (handlers[i].getName().equals(LOG_HANDLER_NAME)) {
				if (logFile == null) {
					try {

						if (useUploadCache) {
							// for webrecording we log to temporary files which
							// will be uploaded at the and of the session
							logFile = File.createTempFile(TEMP_FILE_PREFIX,
									LOG_FILE_SUFFIX);
							logFile.deleteOnExit();
						} else {
							// for workspace projects we log to files in the
							// workspace instead
							logFile = new File(projectContext.toURI().getPath()
									+ File.separator + project.getName()
									+ LOG_FILE_SUFFIX);
						}
						logFileHandler = new FileHandler(logFile, true);

						if (formatter != null)
							logFileHandler.setFormatter(formatter);
					} catch (IOException e) {
						logger
								.severe("Could not associate a file with the current logger: "
										+ e);
					} catch (SecurityException e) {
						logger.severe("Could not write to a log file: " + e);
					}
				}
			} else if (handlers[i].getName().equals(
					TIMELOG_HANDLER_NAME)) {
				if (timeLogFile == null) {
					try {

						if (useUploadCache) {
							// for webrecording we log to temporary files which
							// will be uploaded at the and of the session
							timeLogFile = File.createTempFile(TEMP_FILE_PREFIX,
									TIME_LOG_FILE_SUFFIX);
							timeLogFile.deleteOnExit();
						} else {
							// for workspace projects we log to files in the
							// workspace instead
							timeLogFile = new File(projectContext.toURI().getPath()
									+ File.separator + project.getName()
									+ TIME_LOG_FILE_SUFFIX);
						}
						timeLogFileHandler = new FileHandler(timeLogFile, true);

						if (formatter != null)
							timeLogFileHandler.setFormatter(formatter);
					} catch (IOException e) {
						logger
								.severe("Could not associate a file with the current logger: "
										+ e);
					} catch (SecurityException e) {
						logger.severe("Could not write to a log file: " + e);
					}
				}
			} else {

				JOptionPane.showMessageDialog(speechRecorderUI,
						"Cannot associate log handler "
								+ handlers[i].getName()
								+ " !\n Ignoring.", "Configuration error",
						JOptionPane.ERROR_MESSAGE);
			}

		}

		for (int logI = 0; logI < loggers.length; logI++) {
			ipsk.apps.speechrecorder.config.Logger l = loggers[logI];

			java.util.logging.Level level = java.util.logging.Level.parse(l.getLevel());
			String logName = l.getName();
			String handlerName = l.getHandlerName();
			// ipsk.apps.speechrecorder.config.Handler h=l.getHandler();
			// Formatter formatter=h.getFormatter();

			java.util.logging.Logger logger = Logger.getLogger(logName);
			logger.setLevel(level);
			// for(int i=0;i<handlers.length;i++){
			if (handlerName.equals(LOG_HANDLER_NAME)) {
				logger.addHandler(logFileHandler);
			} else if (handlerName.equals(TIMELOG_HANDLER_NAME)) {
				logger.addHandler(timeLogFileHandler);
			}

		}
		
		logger.info("Created logfiles.");
		logger.info("Operating System: " + System.getProperty("os.name") + " "
				+ System.getProperty("os.arch") + " "
				+ System.getProperty("os.version"));
		logger.info("JRE: " + System.getProperty("java.version") + " "
				+ System.getProperty("java.vendor"));
		logger.info("Speechrecorder version: " + SpeechRecorder.VERSION);
		logger.info("Loglevel: " + logger.getLevel());
		
		if (useUploadCache) {
			setWaitForCompleteUpload(project.getCacheConfiguration()
					.getWaitForCompleteUpload());
			String uploadCacheClassname = project.getCacheConfiguration()
					.getUploadCacheClassname();
			try {

				uploadCache = (UploadCache) Class.forName(uploadCacheClassname)
						.newInstance();
			} catch (Exception e) {
				throw (new PluginLoadingException(uploadCacheClassname, e));
			}
			// uploadCache.setHoldSize(CACHE_HOLD_SIZE); //100 MB
			// POST is default now
			// uploadCache.setRequestMethod("POST");
			uploadCache.setOverwrite(project.getRecordingConfiguration().getOverwrite());
			int transferRateLimit=project.getCacheConfiguration().getTransferRateLimit();
			if(transferRateLimit!=UploadCache.UNLIMITED){
				if(uploadCache.isTransferLimitSupported()){
					uploadCache.setTransferLimit(transferRateLimit);
					logger.info("Upload cache set transfer rate limit: "+transferRateLimit);
				}else{
					logger.warning("Upload cache does not support transfer rate limiting !");
				}
			}
			if(uploadDuringSessionRecording){
			    uploadCache.start();
			    logger.info("Upload cache: " + uploadCache.getClass().getName()+ "started.");
			}
		}

		storageManager.setUploadCache(uploadCache);
		storageManager.setUseAsCache(useUploadCache);
		
		storageManager.setOverwrite(overwrite);

		// set the audio compression to use, e.g. FLAC
		String audioCompression = project.getCacheConfiguration()
				.getAudioStorageType();
		if (audioCompression != null && !audioCompression.equals("")) {
			logger.fine("Requested audio upload type: " + audioCompression);
			AudioFileFormat.Type[] types = AudioSystem.getAudioFileTypes();
			AudioFileFormat.Type type = null;
			for (int i = 0; i < types.length; i++) {
				if (types[i].toString().equalsIgnoreCase(audioCompression))
					type = types[i];
			}
			if (type != null) {
				storageManager.setUploadType(type);
				logger.fine("Audio upload type " + audioCompression + " set.");
			} else {
				logger.warning("Requested audio type \"" + audioCompression
						+ "\" not available.");
			}
		}
		
		// We do not use a session ID
		storageManager.setCreateSessionDir(false);
		storageManager.setUseScriptID(false);
		try {
			storageManager.open(true);
		} catch (StorageManagerException e) {
			throw new SpeechRecorderException(e.getMessage(), e);
		}
		
		// TODO may take some time, should maybe done in a worker or background task
//		updateSessionsSet();
//		
		
		
		if (projectContext != null) {
			recScriptManager.setContext(projectContext);
			recScriptManager.setSystemIdBase(projectContext.toExternalForm());
			speechRecorderUI.setProjectContext(projectContext);
		}
	  
		recScriptManager.setDefaultSpeakerDisplay(pc.getShowPromptWindow());
		recScriptManager.setDefaultMode(Section.Mode.getByValue(recCfg.getMode()));
		recScriptManager.setDefaultPreDelay(recCfg.getPreRecDelay());
		recScriptManager.setDefaultPostDelay(recCfg.getPostRecDelay());
		recScriptManager.setDefaultAutomaticPromptPlay(pc.getAutomaticPromptPlay());
		
		sessionManager.setStorageManager(storageManager);
		
		// auto annotation
		
		 // build auto annotator descriptor list
        Set<AutoAnnotationServiceDescriptor> aasdSet=new HashSet<AutoAnnotationServiceDescriptor>();
	    Annotation annotationCfg=project.getAnnotation();
	    List<AutoAnnotationServiceDescriptor> aasds=autoAnnotatorPluginManager.getAutoAnnotatorServiceDescriptors();
	    
	    enabledAutoAnnotators = new ArrayList<AutoAnnotator>();
	    if(annotationCfg!=null){
	        AutoAnnotation autoAnnoCfg=annotationCfg.getAutoAnnotation();
	        ipsk.apps.speechrecorder.config.AutoAnnotator[] aaCfgs=autoAnnoCfg.getAutoAnnotators();
	        if(aaCfgs!=null){
	            for(ipsk.apps.speechrecorder.config.AutoAnnotator aaCfg:aaCfgs){
	                boolean en=aaCfg.isEnabled();
	                if(en){
	                    String aaClasNm=aaCfg.getClassname();
	                    //        			Class<?> aaClass=Class.forName(aaClasNm);
	                    for(AutoAnnotationServiceDescriptor aasd:aasds){
	                        String aaSdClNm=aasd.getServiceImplementationClassname();
	                        if(aaClasNm.equals(aaSdClNm)){
	                            aasdSet.add(aasd);
	                            break;
	                        }
	                    }
	                    
	                }
	            }
	        }
	        List<AutoAnnotationServiceDescriptor> aasdResolvedlist=autoAnnotatorPluginManager.resolve(aasdSet);
	        for(AutoAnnotationServiceDescriptor aasd:aasdResolvedlist){
	            String aaClsNm=aasd.getServiceImplementationClassname();
	            Class<?> aaClass=Class.forName(aaClsNm);
	            AutoAnnotator aa=(AutoAnnotator) aaClass.newInstance();
                enabledAutoAnnotators.add(aa);
	        }
	    }
	    
	    sessionManager.setEnabledAutoAnnotators(enabledAutoAnnotators);
        
        // configure annotation
        // instantiate an initial annotation schema 
            schema = new Schema();
//            LevelDefinition promptLd=new LevelDefinition();
//            promptLd.setType(LevelDefinition.ITEM);
//            promptLd.setName(PROMPT_LEVEL_DEF_NAME);
//            AttributeDefinition promptAd=new AttributeDefinition();
//            promptAd.setName(PROMPT_LEVEL_DEF_NAME);
            LevelDefinition promptDef=new LevelDefinition(PredefinedLevelDefinition.PRT);
            LevelDefinition templateDef=new LevelDefinition(PredefinedLevelDefinition.TPL);
            schema.addLevelDefinition(promptDef);
            schema.addLevelDefinition(templateDef);
            
            // check annotation persistors
            bundleAnnotationPersistorList.clear();
            AnnotationPersistence annoPersCfg=annotationCfg.getPersistence();
            List<BundleAnnotationPersistorConfig> perCfgList=annoPersCfg.getBundleAnnotationPersistors();
            
           
            for(BundleAnnotationPersistorConfig perCfg:perCfgList){
                if(perCfg.isEnabled()){
                    Class<?> c=Class.forName(perCfg.getClassname());
                    Object o=c.newInstance();
                    if(o instanceof BundleAnnotationPersistor){
                        BundleAnnotationPersistor bap=(BundleAnnotationPersistor)o;
                        bundleAnnotationPersistorList.add(bap);
                    }
                }
            }
            
            sessionManager.setBundleAnnotationPersistorList(bundleAnnotationPersistorList);
            
//        }
		
            // beep audio prompt file URL
            URL beepURL = null;
            PromptBeep promtBeepCfg=getConfiguration().getPromptConfiguration().getPromptBeep();
            String promptBeepUrlStr=promtBeepCfg.getBeepFileURL();
            if(promptBeepUrlStr!=null && ! "".equals(promptBeepUrlStr)){
            	try {
            		beepURL = URLContext.getContextURL(getProjectContext(),promptBeepUrlStr);
            	} catch (MalformedURLException e1) {
            		throw e1;
            	}
            }else{
            	beepURL=SampleManager.class.getResource("beep/beep_PCM_16bit_44100Hz.wav");
            }
            sessionManager.setBeepURL(beepURL);
            Double beepVolume = getConfiguration().getPromptConfiguration().getPromptBeep().getBeepGainRatio();
            sessionManager.setBeepVolume(beepVolume);
           

		// defaults
		audioEnabled = false;
		sessionManager.setAudioEnabled(audioEnabled);
		sessionManager.setSeamlessAutoRecording(false);
		
		try {
			openAudioController();
			
			audioEnabled = true;
			audioController.setOverwrite(overwrite);
			
			sessionManager.setAudioEnabled(audioEnabled);
			
			CaptureScope captureScope = recCfg.getCaptureScope();
			
			if(captureScope==null){
				// application default is still ITEM, but new projects are configured
				// with SESSION by default
				captureScope=CaptureScope.ITEM;
			}
			
			sessionManager.setCaptureScope(captureScope);
			
			// check seamless recoding capabilities
			
			
			if(recCfg.isSeamlessAutorecording() ){
			    // check if audio controller supports it
			    if(audioController.isFileTransitionRecordingSupported()){
			        // Only possible with recording directly to file. Recording to temporary file in seamless mode is not supported
			        if(!PrimaryRecordTarget.DIRECT.equals(primaryRecordTarget)){
			            speechRecorderUI.displayError("Audio configuration error",
		                        "Audio configuration error: Seamless recording is only posiible if primary recording target is direct file (DIRECT)");
			        }else{
			            // OK, set seamless recording mode
			            sessionManager.setSeamlessAutoRecording(true);
			        }
			    }else{ 
			        speechRecorderUI.displayError("Audio controller error",
	                    "Audio controller implementation class "+project.getAudioControllerClass()+" does not support recording file transition during capture.\nSeamless recording will be disabled !");
			    }
			}
		} catch (PluginLoadingException pe) {
			speechRecorderUI.displayError("Plugin laoading error",
					"Could not load audio controller plugin: " + pe
							+ "\naudio recording/playback will be disabled !");
		} catch (AudioControllerException ae) {
			speechRecorderUI.displayError("Audio controller error",
					"Could not open audio controller: " + ae
							+ "\naudio recording/playback will be disabled !");
		} catch (AudioManagerException ame) {
			speechRecorderUI.displayError("Audio manager error",
					"Could not open audio controller: " + ame
							+ "\naudio recording/playback will be disabled !");
		}


		try{
		    recScriptManager.load(promptFile);
		}catch(RecscriptManagerException rme){
		    Throwable cause=rme.getCause();
		    if(cause instanceof RecScriptSchemaVersionNewerException){
		        RecScriptSchemaVersionNewerException rne=(RecScriptSchemaVersionNewerException)cause;
		        Object[] options = { "Cancel", "Try to load script anyway" };
		        int res=JOptionPane.showOptionDialog(speechRecorderUI,
		                "Recording script schema has newer version than the one used in this version of Speechrecorder.\nIt is recommended to update SpeechRecorder to the newest version and retry.\n\nIf you load the script nevertheless, new features of the script might be ignored. If you edit the script, it will be downgraded.\n\nDo you want to try to load the script anyway?", 
		                "Force loading script",
		                JOptionPane.OK_CANCEL_OPTION,
		                JOptionPane.WARNING_MESSAGE,
		                null, options, options[0]);


//		        int res=JOptionPane.showConfirmDialog(speechRecorderUI,"Recording script schema has newer version as used in this version of Speechrecorder.\nIt is recommended to update SpeechRecorder to the newest version and retry. Do you want to try to load the script anyway?","", 
//		                , JOptionPane.WARNING_MESSAGE);
		        if(res==1){
		            recScriptManager.load(promptFile,true);
		        }else{
		           return true;
		        }
		    }else{
		        throw rme; 
		    }
		}

		try {
			rebuildDb();
			  // TODO may take some time, should maybe done in a worker or background task
	        updateItemCodesInUseSet();
		} catch (StorageManagerException e) {
			throw new SpeechRecorderException(e.getMessage(), e);
		}
		
		
        
		
		speechRecorderUI.configure();
		speechRecorderUI.setStartStopSignalClass(startStopSignalClass);
        speechRecorderUI.setInstructionNumbering(project.getPromptConfiguration().getInstructionNumbering());
        
        
        // TODO !!
//		if (project.getEditable()){
//			// is this necessary here ?
//            workspaceProjects=workspaceManager.scanWorkspace();
//            speechRecorderUI.setWorkspaceProjects(workspaceProjects);
//        }
		//workspaceManager.lock(project.getName());
        if(listener!=null){
            listener.update(new ProjectManagerProjectOpenedEvent(this, project.getName()));
        }
		sessionManager.init();
		return false;
	}


	
	
	
	private void openAudioController() throws PluginLoadingException,
			AudioControllerException, AudioManagerException {
        
		// set the audio controller implementation
		try {
			audioControllerClassName = project.getAudioControllerClass();
			audioController = (AudioController4) Class.forName(
					audioControllerClassName).newInstance();
		} catch (Exception e) {
			throw (new PluginLoadingException(audioControllerClassName, e));
		}
		AJSAudioSystem.setApplicationName(SpeechRecorder.APPLICATION_NAME);
		AJSAudioSystem.setFreeDesktopApplicationIconName(SpeechRecorder.FREEDESKTOP_APPLICATION_ICON_NAME);
		
		audioManager=new AudioManager(audioController);
		
		// extra player for beeps
		beepPlayer=new Player();
		
		// we are interested in reliable recordings
//		audioController
//				.setCaptureOptimizationMode(AudioController2.OPTIMIZE_FOR_RELIABILITY);
		audioController.setPreferredCaptureLineBufferSizeMilliSeconds(PREFERRED_LINE_BUFFER_SIZE_MILLIS);
		audioController.setPreferredPlaybackLineBufferSizeMilliSeconds(PREFERRED_LINE_BUFFER_SIZE_MILLIS);
		// Try to set max ASIO buffer size for IPSK JavaSound adapter
		// We do not need low latency
		audioController.setProperty("ASIO_USE_MAX_BUFFER_SIZE", "true");
		
		MixerName[] orgTargetMixerNames=project.getRecordingMixerName();
		MixerName[] targetMixerNames=ConfigHelper.getAJSConvertedMixerNames(audioController,orgTargetMixerNames);

		if (targetMixerNames != null && targetMixerNames.length > 0) {
			DeviceInfo matchedDeviceInfo=audioManager.findMatchingDeviceInfo(targetMixerNames, AJSAudioSystem.DeviceType.CAPTURE);
			
			if(matchedDeviceInfo==null){
				// we have one or more entries in the config list but no matching device found
				throw new AudioControllerException("No capture device matching configuration found!");
			}else{
				logger.info("Using capture mixer: "+matchedDeviceInfo);
				audioController.setCaptureDeviceByinfo(matchedDeviceInfo);
			}
		}else {
			logger.info("Using default capture mixer.");
		}
		
		MixerName[] orgSourceMixerNames=project.getPlaybackMixerName();
		MixerName[] sourceMixerNames=ConfigHelper.getAJSConvertedMixerNames(audioController,orgSourceMixerNames);

		if (sourceMixerNames != null && sourceMixerNames.length > 0) {
			DeviceInfo matchedDeviceInfo=audioManager.findMatchingDeviceInfo(sourceMixerNames, AJSAudioSystem.DeviceType.PLAYBACK);
			if(matchedDeviceInfo==null){
				// we have one or more entries in the config list but no matching device found
				throw new AudioControllerException("No playback device matching configuration found!");
			}else{
				//			    audioController.setPlaybackDeviceByName(sourceMixerName);
				audioController.setPlaybackDeviceByInfo(matchedDeviceInfo);
				logger.info("Using playback mixer: " + matchedDeviceInfo);

			}
		} else {
			logger.info("Using default playback mixer.");
		}
		
		
		RecordingConfiguration recCfg=project.getRecordingConfiguration();
		ChannelRouting captureChannelRouting=recCfg.getChannelAssignment();
		if(captureChannelRouting!=null){
			ipsk.io.ChannelRouting chRouting;
			int chOffset=captureChannelRouting.getChannelOffset();
			if(chOffset!=0){
				int recChs=recCfg.getFormat().getChannels();
				chRouting=new ipsk.io.ChannelRouting(true,chOffset,recChs);
			}else{
				int[] inChAssignment=captureChannelRouting.getAssign();
				Integer[] inChassignmentI=null;
				if(inChAssignment!=null){
					inChassignmentI=new Integer[inChAssignment.length];
					for(int i=0;i<inChAssignment.length;i++){
						inChassignmentI[i]=inChAssignment[i];
					}
				}
				Integer inChs=captureChannelRouting.getSrcChannelCount();
				chRouting=new ipsk.io.ChannelRouting(inChs, inChassignmentI);
			}
			audioController.setInputChannelRouting(chRouting);
		}
		
		// TODO check duplex max channels 
		

		MixerName[] promptPlayMixerNames=project.getPromptPlaybackMixerName();
		PromptConfiguration promptCfg=project.getPromptConfiguration();

		if (promptPlayMixerNames != null && promptPlayMixerNames.length > 0) {
			DeviceInfo matchedDeviceInfo=audioManager.findMatchingDeviceInfo(promptPlayMixerNames, AJSAudioSystem.DeviceType.PLAYBACK);
			if(matchedDeviceInfo==null){
				// we have one or more entries in the config list but no matching device found
				throw new AudioManagerException("No prompt playback device matching configuration found!");
			}else{
				List<MixerProviderServiceDescriptor> mpsdList=AJSAudioSystem.listMixerProviderDescriptors();
				for(MixerProviderServiceDescriptor mpsd:mpsdList){
					String mpsdClassName=mpsd.getImplementationClassname();
					String matcheddevProvClassname=matchedDeviceInfo.getDeviceProviderInfo().getImplementationClassname();
					if(mpsdClassName.equals(matcheddevProvClassname)){
						AJSDeviceInfo ajsDevInfo=new AJSDeviceInfo(mpsd,matchedDeviceInfo.getMixerInfo());
						//						AJSDevice ajsDevice=AJSAudioSystem.getDevice(ajsDevInfo);

						AJSDevice ajsDevice=AJSAudioSystem.getDevice(ajsDevInfo);
						//promptMixer=mm.getPlaybackMixerByName(sourceMixerName);
						promptMixer=ajsDevice.getMixer();
							speechRecorderUI.setPromptMixer(promptMixer);
						
						try {
							beepPlayer.setMixer(promptMixer);
						} catch (PlayerException e) {
							e.printStackTrace();
							throw new AudioManagerException("Could not set mixer for beep player!");
						}
						logger.info("Using prompt playback mixer: " + matchedDeviceInfo);
					}
				}
			} 
		}else {
			logger.info("Using default playback mixer.");
		}
		
		// set channel routing (only by channel offset) for prompt and beep  player
		int promptAudioChannelOffset=promptCfg.getAudioChannelOffset();
		speechRecorderUI.setPromptAudioChannelOffset(promptAudioChannelOffset);
		beepPlayer.setChannelOffset(promptAudioChannelOffset);

	
		// audioController.setNumLines(numLines);

		audioController.setRecordingAudioFileFormat(audioFileFormat);

		//		audioController.setPrimaryRecordTarget(useTempFile?PrimaryRecordTarget.TEMP_RAW_FILE:PrimaryRecordTarget.DIRECT);
		audioController.setPrimaryRecordTarget(primaryRecordTarget);
//		audioController.setOverwrite(overwrite);

		// audioController.configure();
		// audioController.open();

		
		sessionManager.setAudioController(audioController);
		sessionManager.setBeepPlayer(beepPlayer);

		
	}


	
	/**
	 * Sets a new configuration. Does not reconfigure the application.
	 * 
	 * @param newProject
	 */
	private void setConfiguration(ProjectConfiguration newProject) {
		project = newProject;
	}

	/**
	 * Returns the project configuration (bean).
	 * 
	 * @return the project configuration
	 */
	public ProjectConfiguration getConfiguration() {
		return project;
	}

	/**
	 * Returns a copy (new instance) of the project configuration (bean).
	 * 
	 * @return copy of project configuration
	 */
	public ProjectConfiguration getConfigurationCopy() throws DOMCodecException {
		return (ProjectConfiguration) domCodec.copy(project);
	}

	/**
	 * Returns the project configuration URL.
	 * 
	 * @return the URL where the configuration is stored
	 */
	public URL getProjectURL() {
		return projectURL;
	}

	/**
	 * Sets new project configuration URL.
	 * 
	 * @param url
	 *            the URL where the configuration is stored
	 */
	public void setProjectURL(URL url) {
		projectURL = url;
	}

//	/**
//	 * Copies a stream.
//	 * 
//	 * @param i
//	 *            the input
//	 * @param o
//	 *            the ouput
//	 * @throws IOException
//	 */
//	private void copyBufStream(InputStream i, OutputStream o)
//			throws IOException {
//		byte[] buf = new byte[2048];
//		int b;
//		while ((b = i.read(buf)) != -1) {
//			if (b > 0)
//				o.write(buf, 0, b);
//		}
//		o.close();
//		i.close();
//	}

	/**
	 * Copies a stream.
	 * 
	 * @param i
	 *            the input
	 * @param o
	 *            the ouput
	 * @throws IOException
	 */
	private void copyStream(InputStream i, OutputStream o) throws IOException {
		int b;
		while ((b = i.read()) != -1) {
			o.write(b);
		}
		o.close();
		i.close();
	}

    
    public File getProjectDir() throws MalformedURLException, URISyntaxException{
        ProjectConfiguration pc=getConfiguration();
        if(pc!=null){
            String dirStr=pc.getDirectory();
            URL projectDirURL = new URL(projectContext, dirStr);
            return new File(projectDirURL.toURI().getPath());
        }else{
            
            return null;
        }
            
        
       
    }
    
    
    public String defaultScriptUrlString(){
    	if(project!=null){
    		return project.getName()
				+ REC_SCRIPT_FILE_EXTENSION;
    	}
    	return null;
    }
    
    /**
     * Create a new project.
     * 
     * @param newProjectConfig
     *            the configuration for the new project
     */
    public void newProject(NewProjectConfiguration newProjectConfig) throws Exception {
        ProjectConfiguration newProject=newProjectConfig.getProjectConfiguration();
        newProject.setUuid(UUID.randomUUID());
        // application default is still ITEM, but new projects are configured
        // with SESSION by default
        newProject.getRecordingConfiguration().setCaptureScope(CaptureScope.SESSION);
        
        // prompt autoplay is not what most users want
        // Disable in Version 4
        newProject.getPromptConfiguration().setAutomaticPromptPlay(false);
        
//      projectContext = (new File(workspaceDir, newProject.getName()))
//              .toURI().toURL();
        File projDir=new File(workspaceDir, newProject.getName());
        URI projDirURI=projDir.toURI();
        // convert special chars, e.g. Umlaute
        String projURLStr=projDirURI.toASCIIString();
        // ( we could use ipsk.net.Utils )
        
        projectContext=new URL(projURLStr);
        URL projectDirURL = new URL(projectContext, newProject.getDirectory());
        File projectDir = new File(projectDirURL.toURI().getPath());
        String parent = projectDir.getParent();
        File workspaceRoot = new File(parent);

        if (!workspaceRoot.exists()) {
            int res = JOptionPane.showConfirmDialog(speechRecorderUI,
                    "Workspace directory " + workspaceRoot.getPath()
                            + " does not exist.\nCreate ?", "New Project",
                    JOptionPane.OK_CANCEL_OPTION);
            if (res == JOptionPane.OK_OPTION) {
                if (!workspaceRoot.mkdirs()) {
                    throw new Exception("Could not create directory "
                            + workspaceRoot.getPath());
                }
            }else{
                // Bug Fix ID0069
                throw new Exception("Could not create project without workspace directory.");
            }
        }

        if (projectDir.exists()) {
            // TODO this is not really an exception
            throw new Exception("Project (directory) already exists: "
                    + projectDir.getPath());
        }
        if (!projectDir.mkdirs()) {
            throw new Exception("Could not create directory "
                    + projectDir.getPath());
        }
        URI pdURI=projectDir.toURI();
        String projectDirURIstr=pdURI.toASCIIString();
        URL projectDirURLascii=new URL(projectDirURIstr);
        setProjectContext(projectDirURLascii);
        // Handler.setProjectDir(projectDir);
        String projectFilename = newProject.getName() + PROJECT_FILE_EXTENSION;
        String recScriptFileName = newProject.getName()
                + REC_SCRIPT_FILE_EXTENSION;
        String speakersFilename = newProject.getName() + SPEAKER_FILE_SUFFIX;
        File projectFile = new File(projectDir, projectFilename);
        File recScriptFile = new File(projectDir, recScriptFileName);
        File speakersFile = new File(projectDir, speakersFilename);

        // copy recording script DTD
        
        InputStream is = RecscriptHandler.class.getResourceAsStream(RecscriptHandler.REC_SCRIPT_DTD);
        FileOutputStream fos = new FileOutputStream(new File(projectDir,
                RecscriptHandler.REC_SCRIPT_DTD));
        copyStream(is, fos);
        
        if(newProjectConfig.isUseExampleScript()){
            // copy example recording script
            is = RecscriptHandler.class.getResourceAsStream(REC_SCRIPT_EXAMPLE);
            fos = new FileOutputStream(recScriptFile);
            copyStream(is, fos);

            // set item code generator to match example script itemcodes
            
            ItemcodeGeneratorConfiguration icCfg=newProject.getPromptConfiguration().getItemcodeGeneratorConfiguration();
            icCfg.setGeneratorName("Demo script itemcode generator");
            
            // demo script has itemcodes from demo_000 ...
            icCfg.setPrefix("demo_");
            icCfg.setFixedDecimalPlaces(3);

            //... to demo_063
            // each unit starts a new block of the items
            // So new items added by the user should start at demo_070
            icCfg.setCounterStart(70);
            
            icCfg.setActive(true);

        }else{
            Script newScript=new Script();
            newScript.setPropertyChangeSupportEnabled(true);
            recScriptManager.setScript(newScript);
           
        }
        // copy example speakers file
        // not necessary anymore
        //is = getClass().getResourceAsStream("ExampleSpeakers.txt");
//      fos = new FileOutputStream(speakersFile);
//      copyStream(is, fos);
        
        JAXB.marshal(new ArrayList<ipsk.db.speech.Speaker>(), speakersFile);

        // newProject.getPromptConfiguration().setPromptsUrl(recScriptFile.toURL().toExternalForm());
        // newProject.getPromptConfiguration().setPromptsUrl(
        // recScriptFile.toURL().toExternalForm());
        // newProject.getSpeakers().setSpeakersUrl(
        // speakersFile.toURL().toExternalForm());
        // newProject.getRecordingConfiguration().setUrl(
        // "file:" + projectDir + File.separator + "RECS");
        
        URI recScriptURI=recScriptFile.toURI();
        URI projectDirURI=projectDir.toURI();
        URI recScriptRelURI=projectDirURI.relativize(recScriptURI);
//      URL recScriptURL=recScriptRelURI.toURL();
        newProject.getPromptConfiguration().setPromptsUrl(recScriptRelURI.toString());
//      newProject.getPromptConfiguration().setPromptsUrl(
//              "file:" + recScriptFileNameURLEncoded);
        URI speakersFileURI=speakersFile.toURI();
        URI speakersFileRelURI=projectDirURI.relativize(speakersFileURI);
        newProject.getSpeakers().setSpeakersUrl(speakersFileRelURI.toString());
        
        // TODO
        newProject.getRecordingConfiguration().setUrl("RECS/");
        setConfiguration(newProject);
        setProjectURL(projectFile.toURI().toURL());

        // recScriptManager.initialize();
        String systemIdBase=projectContext.toExternalForm();
        recScriptManager.setSystemIdBase(systemIdBase);

        saveProject();
        if(!newProjectConfig.isUseExampleScript()){
         saveScript();
        }
        configure(newProject);
         

    }
	

	public File getWorkspaceDir() {
        return workspaceDir;
    }



    public void setWorkspaceDir(File workspaceDir) {
        this.workspaceDir = workspaceDir;
    }



    /**
	 * Save current project configuration.
	 * 
	 * @throws DOMCodecException
	 * @throws DOMConverterException
	 * @throws IOException
	 * @throws URISyntaxException 
	 */
	public void saveProject() throws DOMCodecException, DOMConverterException,
			IOException, URISyntaxException {
		// save project file
		String fPath=getProjectURL().toURI().getPath();
		File f = new File(fPath);
		
//		File backupF=new File(fPath+".bak");
//		f.renameTo(backupF);
		ProjectConfiguration pc=getConfiguration();
//		String pcVersion=pc.getVersion();
//		if(pcVersion==null || PROJECT_VERSION.equals(pcVersion)){
		
		// always set to the version which created the configuration
		pc.setVersion(PROJECT_VERSION);
//		}
		Document d = domCodec.createDocument(getConfiguration());
		// backup
		FileUtils.moveToBackup(f, ".bak");
		FileOutputStream fos=new FileOutputStream(f);
		OutputStreamWriter ow=new OutputStreamWriter(fos,Charset.forName("UTF-8"));
		domConverter.writeXML(d,ow);
		ow.close();
		setProjectConfigurationSaved(true);
	}

	/**
	 * Save project file.
	 * 
	 * @param file
	 *            save to this file
	 * @throws DOMCodecException
	 * @throws DOMConverterException
	 * @throws IOException
	 * @throws URISyntaxException 
	 */
	public void saveProject(File file) throws DOMCodecException,
			DOMConverterException, IOException, URISyntaxException {
		try {
			setProjectURL(file.toURI().toURL());
		} catch (MalformedURLException e) {
			// Should never happen
			e.printStackTrace();
		}
		saveProject();
	}

	/**
	 * Save current project configuration.
	 * 
	 * @throws DOMCodecException
	 * @throws DOMConverterException
	 * @throws IOException
	 * @throws ParserConfigurationException
	 * @throws URISyntaxException 
	 */
	public void saveScript() throws DOMCodecException, DOMConverterException,
			IOException, ParserConfigurationException, URISyntaxException {
        
        RecscriptHandler recScriptHandler = new RecscriptHandler();
        recScriptHandler.setValidating(true);
        
        Script script=recScriptManager.getScript();
        
        // Write DTD file to project workspace if it does not exist
        
        File dtdFile=new File(getProjectDir(),RecscriptHandler.REC_SCRIPT_DTD);
        if(!dtdFile.exists()){
            InputStream is = RecscriptHandler.class.getResourceAsStream(RecscriptHandler.REC_SCRIPT_DTD);
            FileOutputStream fos = new FileOutputStream(dtdFile);
            copyStream(is, fos);
        }
        
        // Validate
       
        StringWriter stringWriter=new StringWriter();
        recScriptHandler.writeXML(script,stringWriter);
        StringReader stringReader=new StringReader(stringWriter.toString());
        recScriptHandler.readScriptFromXML(stringReader, projectContext.toExternalForm());
        
       
        
        // Backup old file
        String promptFileName = project.getPromptConfiguration().getPromptsUrl();

        // set instance variables to the values given as arguments
        if (promptFileName != null && !promptFileName.equals("")) {
        	URL promptFile = URLContext.getContextURL(projectContext,
        			promptFileName);
        	String protocol=promptFile.getProtocol();
        	if("file".equalsIgnoreCase(protocol)){
        		String fPath=promptFile.toURI().getPath();
        		File f = new File(fPath);
        		//        	 File backupFile=new File(promptFile.toURI().getPath()+".bak");
        		//        	 f.renameTo(backupFile);
        		FileUtils.moveToBackup(f, ".bak");
        		// Finally write the script file
        		recScriptHandler = new RecscriptHandler();
        		recScriptHandler.setValidating(true);
        		recScriptHandler.writeXML(script,
        				new OutputStreamWriter(new FileOutputStream(f),Charset.forName("UTF-8")));
        		recScriptManager.setScriptSaved(true);

        	}else{
        		speechRecorderUI.displayError("Save script error", "Cannot save script to URL: "+promptFile+", protocol "+protocol+ "not supported.");
        	}
        }else{
        	speechRecorderUI.displayError("Save script error", "Cannot save script to empty URL!");
        }
	}

	/**
	 * Save speaker database file.
	 * 
	 * @throws IOException
	 * @throws URISyntaxException 
	 */
	public void saveSpeakerDatabase() throws IOException, URISyntaxException {
		File f = new File(speakerURL.toURI().getPath());
		// Backup old file
		
		FileUtils.moveToBackup(f, ".bak");
		speakerManager.getDatabaseLoader().writeDatabaseFile(f);
		// TODO the databaseloader should set the state
		speakerManager.setDatabaseSaved(true);
	}

	/**
	 * Save project configuration, speaker database and script file.
	 * 
	 * @throws DOMCodecException
	 * @throws DOMConverterException
	 * @throws IOException
	 * @throws ParserConfigurationException 
	 * @throws URISyntaxException 
	 */
	public void saveAll() throws DOMCodecException, DOMConverterException,
			IOException, ParserConfigurationException, URISyntaxException {
		saveProject();
		saveSpeakerDatabase();
        saveScript();
	}

	/**
	 * Open a project.
	 * 
	 * @param projectUrl
	 *            must contain the project configuration
	 * @throws ClassNotFoundException
	 * @throws DOMCodecException
	 * @throws DOMConverterException
	 * @throws PluginLoadingException
	 * @throws AudioControllerException
	 * @throws IOException
	 * @throws SAXException
	 * @throws ParserConfigurationException
	 * @throws IllegalAccessException
	 * @throws InstantiationException
	 * @throws WorkspaceException 
	 * @throws URISyntaxException 
	 * @throws RecscriptManagerException 
	 * @throws SpeechRecorderException 
	 */
	public boolean configureProject(URL projectUrl) throws ClassNotFoundException,
			DOMCodecException, DOMConverterException, StorageManagerException,
			PluginLoadingException, AudioControllerException,
			ParserConfigurationException, SAXException, IOException,
			InstantiationException, IllegalAccessException, WorkspaceException, URISyntaxException, RecscriptManagerException, SpeechRecorderException{
		
//		Document d = domConverter.readXML(projectUrl.openStream());
		URLConnection prUrlConn=projectUrl.openConnection();
		prUrlConn.setUseCaches(false);
		InputStream prInStream=prUrlConn.getInputStream();
		Document d = domConverter.readXML(prInStream);
		ProjectConfiguration p = (ProjectConfiguration) domCodec
				.readDocument(d);
		setProjectURL(projectUrl);
		ConfigHelper.applyLegacyToStrictConversions(p);
		boolean canceled=configure(p);
		
		setProjectConfigurationSaved(true);
		return canceled;
	}



	
	
	public boolean isProjectEditable(){
        ProjectConfiguration pc=getConfiguration();
        if(pc==null) return false;
        return pc.getEditable();
    }
    public void setEditingEnabled(boolean b) {  
//      Updates enabled/disabled status of project or speaker setting menu items
       boolean projectEditable=isProjectEditable();
       boolean editingEnabled=b;
       editScriptAction.setEnabled(projectEditable && editingEnabled);
       importScriptAction.setEnabled(projectEditable && editingEnabled);
       exportScriptAction.setEnabled(projectEditable && editingEnabled);
       speechRecorderUI.setEditingEnabled(b);
   }
    

    


//	/**
//	 * implements the RecObserver interface.
//	 * 
//	 * @param status
//	 *            the new status
//	 */
//	public void update(int status) {
//		if (status == RecStatus.INIT) {
//			
//			// speechRecorderUI.setEnableEditing(true);
//		} else if (status == RecStatus.CLOSE) {
//			
//		} else {
//			String promptItemCode = null;
//			ipsk.db.speech.PromptItem promptItem = recScriptManager
//					.getCurrentPromptItem();
//			
//			if (status == RecStatus.IDLE) {
//				
//			} else if (status == RecStatus.PRERECWAITING) {
//				// Moved to own method
//			} else if (status == RecStatus.RECORDING) {
////				 Moved to own method// Moved to own method
//			} else if (status == RecStatus.POSTRECWAITING) {
////				 Moved to own method
//			} else if (status == RecStatus.PLAY) {
//				
//			}
//		}
//	}




	
	public boolean saveAllProjectDataInteractive(){
		
		if (!isProjectConfigurationSaved()) {
			int option = JOptionPane.showConfirmDialog(speechRecorderUI,
					"The project has been modified.\nDo you want to save ?",
					"Confirm message", JOptionPane.YES_NO_CANCEL_OPTION,
					JOptionPane.INFORMATION_MESSAGE);
			if (option == JOptionPane.YES_OPTION) {
				try {
					saveProject();
				} catch (Exception e) {
					speechRecorderUI.displayError("Save error", e
							.getLocalizedMessage());
                    return false;
				}
			} else if (option == JOptionPane.CANCEL_OPTION) {
				return false;
			}
		}
		if (!speakerManager.isDatabaseSaved()) {
			int option = JOptionPane
					.showConfirmDialog(
							speechRecorderUI,
							"The speaker database has been modified.\nDo you want to save ?",
							"Confirm message",
							JOptionPane.YES_NO_CANCEL_OPTION,
							JOptionPane.INFORMATION_MESSAGE);
			if (option == JOptionPane.YES_OPTION) {
				try {
					saveSpeakerDatabase();
				} catch (Exception e) {
					speechRecorderUI.displayError("Save error", e
							.getLocalizedMessage());
                    return false;
				}
			} else if (option == JOptionPane.CANCEL_OPTION) {
				return false;
			}
		}
		if (!recScriptManager.isScriptSaved()) {
			int option = JOptionPane
					.showConfirmDialog(
							speechRecorderUI,
							"The recording script has been modified.\nDo you want to save ?",
							"Confirm message",
							JOptionPane.YES_NO_CANCEL_OPTION,
							JOptionPane.INFORMATION_MESSAGE);
			if (option == JOptionPane.YES_OPTION) {
				try {
					saveScript();
				} catch (Exception e) {
					speechRecorderUI.displayError("Save error", e
							.getLocalizedMessage());
                    return false;
				}
			} else if (option == JOptionPane.CANCEL_OPTION) {
				return false;
			}
		}
		
		return true;
	}
	


	/**
	 * Shutdown the application. If an uploading cache is used this method waits
	 * for complete upload.
	 */
	public void shutdown() {
	    speechRecorderUI.setRecMonitorsStatus(StartStopSignal.State.OFF);
	    // TODO
	    //recStat.setStatus(RecStatus.TERMINATE);
	    speechRecorderUI.setEnableOpenOrNewProject(false);
	    Runnable doShutdown = new Runnable() {
	        // Runnable is likely to be thread safe, it does not call Swing methods
	        public void run() {
	            if (uploadCache != null) {

	                if (!waitForCompleteUpload) {
	                    // interrupt uploads
	                    uploadCache.stop();
	                    try {
	                        storageManager.close(false);
	                    } catch (StorageManagerException e1) {
	                        // TODO Auto-generated catch block
	                        e1.printStackTrace();
	                    }

	                    // remove pending uploads
	                    uploadCache.clear();
	                    // uploadCache.start();

	                }

	                // restart the upload engine to upload log files now 
	                uploadCache.start();

	                if (logFileHandler != null) {
	                    // TODO the upload of files after this point is not in the log file anymore

	                    // remove handler and close
	                    logger.removeHandler(logFileHandler);
	                    logFileHandler.close();

	                    // upload
	                    File logFile = logFileHandler.getFile();
	                    URL logFileURL;
	                    try {

	                        logFileURL = storageManager.getLogFile();
	                        UploadFile logUpload = new UploadFile(logFile,logFileURL);
	                        uploadCache.upload(new Upload[] { logUpload });
	                    } catch (UploadException e) {
	                        e.printStackTrace();
	                        // proceed with shutdown
	                        // log file may be lost
	                    } catch (StorageManagerException e) {
	                        e.printStackTrace();
	                        // proceed with shutdown
	                        // log file may be lost
	                    }
	                }
	                if (timeLogFileHandler != null) {
	                    // same for time log file
	                    timeLogger.removeHandler(timeLogFileHandler);
	                    timeLogFileHandler.close();
	                    File timeLogFile = timeLogFileHandler.getFile();

	                    try {
	                        UploadFile timelogUpload = new UploadFile(timeLogFile,
	                                storageManager.getTimeLogFile());
	                        uploadCache.upload(new Upload[] { timelogUpload });
	                    } catch (UploadException e) {
	                        e.printStackTrace();
	                        // proceed with shutdown
	                        // log file may be lost
	                    } catch (StorageManagerException e) {
	                        e.printStackTrace();
	                        // proceed with shutdown
	                        // log file may be lost

	                    }
	                }

	                // wait for upload cache finish
	                while (!uploadCache.isIdle()) {
	                    try {
	                        Thread.sleep(SHUTDOWN_RETRY_DELAY);
	                    } catch (InterruptedException e) {
	                    }
	                }

	                // close upload engine and storage cache
	                uploadCache.close();
	                try {
	                    storageManager.close(true);
	                } catch (StorageManagerException e) {
	                    // TODO Auto-generated catch block
	                    e.printStackTrace();
	                }
	            }
	            readyForShutdown();
	        }

            
	    };
	    Thread shutdownThread = new Thread(doShutdown);
	    
	    // shutdown thread is not AWT event thread !!
	    shutdownThread.start();
	}
	
	private void readyForShutdown() {
	    // shutdown thread is not AWT event thread !!
	    if(listener!=null){
	        listener.update(new ProjectManagerProjectReadyForShutdownEvent(this));
	    }else{
	        System.exit(1);
	    }
    }
	

	/**
	 * Start a recording session. The application must be configured,
	 * initialized and a speaker must be chosen to start a session.
	 * @throws AudioControllerException 
	 * @throws ProjectManagerException 
	 */
	public void start() throws AudioControllerException, ProjectManagerException {
	    if(DEBUG)System.out.println("Start session.");
	   
		ipsk.db.speech.Speaker spk = speakerManager.getSpeaker();

		if (spk == null)
			return;
		
		// Session ID and speaker ID are the same in this version
		int sessionId=speakerManager.getSpeaker().getPersonId();
		if(lastSessionId!=null && lastSessionId!=sessionId){
			recScriptManager.shuffleItems();
		}
		lastSessionId=sessionId;
		
		sessionManager.setScript(recScriptManager.getScript());
		sessionManager.open();
		String speakerCode=speakerManager.getSpeaker().getCode();
		sessionManager.start(sessionId,speakerCode);
		
		
		
	}
	
	


	/**
	 * returns the current RecScriptManager to allow access to the script.
	 * 
	 * @return RecScriptManager
	 */
	public RecScriptManager getRecScriptManager() {
		return recScriptManager;
	}

	/**
	 * returns the file name of the current recording script
	 * 
	 * @return String recording script file name
	 */
	public String getRecScriptName() {
		if (promptFile == null)
			return null;
		return promptFile.toExternalForm();
	}

	/**
	 * getRecDirName() returns the name of the recording directory
	 * 
	 * @return String recording directory name
	 */
	public String getRecDirName() {
		if (recBaseURL == null)
			return null;
		return recBaseURL.toExternalForm();
	}

	/**
	 * returns the speaker selected from the database
	 * 
	 * @return Speaker current speaker
	 */
	public ipsk.apps.speechrecorder.db.Speaker getSpeaker() {
		return speakerManager.getSpeaker();
	}



	/**
	 * Indicates the use of a the upload cache in web mode.
	 * 
	 * @return true if an upload cache is used.
	 */
	public boolean isUsingUploadCache() {
		return useUploadCache;
	}

	/**
	 * Returns the upload cache.
	 * 
	 * @return the upload cache or null if not used
	 */
	public UploadCache getUploadCache() {
		return uploadCache;
	}

	



	/**
	 * Returns the UI object.
	 * 
	 * @return UI object
	 */
	public SpeechRecorderUI getSpeechRecorderUI() {
		return speechRecorderUI;
	}



	/**
	 * Returns the audio controller.
	 * 
	 * @return the audio controller
	 */
	public AudioController4 getAudioController() {
		return audioController;

	}

	/**
	 * Returns whether the project configuration is saved.
	 * 
	 * @return true if the project configuration is saved
	 */
	public boolean isProjectConfigurationSaved() {
		return projectConfigurationSaved;
	}

	/**
	 * Set true if the project configuration is saved.
	 * 
	 * @param saved
	 *            true if the configuration is saved
	 */
	public void setProjectConfigurationSaved(boolean saved) {
		projectConfigurationSaved = saved;
		speechRecorderUI.setProjectConfigurationSaved(saved);
		speechRecorderUI.updateSaveEnable();
	}



	

	/**
	 * Gets the speaker manager.
	 * 
	 * @return the speaker manager
	 */
	public SpeakerManager getSpeakerManager() {
		return speakerManager;
	}

	


	/**
	 * @return Returns the waitForCompleteUpload.
	 */
	public boolean isWaitForCompleteUpload() {
		return waitForCompleteUpload;
	}

	/**
	 * @param waitForCompleteUpload
	 *            The waitForCompleteUpload to set.
	 */
	public void setWaitForCompleteUpload(boolean waitForCompleteUpload) {
		this.waitForCompleteUpload = waitForCompleteUpload;
	}

	/**
	 * @param context the project context (directory) URL
	 */
	public void setProjectContext(URL context) {
		super.setProjectContext(context);
		if(speechRecorderUI!=null){
		    speechRecorderUI.setProjectContext(this.projectContext);
		}
	}


    /**
	 * @return Returns the audioFileFormat.
	 */
	public AudioFileFormat getAudioFileFormat() {
		return audioFileFormat;
	}

	/**
	 * @param audioFileFormat
	 *            The audioFileFormat to set.
	 */
	public void setAudioFileFormat(AudioFileFormat audioFileFormat) {
		this.audioFileFormat = audioFileFormat;
	}


	public void importResource(File f,String relpath) throws IOException, URISyntaxException{
	  URL projResURL = null;
      projResURL = URLContext.getContextURL(getProjectContext(), relpath);
      String projResPath=projResURL.toURI().getPath();
      File proJResFile=new File(projResPath);
      StreamCopy.copy(f, proJResFile);
      
	}
	

	
	

	

	
	public void resetItemcodeGenerator(){
	    if(itemcodeGenerator!=null){
	    ObservableList<String> genItemcodeList=itemcodeGenerator.getItemcodesList();
	    if(genItemcodeList==null){
	        genItemcodeList=new ObservableArrayList<String>();
	        itemcodeGenerator.setItemcodesList(genItemcodeList);
	    }else{
	        genItemcodeList.clear();
	    }
	    Script s=recScriptManager.getScript();
	     if(s!=null){
	         List<String> itemcodesOfScript=s.itemCodesList();
	         genItemcodeList.addAll(itemcodesOfScript);
	     }
	    }
	}

	public boolean isScriptSaved() {
		return recScriptManager.isScriptSaved();
	}

	public void setScriptSaved(boolean scriptSaved){
	    recScriptManager.setScriptSaved(scriptSaved);
	}

	public void update(RecscriptManagerEvent e){
	    if(e instanceof RecScriptStoreStatusChanged){
	        speechRecorderUI.updateSaveEnable();
	    }
	}
	



    public ItemcodeGenerator getItemcodeGenerator() {
        return itemcodeGenerator;
    }

	/**
	 * @return
	 * @throws IOException 
	 */
	public List<AutoAnnotationServiceDescriptor> getAutoAnnotatorServiceDescriptors() throws IOException {
		return autoAnnotatorPluginManager.getAutoAnnotatorServiceDescriptors();
	}

	

   
    public List<AudioClip> getSessionClipList(){
        Script scr=recScriptManager.getScript();
        if(scr==null){
            return(null);
        }
        List<AudioClip> audioClipList=new ArrayList<AudioClip>();
        List<String> itemcodes=scr.itemCodesList();
        try {
            for(String itemCode:itemcodes){
                File af=storageManager.recentRecordingFile(itemCode);
                if (af!=null && af.exists()){
                    FileAudioSource fas=new FileAudioSource(af);
                    AudioClip ac=new AudioClip(fas);
                    audioClipList.add(ac);

                }
            }
        } catch (StorageManagerException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return audioClipList;
    }

 
    /**
     * @return
     */
    public List<BundleAnnotationPersistorServiceDescriptor> getBundleAnnotationPersistorServiceDescriptors() {
        return availableBundleAnnotationServiceDescriptors;
    }
 
//    /**
//     * Updates the set of already existing session IDs.
//     * Checks existing non empty session directories and sets the ID set to the speaker manager.
//     * 
//     * @throws StorageManagerException 
//     * 
//     */
//    public void updateSessionsSet() throws StorageManagerException {
//        if(storageManager!=null && speakerManager!=null){
//            Set<String> localSessionIds=null; 
//
//            localSessionIds=storageManager.localSessionIds(false);
//            speakerManager.setSessionIdsInUse(localSessionIds);
//            if(DEBUG){
//                if(localSessionIds!=null){ 
//                    for(String locSessId:localSessionIds){
//                        System.out.println("Existing session ID:"+locSessId);
//                    }
//                }
//            }
//
//        }
//    }
    
    /**
     * Updates the set of already existing item codes.
     * 
     * @throws StorageManagerException 
     * 
     */
    public void updateItemCodesInUseSet() throws StorageManagerException {
        if(storageManager!=null && speakerManager!=null && recScriptManager!=null){
            Set<String> itemCodesInUse=new HashSet<String>();
            Set<String> scriptCodes=recScriptManager.getExistingCodes();
            Set<String> codesToCheck=new HashSet<String>(scriptCodes);
//            Set<String> localSessionIdStrs=storageManager.localSessionIds(false);
          
            for(ipsk.db.speech.Session s:projectDb.getSessions()){
                
                for(ipsk.db.speech.Speaker spk:s.getSpeakers()){
                    for(String itemCode:codesToCheck){
                        boolean inUse=storageManager.isRecorded(s.getSessionId(), spk.getCode(),itemCode);
                        if(inUse){
                            itemCodesInUse.add(itemCode);
                        }
                    }
                    codesToCheck.removeAll(itemCodesInUse);
                }
                if(codesToCheck.size()==0){
                    break;
                }
            }
            //System.out.println("Itemcodes in use: "+StringSequenceBuilder.buildString(itemCodesInUse, ','));
            this.itemCodesInUse=itemCodesInUse;
        }else{
            throw new StorageManagerException("Not all components initialized!");
        }
    }



	/**
	 * @return
	 */
	public Set<String> getItemCodesInUse() {
		return itemCodesInUse;
	}



    /* (non-Javadoc)
     * @see ipsk.apps.speechrecorder.session.SessionManagerListener#requestProjectConfigDisableOverwriteWarning()
     */
    @Override
    public void requestProjectConfigDisableOverwriteWarning() {
        project.getRecordingConfiguration().setOverwriteWarning(false);
        projectConfigurationSaved=false;
    }
    
    // TODO this method mixes session and project related stuff
    public synchronized boolean close() throws AudioControllerException,
            StorageManagerException, WorkspaceException, SpeechRecorderException{
        
        sessionManager.close();
       
        boolean allSaved=saveAllProjectDataInteractive();
        if(!allSaved)return false;
            
        
        if (useUploadCache) {

            if (!uploadCache.isIdle()) {
                // set parent to null, if the main window (speechrecorderUI)
                // closes, this dialog is remaining on the screen.
                final JDialog f = new JDialog((Frame) null, uiString
                        .getString("UploadProgress"));
                f.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
                JLabel pleaseWaitLabel = new JLabel();
                pleaseWaitLabel.setBorder(BorderFactory.createEmptyBorder(10,
                        10, 10, 10));
                Font defFont = speechRecorderUI.getFont();
                pleaseWaitLabel.setFont(defFont.deriveFont(Font.BOLD));
                if (waitForCompleteUpload) {
                    pleaseWaitLabel.setText(uiString
                            .getString("PleaseWaitForCompleteUpload"));
                } else {
                    pleaseWaitLabel.setText(uiString
                            .getString("PleaseWaitForUploadCanceling"));
                }
                f.getContentPane().setLayout(new BorderLayout());
                f.getContentPane().add(pleaseWaitLabel,BorderLayout.CENTER);
                f.getContentPane().add(speechRecorderUI.getUploadCacheUI(),BorderLayout.SOUTH);
                Runnable doShow = new Runnable() {
                    public void run() {
                        f.pack();
                        f.setLocationRelativeTo(speechRecorderUI);
                        f.setVisible(true);
                    }
                };

                try {
                    if (SwingUtilities.isEventDispatchThread()) {
                        doShow.run();
                    } else {
                        SwingUtilities.invokeAndWait(doShow);
                    }
                } catch (InterruptedException e) {
                    // OK
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    // Hmm ?
                    e.printStackTrace();
                }

            }
        }else{
            // close storage manager in standalone mode
            if(storageManager!=null){
                storageManager.close();
            }
        }

        setProjectURL(null);
        
        
       
        recScriptManager.doClose();
        speakerManager.close();
        lastSessionId=null;
        bundleAnnotationPersistorList.clear();
        if(project!=null){
        String projectName=project.getName();
        setConfiguration(null);
        if(listener!=null){
            
            listener.update(new ProjectManagerProjectClosedEvent(this, projectName));
        }
        }
        return true;
    }



    public List<BundleAnnotationPersistor> getBundleAnnotationPersistorList() {
        return bundleAnnotationPersistorList;
    }

	
	

}
