//    Speechrecorder
//    (c) Copyright 2015
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.


package ipsk.apps.speechrecorder.workspace.ui;

import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.WorkspaceProject;
import ipsk.io.FilenameValidator;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.util.List;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

/**
 * Dialog to rename project.
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */
public class ProjectEmuDBExportDialog extends JPanel implements ActionListener, DocumentListener {

	private static final long serialVersionUID = 1L;
	private JTextField baseDirNameField;
	private JButton browseButton;
	private JFileChooser fileChooser;
	private static JButton okButton;
	private static JButton cancelButton;
	private static JOptionPane selPane;

	private Document baseDirNameDoc;
	
	private File exportBaseDir=null; 
	private JTextField statusLabel;
	
	public ProjectEmuDBExportDialog(WorkspaceProject project,File projectDir) {
		super(new GridBagLayout());
	
		okButton = new JButton("OK");
		okButton.setEnabled(false);
		okButton.addActionListener(this);
		cancelButton = new JButton("Cancel");
		cancelButton.setEnabled(true);
		cancelButton.addActionListener(this);
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.HORIZONTAL;
		c.insets = new Insets(5, 10, 5, 10);
		c.gridx = 0;
		c.gridy = 0;
		c.anchor = GridBagConstraints.WEST;
		add(new JLabel("Export base directory"), c);
		c.gridx++;
		c.weightx = 3;
		baseDirNameField = new JTextField(20);
		
		baseDirNameDoc = baseDirNameField.getDocument();
		baseDirNameDoc.addDocumentListener(this);
		add(baseDirNameField, c);
		

        c.gridx++;
        c.weightx = 0;
        c.anchor = GridBagConstraints.EAST;
        c.fill = GridBagConstraints.NONE;
        browseButton = new JButton("Browse...");
        browseButton.addActionListener(this);
        add(browseButton, c);
		
		c.gridy++;
		c.gridx=0;
		c.gridwidth=3;
		c.weightx=2.0;
		c.fill=GridBagConstraints.HORIZONTAL;
		statusLabel=new JTextField(30);
		statusLabel.setEditable(false);
		add(statusLabel,c);
		baseDirNameField.setText("");
	}
	public Object showDialog(Component parent) {

		selPane =
			new JOptionPane(
				this,
				JOptionPane.PLAIN_MESSAGE,
				JOptionPane.OK_CANCEL_OPTION,
				null,
				new Object[] { okButton, cancelButton});
		JDialog dialog = selPane.createDialog(parent, "Export to EmuDB");
		dialog.setVisible(true);

		return selPane.getValue();
		
	}
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent ae) {
		Object src = ae.getSource();

		if (src == okButton) {
			//			p.setAudioControllerClass(acClassNameField.getText());
			selPane.setValue(new Integer(JOptionPane.OK_OPTION));
			//dialog.dispose();
			 
			 
		}else if(src==cancelButton){
			selPane.setValue(new Integer(JOptionPane.CANCEL_OPTION));
		}else if (src == browseButton) {
            fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            String baseDirName=baseDirNameField.getText();
            if(!"".equals(baseDirName)){
                File currentBaseDir=new File(baseDirName);
                fileChooser.setCurrentDirectory(currentBaseDir);
            }
            int res = fileChooser.showDialog(this,"Select");
            if (res == JFileChooser.APPROVE_OPTION) {
               exportBaseDir = fileChooser.getSelectedFile();
               baseDirNameField.setText(exportBaseDir.getPath());
              
                setDependencies();
            }
        }

	}
	
	 private void setDependencies() {
	     String baseDirName=baseDirNameField.getText();
	     if(!"".equals(baseDirName)){
	         okButton.setEnabled(true);
	     }
	     
	 }
	
	
	public Path getBaseDir(){
	    String baseDirName=baseDirNameField.getText();
        Path baseDir=new File(baseDirName).toPath();
        return baseDir;
	}

	private void documentChanged(Document d) {
	    
	}

	/* (non-Javadoc)
	 * @see javax.swing.event.DocumentListener#changedUpdate(javax.swing.event.DocumentEvent)
	 */
	public void changedUpdate(DocumentEvent arg0) {
		documentChanged(arg0.getDocument());

	}
	/* (non-Javadoc)
	 * @see javax.swing.event.DocumentListener#insertUpdate(javax.swing.event.DocumentEvent)
	 */
	public void insertUpdate(DocumentEvent arg0) {

		documentChanged(arg0.getDocument());
	}
	/* (non-Javadoc)
	 * @see javax.swing.event.DocumentListener#removeUpdate(javax.swing.event.DocumentEvent)
	 */
	public void removeUpdate(DocumentEvent arg0) {

		documentChanged(arg0.getDocument());
	}

}
