//    Speechrecorder
//    (c) Copyright 2012
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.
 
package ipsk.apps.speechrecorder.actions;

import ipsk.apps.speechrecorder.SpeechRecorder;
import ipsk.apps.speechrecorder.project.ActiveProjectManager;
import ipsk.apps.speechrecorder.session.SessionManager;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;

/**
 * Basic Speechrecorder action.
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

public abstract class BasicProjectAction extends AbstractAction {

	protected ActiveProjectManager projectManager;
    public String ACTION_COMMAND;
    public BasicProjectAction(){
        super();
    }
    
    /**
     * Create action.
     * @param sessionManager 
     * @param name name of the action
     */
    public BasicProjectAction(ActiveProjectManager projectManager,String name){
        this();   
        this.projectManager=projectManager;
        putValue(Action.NAME, name);
    }
    public abstract void actionPerformed(ActionEvent arg0);

}
