//    Speechrecorder
// 	  (c) Copyright 2016
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.



package ipsk.apps.speechrecorder.db.export.emu;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

import ips.annot.autoannotator.AutoAnnotation;
import ips.annot.autoannotator.AutoAnnotator.AnnotationRequest;
import ips.annot.model.PredefinedLevelDefinition;
import ips.annot.model.db.AttributeDefinition;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.annot.model.db.LevelDefinition;
import ips.annot.model.db.Link;
import ips.annot.model.db.LinkDefinition;
import ips.annot.model.db.Session;
import ips.annot.model.emu.EmuBundleAnnotationPersistor;
import ips.annot.model.emu.EmuDB;
import ips.annot.model.emu.webapp.EMUwebAppConfig;
import ipsk.apps.speechrecorder.SpeechRecorderException;
import ipsk.apps.speechrecorder.annotation.auto.AutoAnnotationManager;
import ipsk.apps.speechrecorder.annotation.auto.impl.PromptAutoAnnotator;
import ipsk.apps.speechrecorder.annotation.auto.impl.TemplateAutoAnnotator;
import ipsk.apps.speechrecorder.project.ProjectManager;
import ipsk.apps.speechrecorder.project.ProjectManagerException;
import ipsk.audio.AudioSourceException;
import ipsk.audio.ConvenienceFileAudioSource;
import ipsk.db.speech.LocalizedText;
import ipsk.db.speech.Recording;
import ipsk.db.speech.RecordingFile;
import ipsk.io.StreamCopy;

/**
 * @author klausj
 *
 */
public class EmuExporter extends ProjectManager{
	
	public EmuExporter() throws ProjectManagerException {
		super();
	}
	
    private Bundle buildBundle(String bundleName,Session session,Recording promptItem,Path recFile) throws IOException, UnsupportedAudioFileException{
//      if(promptAutoAnnotator!=null){
//          promptAutoAnnotator.setPromptText(null);
//      }
//      if(templateAutoAnnotator!=null){
//          templateAutoAnnotator.setTemplateText(null);
//      }
        // build Bundle
        Bundle bundle=new Bundle();
        bundle.setSession(session);
       
        bundle.setName(bundleName);
      
        try {
            
            
                bundle.setAnnotates(recFile.getFileName().toString());
                ConvenienceFileAudioSource cfas=new ConvenienceFileAudioSource(recFile.toFile());
                AudioFormat af=cfas.getFormat();
                long fl=cfas.getFrameLength();
                bundle.setSampleRate(af.getSampleRate());
                bundle.setFrameLength(fl);
            
            List<String> sigPathes=new ArrayList<String>();
           
            sigPathes.add(recFile.toAbsolutePath().toString());
            
            bundle.setSignalpaths(sigPathes);
            
            String prDescr=promptItem.getDescription();
//          if(promptAutoAnnotator!=null){
//              promptAutoAnnotator.setPromptText(prDescr);
//          }
//          
//          List<Mediaitem> mis=promptItem.getMediaitems();
//          for(Mediaitem mi:mis){
//             if(mi.getAnnotationTemplate()){
//                 if(templateAutoAnnotator!=null){
//                     templateAutoAnnotator.setTemplateText(mi.getText());
//                 }
//                 break;
//             }
//          }
        } catch (AudioSourceException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
       
        return bundle;
    }

public void exportProjectAsEmuDB(Path exportDir) throws IOException, URISyntaxException, SpeechRecorderException, ProjectManagerException {

    boolean link=true;
    
    // first search project main dir

    URL projectURL = getProjectContext();

    File projDir = new File(projectURL.toURI().getPath());

    String prjNm=project.getName();
    Path emuDBDir=exportDir.resolve(prjNm+"_emuDB");
    if(Files.exists(emuDBDir)) {
        throw new ProjectManagerException("EmuDB directory "+emuDBDir+" already exists!");
    }
    
    Files.createDirectories(emuDBDir);
  
    // config file
    Path emuDBCfgFile=emuDBDir.resolve(prjNm+"_DBconfig.json");
    
    EmuDB emuDB=new EmuDB();
    emuDB.setName(project.getName());  
    //Hmmm set same UUID ??
    UUID prjUuid=project.getUuid();
    if(prjUuid==null){
        prjUuid=UUID.randomUUID();
    }
    emuDB.setUuid(prjUuid);
    
    
    LevelDefinition prtLvlDef=new LevelDefinition(PredefinedLevelDefinition.PRT);
    AttributeDefinition prtAttrDef=new AttributeDefinition();
    prtAttrDef.setName(PredefinedLevelDefinition.PRT.getKeyName());
    prtAttrDef.setType(AttributeDefinition.TYPE_STRING);
    prtLvlDef.addAttributeDefinition(prtAttrDef);
    emuDB.getLevelDefinitions().add(prtLvlDef);
    
    LevelDefinition tplLvlDef=new LevelDefinition(PredefinedLevelDefinition.TPL);
    AttributeDefinition tplAttrDef=new AttributeDefinition();
    tplAttrDef.setName(PredefinedLevelDefinition.TPL.getKeyName());
    tplAttrDef.setType(AttributeDefinition.TYPE_STRING);
    tplLvlDef.addAttributeDefinition(tplAttrDef);
    emuDB.getLevelDefinitions().add(tplLvlDef);
    
    if(link){
        LinkDefinition linkPrtTplDef=new LinkDefinition();
        linkPrtTplDef.setType(LinkDefinition.ONE_TO_MANY);
        linkPrtTplDef.setSuperLevel(prtLvlDef);
        linkPrtTplDef.setSubLevel(tplLvlDef);
        emuDB.getLinkDefinitions().add(linkPrtTplDef);
    }
    
    
    emuDB.setEMUwebAppConfig(EMUwebAppConfig.defaultWithDefaultPerspective());

    HashMap jaxbEclipseLinkPropsmap=new HashMap();
    jaxbEclipseLinkPropsmap.put("javax.xml.bind.context.factory","org.eclipse.persistence.jaxb.JAXBContextFactory");

    try {
        JAXBContext jaxbContext = org.eclipse.persistence.jaxb.JAXBContextFactory.createContext(new Class[]{EmuDB.class},jaxbEclipseLinkPropsmap);
        Marshaller m=jaxbContext.createMarshaller();
        m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
        m.setProperty("eclipselink.media-type", "application/json");
        m.marshal(emuDB,emuDBCfgFile.toFile());
       
    } catch (JAXBException e) {
        e.printStackTrace();
        throw new ProjectManagerException(e);
    }
    
    EmuBundleAnnotationPersistor bPers=new EmuBundleAnnotationPersistor();
    AutoAnnotationManager autoAnnotationManager=new AutoAnnotationManager();
    PromptAutoAnnotator paa=new PromptAutoAnnotator();
    TemplateAutoAnnotator taa=new TemplateAutoAnnotator();
    
    try {
        rebuildDb();
        String recFileExt=projectStorageManager.getUploadType().getExtension();
        //Set<ipsk.db.speech.Session> sesss=projectStorageManager.sessionsLazy(projectDb, recScriptManager.getScript());
        Set<ipsk.db.speech.Session> sesss=projectDb.getSessions();
        for(ipsk.db.speech.Session sess:sesss) {
            
            Session annotSession=new Session();
            projectStorageManager.updateRecFiles(sess,true);
            int sessionId=sess.getSessionId();
            String sessIdStr=projectStorageManager.sessionIDString(sessionId);
            annotSession.setName(sessIdStr);
            //URL sessURL=projectStorageManager.getSessionURL(sessionId);
            String emuSessDirName=sessIdStr+"_ses";
            Path emuDbSessDir=emuDBDir.resolve(emuSessDirName);
            Files.createDirectory(emuDbSessDir);
            autoAnnotationManager.setAnnotationSession(annotSession);
            Set<RecordingFile> rfs=sess.getRecordingFiles();
            for(RecordingFile rf:rfs) {
                Recording r=rf.getRecording();
                
                String ic=r.getItemcode();
                int recVers=0;
                Integer recVersion=rf.getVersion();
                if(recVersion!=null){
                    recVers=recVersion;
                }
                String emuBundleName=projectStorageManager.getRootFileName(sessionId,ic, sess.getCode(),recVers);
                
                Path emuDbBndlDir=emuDbSessDir.resolve(emuBundleName+"_bndl");
                Files.createDirectory(emuDbBndlDir);
                String sigUrlsStr=rf.getSignalFile();
                URL sigUrl=new URL(sigUrlsStr);
                File recFile=new File(sigUrl.toURI().getPath());
                Path emuRecFile=emuDbBndlDir.resolve(emuBundleName+"."+recFileExt);
                StreamCopy.copy(recFile, emuRecFile.toFile());
                
                // build _annot.json file
                Bundle b=autoAnnotationManager.buildBundle(emuDB,emuBundleName, new File[]{emuRecFile.toFile()});
                
                paa.open();
                paa.setPromptText(r.getDescription());
                paa.setAnnotationRequest(new AnnotationRequest(b));
                paa.call();
                paa.close();
                
                taa.open();
                String templText=null;
                LocalizedText lt=r.annotationTemplateLocalizedText();
                if(lt!=null){
                    templText=lt.getText();
                }
                taa.setTemplateText(templText);
                taa.setAnnotationRequest(new AnnotationRequest(b));
                AutoAnnotation taan=taa.call();
                taa.close();
               
                
                if(link){
                List<Level> bLvls=b.getLevels();
                Item prtIt=null;
                for(Level bLvl:bLvls){
                    if(PromptAutoAnnotator.PREDEFINED_LEVEL_DEFINITION.getKeyName().equals(bLvl.getName())){
                        List<Item> its=bLvl.getItems();
                        if(its.size()==1){
                            prtIt=its.get(0);
                        }
                    }
                }
                Item tplIt=null;
                for(Level bLvl:bLvls){
                    if(TemplateAutoAnnotator.PREDEFINED_LEVEL_DEFINITION.getKeyName().equals(bLvl.getName())){
                        List<Item> its=bLvl.getItems();
                        if(its.size()==1){
                            tplIt=its.get(0);
                        }
                    }
                }
                
                // Link prompt to template item if both exist
                if(prtIt!=null & tplIt!=null){
                    Link ln=new Link();
                    ln.setFrom(prtIt);
                    ln.setTo(tplIt);
                    b.getLinksAsSet().add(ln);
                }
                }
                
                Path emuAnnotFile=emuDbBndlDir.resolve(emuBundleName+"_annot.json");
                bPers.setFile(emuAnnotFile.toFile());
                bPers.write(b);
            }
        }
    } catch (Exception e) {
        // TODO Auto-generated catch block
        e.printStackTrace();
    }

    
    
}

}
