//    Speechrecorder
//    (c) Copyright 2012
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.apps.speechrecorder.script;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.db.speech.Group;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.Nonrecording;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Recording;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.table.AbstractTableModel;

public class PromptItemsTableModel extends AbstractTableModel implements PropertyChangeListener {

	public static final int COL_INDEX=0;
	public static final int COL_GROUP=1;
	public static final int COL_FILE = 2;
	public static final int COL_PROMPT=3;
	private static final int LAST_COL_INDEX=COL_PROMPT;
	
	private List<Group> promptUnits;
	
	
	public PromptItemsTableModel(){
		promptUnits=new ArrayList<Group>();
		
	}
	
	public Class<?> getColumnClass(int colIndex){
		if(colIndex==COL_INDEX){
			return Integer.class;
		}else if(colIndex==COL_GROUP){
            return Integer.class;
        }else if(colIndex==COL_FILE){
            return String.class;
        }else if(colIndex==COL_PROMPT){
			return String.class;
		}else return null;
			
	}
	public String getColumnName(int colIndex){
		if(colIndex==COL_INDEX){
			return "Index in section";
		}else if(colIndex==COL_GROUP){
		    return "Gr";
		}else if(colIndex==COL_FILE){
		    return "File";
		}else if(colIndex==COL_PROMPT){
			return "Prompt";
		}else return null;
	}
	
	public int getColumnCount() {
		return LAST_COL_INDEX+1;
		
	}

	public int getRowCount() {
	    int rows=0;
	    for(Group g:promptUnits){
	        int gRows=g.getPromptItems().size();
	        rows+=gRows;
	    }
	    return rows;
	}

	
	public List<PromptItem> promptItems(){
	    List<PromptItem> pis=new ArrayList<PromptItem>();
	    if(promptUnits!=null){
	        for(Group g:promptUnits){
	            pis.addAll(g.getPromptItems());
	        }
	    }
	    return pis;
	}
	
	private Integer groupOfPromptItem(PromptItem pi){
		int grIdx=0;
		for(Group g:promptUnits){
		   List<PromptItem> pis= g.getPromptItems();
		   boolean realGroup=pis.size()>1;
				// lookup in this group
				for(PromptItem gpi:g.getPromptItems()){
					if(gpi==pi){
					    if(realGroup){
					        return grIdx;
					    }else{
					        return null;
					    }
					}
				}
				// not found, next group index 
				if(realGroup){
				    grIdx++;
				}
			}
		
		// not found at all
		return null;
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
	    if(columnIndex>LAST_COL_INDEX || rowIndex>getRowCount()){
	        return null;
	    }
		PromptItem rowItem=promptItems().get(rowIndex);
		Recording r=null;
		if(rowItem instanceof Recording){
		    r=(Recording)rowItem;
		}
		if (columnIndex==COL_INDEX){
			return rowIndex;
		}else if (columnIndex==COL_GROUP){
            Integer grIdx=groupOfPromptItem(rowItem);
            return grIdx;
        }else if (columnIndex==COL_FILE){
            if(r==null){
                return "";
            }else{
                return r.getItemcode();
            }
        }else if(columnIndex==COL_PROMPT){
			return rowItem.getDescription();
		}else{
			return null;
		}
	}
	
	public void setValueAt(Object aValue,
            int rowIndex,
            int columnIndex){
//	    if(columnIndex<=LAST_COL_INDEX || rowIndex<=promptItems.length){
	    if(columnIndex==COL_FILE){
	        PromptItem pi=promptItems().get(rowIndex);
	        if(pi instanceof Recording && aValue instanceof String){
	            Recording r=(Recording)pi;
	            r.setItemcode((String)aValue);
	        }
	    }else if(columnIndex==COL_PROMPT && aValue instanceof String){
	        PromptItem pi=promptItems().get(rowIndex);
	        // TODO
	        pi.getMediaitems().get(0).setText((String)aValue);
	    }
//	    }
	}
	
	public boolean isCellEditable(int row, int col){
	    PromptItem pi=promptItems().get(row);
	    if(col==COL_FILE){
	        // non recording items do not have an item code
	        if(pi instanceof Nonrecording){
	            return false;
	        }else{
	            return true;
	        }
	        
	    }
	    if(col==COL_PROMPT){
	       
	        String mType=pi.getMediaitems().get(0).getNNMimetype();
	        for(String ptMimeType:MIMETypes.PLAINTEXTMIMETYPES){
	            if(mType.equals(ptMimeType)){
	                return true;
	            }
	        }
	    }
	    return false;
	}

	public List<Group> getPromptUnits() {
		return promptUnits;
	}
	
	private void _setPromptUnits(List<Group> promptUnits) {
        if (this.promptUnits != null) {
            for (PromptItem oldPromptItem : promptItems()) {
                Mediaitem mi=oldPromptItem.getMediaitems().get(0);
                mi.removePropertyChangeListener(this);
                oldPromptItem.removePropertyChangeListener(this);
            }
        }
        this.promptUnits = promptUnits;
        if (this.promptUnits != null) {
            for (PromptItem pi : promptItems()) {
                Mediaitem mi=pi.getMediaitems().get(0);
                mi.addPropertyChangeListener(this);
                pi.addPropertyChangeListener(this);
            }
        }
       
    }

	public void setPromptUnits(List<Group> promptUnits) {
		_setPromptUnits(promptUnits);
        fireTableDataChanged();
    }
	
	public void setPromptUnits(List<Group> promptUnits, int deletedFirstRow,int deletedLastRow) {
		_setPromptUnits(promptUnits);
        fireTableRowsDeleted(deletedFirstRow, deletedLastRow);
        fireTableDataChanged();
    }
	

    public void propertyChange(PropertyChangeEvent evt) {
        Object src=evt.getSource();
        
        List<PromptItem> promptItems=promptItems();
        if(src instanceof PromptItem){
            for(int i=0;i<promptItems.size();i++){
                if(src==promptItems.get(i)){
                    fireTableRowsUpdated(i, i);
                }
            }
        }else if(src instanceof Mediaitem){
            for(int i=0;i<promptItems.size();i++){
                Mediaitem mi=promptItems.get(i).getMediaitems().get(0);
                if(src==mi){
                    fireTableRowsUpdated(i, i);
                }
            }
        }
        
    }
	

}
