//    Speechrecorder
//    (c) Copyright 2012
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.apps.speechrecorder.script.ui;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;

import ipsk.apps.speechrecorder.script.ItemcodeGenerator;
import ipsk.apps.speechrecorder.script.TableTextfileImporter;
import ipsk.db.speech.Section;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.swing.JDialogPanel;

public class ImportScriptUIDialog extends JDialogPanel implements
		ActionListener, PropertyChangeListener {

    private TableTextfileImporter tableTextfileImporter;
	
	private Section section;

	public ImportScriptUIDialog(URL projectContext,ItemcodeGenerator itemcodeGenerator,IntegerSequenceGenerator sequenceGenerator) {
	    super(JDialogPanel.Options.OK_CANCEL);
	    okButton.setText("Import as new section");
	    setFrameTitle("Import text list/table to recording script");
	    setApplyingEnabled(false);
		TableTextfileImporter.ColumnDescriptor[] rows=new TableTextfileImporter.ColumnDescriptor[]{
		        TableTextfileImporter.ITEM_CODE_DESCRIPTOR,
		        TableTextfileImporter.PROMPT_TEXT_DESCRIPTOR,
		        TableTextfileImporter.INSTRUCTIONS_TEXT_DESCRIPTOR,
		        TableTextfileImporter.COMMENT_TEXT_DESCRIPTOR
		        
		};
        tableTextfileImporter=new TableTextfileImporter(rows,itemcodeGenerator,sequenceGenerator);
        tableTextfileImporter.addPropertyChangeListener(TableTextfileImporter.VALID_SCRIPT_AVAILABLE_PROPNAME,this);
        Container contentPane=getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(tableTextfileImporter,BorderLayout.CENTER);
      
		
	}
	public ImportScriptUIDialog(ItemcodeGenerator itemcodeGenerator) {
		this(null,itemcodeGenerator,null);
	}
	public ImportScriptUIDialog(ItemcodeGenerator itemcodeGenerator,IntegerSequenceGenerator sequenceGenerator) {
		this(null,itemcodeGenerator,sequenceGenerator);
	}
	public ImportScriptUIDialog() {
		this(null,new ItemcodeGenerator(),null);
	}

	protected void applyValues(){
		section=tableTextfileImporter.createSection();
	}


	public Section getSection() {
		return section;
	}

	/* (non-Javadoc)
	 * @see java.beans.PropertyChangeListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent arg0) {
		String pName=arg0.getPropertyName();
		if(TableTextfileImporter.VALID_SCRIPT_AVAILABLE_PROPNAME.equals(pName)){
			Object newValue=arg0.getNewValue();
			if(newValue instanceof Boolean){
				boolean validAvailable=(Boolean)newValue;
				setApplyingEnabled(validAvailable);
			}
		}
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		ImportScriptUIDialog sui = new ImportScriptUIDialog(null,new ItemcodeGenerator(),null);
	}


      

	
}
