//    Speechrecorder
// 	  (c) Copyright 2018
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.



package ipsk.apps.speechrecorder.annotation.auto;

import java.io.IOException;
import java.net.URISyntaxException;

import ipsk.apps.speechrecorder.SpeechRecorderException;
import ipsk.apps.speechrecorder.project.ActiveProjectManager;
import ipsk.apps.speechrecorder.project.ProjectManagerException;
import ipsk.awt.ProgressWorker;
import ipsk.awt.WorkerException;

/**
 * @author klausj
 *
 */
public class ProjectAutoAnnotatorWorker extends ProgressWorker {

        private ProjectAutoAnnotator paa;
        private boolean overwriteAnnotationFiles=false;

        public boolean isOverwriteAnnotationFiles() {
            return overwriteAnnotationFiles;
        }

        public void setOverwriteAnnotationFiles(boolean overwriteAnnotationFiles) {
            this.overwriteAnnotationFiles = overwriteAnnotationFiles;
        }

        public ProjectAutoAnnotatorWorker(ActiveProjectManager projectManager){
            super();
            paa=new ProjectAutoAnnotator(projectManager);
            setTask(paa);
        }
        
        protected void doWork() throws WorkerException{
            try {
                paa.autoAnnotateProject(overwriteAnnotationFiles,this);
            } catch (IOException | URISyntaxException | SpeechRecorderException | ProjectManagerException e) {
               
                e.printStackTrace();
                throw new WorkerException("Error auto annotating project: "+e.getLocalizedMessage(),e);
            }
        }
      
}
