//    Speechrecorder
// 	  (c) Copyright 2017
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.



package ipsk.apps.speechrecorder.script.ui;

import java.awt.LayoutManager;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

/**
 * @author klausj
 *
 */
public class JFontSizeChooser extends JPanel {

	
	private double defaultSize;
	private JCheckBox relativeSizeCheckBox;
	private SpinnerModel relativeSizeSpinnerModel;
	private JSpinner relativeSizeSpinner;
	
	private Double relativeSize=1.0;
	
	public Double getRelativeSize() {
		return relativeSize;
	}

	public void setRelativeSize(Double relativeSize) {
		this.relativeSize = relativeSize;
	}

	/**
	 * 
	 */
	public JFontSizeChooser() {
		super();
		relativeSizeSpinnerModel=new SpinnerNumberModel(100, 1, 1000, 1);
		relativeSizeSpinner=new JSpinner(relativeSizeSpinnerModel);
		add(new JLabel("Font size relative:"));
		add(relativeSizeSpinner);
	}

	

}
