//    Speechrecorder
// 	  (c) Copyright 2017
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.



package ipsk.apps.speechrecorder.script.ui.prompt.styled;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.ViewFactory;

import ipsk.db.speech.Font.FontSize;

import javax.swing.text.StyledEditorKit.StyledTextAction;

/**
 * @author klausj
 *
 */
public class PromptDocEditorKit extends StyledEditorKit {

	/**
	 * 
	 */
	public PromptDocEditorKit() {
		super();
	}

	/* (non-Javadoc)
	 * @see javax.swing.text.EditorKit#getContentType()
	 */
	@Override
	public String getContentType() {
		return "text/x-prompt";
	}
	
	/**
     * An action to toggle underline attribute.
     
     */
    public static class UnderlineAction extends StyledTextAction {



        public UnderlineAction() {
            super("underline");
        }

        /**
         * Toggles the underline attribute.
         *
         * @param e the action event
         */
        public void actionPerformed(ActionEvent e) {
            JEditorPane editor = getEditor(e);
            if (editor != null) {
                StyledEditorKit kit = getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean underline = (StyleConstants.isUnderline(attr)) ? false : true;
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setUnderline(sas, underline);
                if(underline) {
                	StyleConstants.setStrikeThrough(sas, false);
                }
                setCharacterAttributes(editor, sas, false);
            }
        }
    }
	
	 /**
     * An action to toggle the strike through attribute.
     
     */
    public static class StrikethroughAction extends StyledTextAction {

        /**
         * Constructs a new StrikeThroughAction.
         */
        public StrikethroughAction() {
            super("strike-through");
        }

        /**
         * Toggles the Strikethrough attribute.
         *
         * @param e the action event
         */
        public void actionPerformed(ActionEvent e) {
            JEditorPane editor = getEditor(e);
            if (editor != null) {
                StyledEditorKit kit = getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean strikethrough = (StyleConstants.isStrikeThrough(attr)) ? false : true;
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setStrikeThrough(sas, strikethrough);
                if(strikethrough) {
                	StyleConstants.setUnderline(sas, false);
                }
                setCharacterAttributes(editor, sas, false);
            }
        }
    }
    
    public static class SetFontSizeActionEvent extends ActionEvent{
    	/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
		public SetFontSizeActionEvent(Object source, String command, FontSize fontSize,int size) {
			super(source, ActionEvent.ACTION_PERFORMED, command);
			this.fontSize=fontSize;
			this.size = size;
		}
		private int size;
		private FontSize fontSize;
		public FontSize getFontSize() {
			return fontSize;
		}
		public int getSize() {
			return size;
		}
    
    }
    
    /**
     * An action to set font size attribute.
     */
    public static class SetFontSizeAction extends StyledTextAction {

    	/**
    	 * Constructs a new StrikeThroughAction.
    	 */
    	public SetFontSizeAction() {
    		super("set-font-size");
    	}


    	public void actionPerformed(ActionEvent e) {
    		JEditorPane editor = getEditor(e);
    		if (editor != null && e instanceof SetFontSizeActionEvent) {
    			SetFontSizeActionEvent sfae=(SetFontSizeActionEvent)e;
    			StyledEditorKit kit = getStyledEditorKit(editor);
    			MutableAttributeSet attr = kit.getInputAttributes();
    			FontSize fs=sfae.getFontSize();

    			SimpleAttributeSet sas = new SimpleAttributeSet();
    			if(fs==null) {
    				sas.removeAttribute(PromptStyledDocument.STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE);
    				Document d=editor.getDocument();
    				if( d instanceof PromptStyledDocument) {
    					PromptStyledDocument psd=(PromptStyledDocument)d;

    					Style defStyle=psd.getStyle(StyleContext.DEFAULT_STYLE);
    					Object defFontSize=defStyle.getAttribute(StyleConstants.FontSize);

    					if(defFontSize instanceof Number){
    						Number defFontSizeNumber=(Number)defFontSize;
    						StyleConstants.setFontSize(sas,defFontSizeNumber.intValue());
    					}
    				}
    			}else {
    				sas.addAttribute(PromptStyledDocument.STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE,fs);
    				StyleConstants.setFontSize(sas,sfae.getSize());
    			}
    			setCharacterAttributes(editor, sas, false);
    		}
    	}
    }

	/* (non-Javadoc)
	 * @see javax.swing.text.EditorKit#createDefaultDocument()
	 */
	@Override
	public Document createDefaultDocument() {
		return new PromptStyledDocument();
//		return new DefaultStyledDocument();
	}


}
