//    Speechrecorder
// 	  (c) Copyright 2017
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.



package ipsk.apps.speechrecorder.script.ui.prompt.styled;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

import ipsk.awt.ColorUtils;
import ipsk.db.speech.Font;
import ipsk.db.speech.Font.FontSize;
import ipsk.db.speech.P;
import ipsk.db.speech.Text;
import ipsk.db.speech.TextFormatElement;
import ipsk.text.ParserException;





/**
 * @author klausj
 *
 */
public class PromptStyledDocument extends javax.swing.text.DefaultStyledDocument{

	public static String STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE="fontSizeRelativeOrAbsolute";
	private Element section;

	public class PromptDocElement extends javax.swing.text.DefaultStyledDocument.SectionElement{
		
		public PromptDocElement() {
			super();
		}
		
	}
	
	public class ParagraphElement extends javax.swing.text.DefaultStyledDocument.BranchElement{
		
		public ParagraphElement(Element parent,AttributeSet  attrSet) {
			super(parent,attrSet);
			addAttribute(NameAttribute, "p");
		}
		
	}
	
	public class TextFragmentElement extends javax.swing.text.DefaultStyledDocument.LeafElement{
		
		public TextFragmentElement(Element parent,AttributeSet attrSet,int offs1,int offs2) {
			super(parent,attrSet,offs1,offs2);
		}
		
	}
    
//    private PromptDocElement promptDocElement;
//    private PositionImpl startPos=new PositionImpl();
//    private PositionImpl endPos=new PositionImpl();
//    private StyleContext styleContext;
    /**
     * 
     */
    public PromptStyledDocument() {
        super();
        
//        promptDocElement=new PromptDocElement(this);
//        ParagraphElement pe=new ParagraphElement(this, promptDocElement, 0);
//        CharElement ete=new CharElement(this, pe,null, 0);
//        ete.setCharacter('1');
//        CharElement ete2=new CharElement(this, pe,null, 1);
//        ete2.setCharacter('2');
//        CharElement ete3=new CharElement(this, pe,null, 2);
//        ete3.setCharacter('3');
//        
//        pe.addElement(ete);
//        pe.addElement(ete2);
//        pe.addElement(ete3);
//        promptDocElement.addElement(pe);
//        updatePositions();
//        styleContext=StyleContext.getDefaultStyleContext();
    }
    
//    protected AbstractElement createDefaultRoot() {
//      
//    	
//        writeLock();
//        if(section==null){
//        section = new PromptDocElement();
//       
//        section.addAttribute(StyleConstants.Alignment, StyleConstants.ALIGN_CENTER);
//        ParagraphElement paragraph = new ParagraphElement(section, null);
//
//        TextFragmentElement brk = new TextFragmentElement(paragraph, null, 0, 1);
//        
//        Element[] buff = new Element[1];
//        buff[0] = brk;
//        paragraph.replace(0, 0, buff);
//
//        buff[0] = paragraph;
//        section.replace(0, 0, buff);
//        writeUnlock();
//        }
//        return section;
//    }
//    
    public void setCharacterAttributes(int offset,int length,AttributeSet s,boolean replace){
    	super.setCharacterAttributes(offset, length, s, replace);
    }

    public Element getCharacterElement(int pos) {
        Element e=super.getCharacterElement(pos);
        return e;
    }
//
//    /* (non-Javadoc)
//     * @see javax.swing.text.StyledDocument#addStyle(java.lang.String, javax.swing.text.Style)
//     */
//    @Override
//    public Style addStyle(String nm, Style parent) {
//        return styleContext.addStyle(nm, parent);
//    }

    /* (non-Javadoc)
     * @see javax.swing.text.StyledDocument#getBackground(javax.swing.text.AttributeSet)
     */
//    @Override
//    public Color getBackground(AttributeSet attr) {
//        // TODO test
//        return Color.GREEN;
//    }
    

//    /* (non-Javadoc)
//     * @see javax.swing.text.StyledDocument#getFont(javax.swing.text.AttributeSet)
//     */
//    @Override
//    public Font getFont(AttributeSet attr) {
//        
//       Font f= new java.awt.Font(new HashMap<AttributedCharacterIterator.Attribute,AttributedCharacterIterator.Attribute>());
//       return f;
//    }

    /* (non-Javadoc)
     * @see javax.swing.text.StyledDocument#getForeground(javax.swing.text.AttributeSet)
     */
//    @Override
//    public Color getForeground(AttributeSet attr) {
//       return Color.RED;
//    }
    
    public String getText(int offset,
            int length)
              throws BadLocationException{
    	String s=super.getText(offset, length);
//    	System.out.println("getText(): "+offset+" "+length+" "+s);
    	return s;
    }
    
    public void getText(int offset,
            int length,
            Segment txt)
              throws BadLocationException{
    	
    	super.getText(offset, length, txt);
//    	System.out.println("getText(): "+offset+" "+length+" "+txt);
    }

//    /* (non-Javadoc)
//     * @see javax.swing.text.StyledDocument#getLogicalStyle(int)
//     */
//    @Override
//    public Style getLogicalStyle(int p) {
//        return styleContext.getStyle(StyleContext.DEFAULT_STYLE);
//    }
//
//   
//
//    /* (non-Javadoc)
//     * @see javax.swing.text.StyledDocument#getStyle(java.lang.String)
//     */
//    @Override
//    public Style getStyle(String nm) {
//         return styleContext.getStyle(nm);
//    }
//
//    /* (non-Javadoc)
//     * @see javax.swing.text.StyledDocument#removeStyle(java.lang.String)
//     */
//    @Override
//    public void removeStyle(String nm) {
//        styleContext.removeStyle(nm);
//    }
//
//    /* (non-Javadoc)
//     * @see javax.swing.text.StyledDocument#setCharacterAttributes(int, int, javax.swing.text.AttributeSet, boolean)
//     */
//    @Override
//    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
//        // TODO Auto-generated method stub
//        
//    }
//
//    /* (non-Javadoc)
//     * @see javax.swing.text.StyledDocument#setLogicalStyle(int, javax.swing.text.Style)
//     */
//    @Override
//    public void setLogicalStyle(int pos, Style s) {
//        // TODO Auto-generated method stub
//        
//    }
//
//    /* (non-Javadoc)
//     * @see javax.swing.text.StyledDocument#setParagraphAttributes(int, int, javax.swing.text.AttributeSet, boolean)
//     */
//    @Override
//    public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
//        // TODO Auto-generated method stub
//        
//    }
    
    
    private boolean toContentElems(Element parent,List<TextFormatElement> ftc,MutableAttributeSet as,PositionImpl pos,boolean endsWithBlank) throws ParserException{
        //    	List<Element> cElems=new ArrayList<>();


        int chSz=ftc.size();
        for(int i=0;i<chSz;i++){
            TextFormatElement ft=ftc.get(i);
           
            SimpleAttributeSet saSet=new SimpleAttributeSet();
            Text text=null;
            ipsk.db.speech.Font f=null;
            if(ft instanceof  ipsk.db.speech.Font){
                f=(ipsk.db.speech.Font)ft;
                text=f.getText();
            }else if(ft instanceof Text){
                text=(Text)ft;
            }
            String t=text.getText();
            
            String de=text.getDecoration();
            if(ipsk.db.speech.Text.UNDERLINE.equals(de)){
                StyleConstants.setUnderline(saSet, true);
            }else if(ipsk.db.speech.Text.LINE_THROUGH.equals(de)){
                StyleConstants.setStrikeThrough(saSet, true);
            }else if(ipsk.db.speech.Text.NONE.equals(de)){
                StyleConstants.setUnderline(saSet, false);
            }
            String co=text.getColor();
            if(co!=null){
                Color c=ColorUtils.stringToColor(co);
                if(c!=null){
                    StyleConstants.setForeground(saSet,c);
                }
            }
           
            if(f!=null){
                String si=f.getSize();
                if(si!=null){
                    Style defStyle=getStyle(StyleContext.DEFAULT_STYLE);
                    Object defFontSize=defStyle.getAttribute(StyleConstants.FontSize);
                    
                    if(defFontSize instanceof Number){
                        Number defFontSizeNumber=(Number)defFontSize;
                        FontSize fs=f.fontSize();
                        if(fs!=null) {
                        	saSet.addAttribute(STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE, fs);
                        }
                        double absSize=f.toRealFontSize(defFontSizeNumber.doubleValue());
                        StyleConstants.setFontSize(saSet, (int) absSize);
                        
                    }
                }
                String st=f.getStyle();
                if(ipsk.db.speech.Font.ITALIC.equals(st)){
                    StyleConstants.setItalic(saSet, true);
                }else if(ipsk.db.speech.Font.NORMAL.equals(st)){
                    StyleConstants.setBold(saSet, false);
                }
                String we=f.getWeight();
                if(ipsk.db.speech.Font.BOLD.equals(we)){
                    StyleConstants.setBold(saSet, true);
                }else if(ipsk.db.speech.Font.NORMAL.equals(we)){
                    StyleConstants.setBold(saSet, false);
                }
            }

            int offset=pos.getOffset();

            if(t!=null){
                try {
                    insertString(offset, t,saSet);
                } catch (BadLocationException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
                int tlen=t.length();
                //            Element ce=createLeafElement(parent, saSet, offset,offset+tlen);
                offset+=tlen;
                pos.setOffset(offset);
            }
        }
        return endsWithBlank;
    }
    
    public class PositionImpl implements Position{

    	private int offset=0;

		public int getOffset() {
			return offset;
		}

		public void setOffset(int offset) {
			this.offset = offset;
		}
		
    	
    }
   
    
    public PromptStyledDocument(StyleContext styleCtx,List<P> mediaItemParagraphs) throws ParserException{
        super(styleCtx);
        //System.out.println("Len: "+getLength());
        writeLock();
        int pCnt=mediaItemParagraphs.size();
        //    	Element[] pBuf=new Element[pCnt];
        section=getDefaultRootElement();
        PositionImpl pos=new PositionImpl();
        pos.setOffset(0);

        for(int pi=0;pi<pCnt;pi++){
            P p=mediaItemParagraphs.get(pi);
            //    		ParagraphElement pe=new ParagraphElement(section, null);
            Element pe=createBranchElement(section, getStyle(StyleContext.DEFAULT_STYLE));

            toContentElems(pe,p.getTexts(),getStyle(StyleContext.DEFAULT_STYLE),pos,false);
            if(pi<pCnt-1){
                int offset=pos.getOffset();
                String newLineT="\n";
                try {
                    insertString(offset,newLineT,new SimpleAttributeSet());
                } catch (BadLocationException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
                int tlen=newLineT.length();
                //            Element ce=createLeafElement(parent, saSet, offset,offset+tlen);
                offset+=tlen;
                pos.setOffset(offset);
            }
        }
        //		section.replace(0, 1, pBuf);

        writeUnlock();
        //System.out.println("Len: "+getLength());
    }
 
    public List<P> toPromptFormat() {
    	//System.out.println("Len: "+getLength());
    	readLock();
    	List<P> prParagraphs=new ArrayList<>();
    	Element rootElem=getDefaultRootElement();
    	int pCnt=rootElem.getElementCount();
    	for(int i=0;i<pCnt;i++){
    		Element pe=rootElem.getElement(i);
    		P p=new P();
    		prParagraphs.add(p);
    		
    		int pChCnt=pe.getElementCount();
    		for(int pci=0;pci<pChCnt;pci++){
    			Element pChE=pe.getElement(pci);
    			if(pChE.isLeaf()){
    			    
    				ipsk.db.speech.Font fe=null;
    				ipsk.db.speech.Text te=new Text();
    				// pChE is a formatted content element
    				// convert it to a SpeechDb hierarchy
    				AttributeSet attrSet=pChE.getAttributes();

    				if(attrSet.isDefined(StyleConstants.Italic)){
    				    // font element required
    					fe=new ipsk.db.speech.Font();
    					Object italicAttr=attrSet.getAttribute(StyleConstants.Italic);
    					if(Boolean.TRUE.equals(italicAttr)){
    					    fe.setStyle(ipsk.db.speech.Font.ITALIC);
    					}else{
    					    fe.setStyle(ipsk.db.speech.Font.NORMAL); 
    					}
    				}
    				if(attrSet.isDefined(StyleConstants.Bold)){
    					if(fe==null){
    					    // font element required
    						fe=new ipsk.db.speech.Font();
    					}
    					Object boldAttr=attrSet.getAttribute(StyleConstants.Bold);
    					if(Boolean.TRUE.equals(boldAttr)){
    					    fe.setWeight(ipsk.db.speech.Font.BOLD);
    					}else{
    					    fe.setWeight(ipsk.db.speech.Font.NORMAL);
    					}
    				}
    				if(attrSet.isDefined(StyleConstants.FontSize)){
                        if(fe==null){
                            // font element required
                            fe=new ipsk.db.speech.Font();
                        }
                        FontSize fs=(FontSize) attrSet.getAttribute(PromptStyledDocument.STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE);
                        if(fs!=null) {
                        	fe.setSize(fs.toString());
                        }else {
                        	Object fsAttr=attrSet.getAttribute(StyleConstants.FontSize);
                        	String fsSizeStr=fsAttr.toString();
                        	fe.setSize(fsSizeStr);
                        }
                    }
    				
    				String decoration=null;
    				
    				if(attrSet.isDefined(StyleConstants.StrikeThrough)){
    				    Object stAttr=attrSet.getAttribute(StyleConstants.StrikeThrough);
                        if(Boolean.TRUE.equals(stAttr)){
                            decoration=Text.LINE_THROUGH;
                        }
                    }
    				
    				if(decoration==null && attrSet.isDefined(StyleConstants.Underline)){
    				    Object ulAttr=attrSet.getAttribute(StyleConstants.Underline);
                        if(Boolean.TRUE.equals(ulAttr)){
                            decoration=Text.UNDERLINE;
                        }
                    }
    				te.setDecoration(decoration);
    				
    				if(attrSet.isDefined(StyleConstants.Foreground)){
    				    Object cAttr=attrSet.getAttribute(StyleConstants.Foreground);
    				    if(cAttr instanceof Color){
    				        Color c=(Color)cAttr;
    				        te.setColor(ColorUtils.colorToString(c));
    				    }
    				}
    				
    				if(fe!=null){
    					fe.setText(te);
    				}
    				

    				if(pChE instanceof LeafElement){

    					// get the text of the range
    					LeafElement le=(LeafElement)pChE;
    					int st=le.getStartOffset();
    					int en=le.getEndOffset();
    					String str;
    					try {
    					    str = getText(st,en-st);
    					    if(en==pe.getEndOffset()){
    					        // remove implied new line
    					        str=str.replaceFirst("\n$","");
    					    }
    					    if(str.length()>0){
    					        te.setText(str);
    					        if(fe!=null){
    					            p.getTexts().add(fe);
    					        }else{
    					            p.getTexts().add(te);
    					        }
    					    }
    					} catch (BadLocationException e) {
    						// TODO Auto-generated catch block
    						e.printStackTrace();
    					}

    				}

    			}
    			
    		}
    	}
    	readUnlock();
    	return prParagraphs;
    }


}
