/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

public abstract class ByteOrder {
    public static String bytes2HexString(byte[] inBytes, int from, int to) {
        StringBuffer sb = new StringBuffer("");
        int i = from;
        while (i < to) {
            String tmpHexString = Integer.toHexString(inBytes[i]);
            if (tmpHexString.length() < 2) {
                sb.append("0" + tmpHexString);
            } else if (tmpHexString.length() > 2) {
                int l = tmpHexString.length();
                sb.append(tmpHexString.substring(l - 2, l));
            } else {
                sb.append(tmpHexString);
            }
            ++i;
        }
        return sb.toString();
    }

    public static int bytes2int(byte[] inBytes, int from, int to) {
        int x = 0;
        int i = to - 1;
        while (i > from) {
            x |= 0xFF & inBytes[i];
            x <<= 8;
            --i;
        }
        return x |= 0xFF & inBytes[from];
    }

    public static String bytes2String(byte[] inBytes, int from, int to) {
        StringBuffer sb = new StringBuffer("");
        int i = from;
        while (i < to) {
            sb.append((char)inBytes[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String reverseHexCode(String inString) {
        StringBuffer isb = new StringBuffer(inString);
        if (isb.length() % 2 != 0) {
            isb.insert(0, '0');
        }
        StringBuffer sb = new StringBuffer("");
        int i = isb.length() - 1;
        while (i > 0) {
            sb.append("" + isb.charAt(i - 1) + isb.charAt(i));
            i -= 2;
        }
        return sb.toString();
    }

    public static byte[] int2RevBytes(int inValue) {
        byte[] revBytes = new byte[4];
        revBytes[3] = (byte)(inValue >> 24 & 0xFF);
        revBytes[2] = (byte)(inValue >> 16 & 0xFF);
        revBytes[1] = (byte)(inValue >> 8 & 0xFF);
        revBytes[0] = (byte)(inValue & 0xFF);
        return revBytes;
    }

    public static byte[] short2RevBytes(short inValue) {
        byte[] revBytes = new byte[2];
        revBytes[1] = (byte)(inValue >> 8 & 0xFF);
        revBytes[0] = (byte)(inValue & 0xFF);
        return revBytes;
    }

    public static void main(String[] args) {
        int x = Integer.parseInt(args[0]);
        String lowEndian = Integer.toHexString(x);
        String highEndian = ByteOrder.reverseHexCode(lowEndian);
        int y = Integer.parseInt(highEndian, 16);
        System.out.println("x, lowEndian: " + x + ", " + lowEndian);
        System.out.println("y, highEndian: " + y + ", " + highEndian);
    }
}

