/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import java.util.Locale;

public abstract class MIMETypes {
    public static final String PLAINTEXTMIMETYPE = "text/plain";
    public static final String FORMATTEDPROMPTTEXTMIMETYPE = "text/x-prompt";
    public static final String[] PLAINTEXTMIMETYPES = new String[]{"text/plain"};
    public static final String[] FALSE_PLAINTEXTMIMETYPES = new String[]{"text/UTF-8", "text/ISO-8859-1"};
    public static final String[] FORMATTEDTEXTMIMETYPES = new String[]{"text/html", "text/rtf"};
    public static final String[] IMAGEMIMETYPES = new String[]{"image/gif", "image/jpeg", "image/png"};
    public static final String[] AUDIOMIMETYPES = new String[]{"audio/wav", "audio/x-wav", "audio/wave", "audio/x-wave", "audio/vnd.wave", "audio/aif", "audio/basic"};

    public static boolean isOfType(String mime, String[] givenMIMETypes) {
        boolean isEqual = false;
        int i = 0;
        while (i < givenMIMETypes.length && !isEqual) {
            isEqual = mime.toLowerCase(Locale.ENGLISH).equals(givenMIMETypes[i].toLowerCase(Locale.ENGLISH));
            ++i;
        }
        return isEqual;
    }

    public static String getType(String mime) {
        String majorTypeStr = mime.substring(0, mime.indexOf("/"));
        if (majorTypeStr != null) {
            return majorTypeStr.trim();
        }
        return null;
    }

    public static boolean isTextType(String mime) {
        String mimeMajorType = MIMETypes.getType(mime);
        return mimeMajorType.equalsIgnoreCase("text");
    }

    public static boolean isMediaType(String mime) {
        String mimeMajorType = MIMETypes.getType(mime);
        return mimeMajorType.startsWith("image") || mimeMajorType.startsWith("audio") || mimeMajorType.startsWith("video");
    }

    public static String getDescription(String mime) {
        return mime.substring(mime.indexOf("/") + 1, mime.length());
    }

    public static String[] getAllMimeTypes() {
        String[] allTypes = new String[1 + FORMATTEDTEXTMIMETYPES.length + IMAGEMIMETYPES.length + AUDIOMIMETYPES.length];
        int offset = 0;
        allTypes[offset] = PLAINTEXTMIMETYPE;
        ++offset;
        int i = 0;
        while (i < FORMATTEDTEXTMIMETYPES.length) {
            allTypes[i + offset] = FORMATTEDTEXTMIMETYPES[i];
            ++i;
        }
        offset += FORMATTEDTEXTMIMETYPES.length;
        i = 0;
        while (i < IMAGEMIMETYPES.length) {
            allTypes[i + offset] = IMAGEMIMETYPES[i];
            ++i;
        }
        offset += IMAGEMIMETYPES.length;
        i = 0;
        while (i < AUDIOMIMETYPES.length) {
            allTypes[i + offset] = AUDIOMIMETYPES[i];
            ++i;
        }
        return allTypes;
    }
}

