/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ipsk.apps.speechrecorder.RecObserver;
import ipsk.apps.speechrecorder.SpeechRecorder;
import ipsk.apps.speechrecorder.UIResources;
import ipsk.apps.speechrecorder.session.action.RecTransporterActions;
import java.awt.GridLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class RecTransporter
extends JPanel
implements RecObserver,
KeyEventDispatcher {
    private static final long serialVersionUID = 8217409677981575042L;
    private JButton recButton;
    private boolean showRecStartAction = true;
    private boolean showRecStopAction = true;
    private JButton backButton;
    private JButton forwardButton;
    private JButton advanceToNextButton;
    private JButton pauseButton;
    private JButton playButton;
    private JButton playPauseButton;
    private JButton[] enumAnnotationButtons;
    private JLabel fileLabel;
    private final String startLabel;
    private final String stopLabel;
    private final String stopAndNextLabel;
    private UIResources uiString = null;
    private Border eb;
    private String itemCode;
    private boolean speakerAddressed = false;
    private boolean autoRecording = false;
    private boolean started = false;
    private InputMap keyMap = new InputMap();
    private boolean consumeAllKeys;
    private RecTransporterActions rta;
    private boolean listening = false;
    private boolean annotationMode = false;
    private boolean playbackEnabled = false;
    private boolean progressPaused = true;

    public RecTransporter(RecTransporterActions recTransporterActions, boolean speakerAddressed) {
        this.rta = recTransporterActions;
        this.speakerAddressed = speakerAddressed;
        this.uiString = UIResources.getInstance();
        this.startLabel = this.uiString.getString("StartButtonText");
        this.stopLabel = this.uiString.getString("StopButtonText");
        this.stopAndNextLabel = this.uiString.getString("StopAndNextButtonText");
        this.fileLabel = new JLabel("---");
        this.fileLabel.setHorizontalAlignment(0);
        this.backButton = new JButton(this.rta.backwardAction);
        this.backButton.setToolTipText(null);
        this.forwardButton = new JButton(this.rta.forwardAction);
        this.forwardButton.setToolTipText(null);
        this.advanceToNextButton = new JButton(this.rta.advanceToNextAction);
        this.advanceToNextButton.setToolTipText(null);
        this.pauseButton = new JButton(this.rta.pauseAutoRecordingAction);
        this.pauseButton.setToolTipText(null);
        this.rta.startRecordAction = recTransporterActions.startRecordAction;
        this.rta.stopRecordAction = recTransporterActions.stopRecordAction;
        this.recButton = new JButton(this.rta.startRecordAction);
        this.recButton.setToolTipText(null);
        this.playButton = new JButton((Action)((Object)this.rta.startPlaybackAction));
        this.playButton.setToolTipText(null);
        this.playPauseButton = new JButton(this.rta.pausePlaybackAction);
        this.playPauseButton.setToolTipText(null);
        if (this.rta.annotationActions != null) {
            this.enumAnnotationButtons = new JButton[this.rta.annotationActions.length];
            int i = 0;
            while (i < this.rta.annotationActions.length) {
                this.enumAnnotationButtons[i] = new JButton(this.rta.annotationActions[i]);
                ++i;
            }
        }
        this.eb = BorderFactory.createEmptyBorder(4, 10, 4, 10);
        this.setBorder(this.eb);
        this.create();
        this.disableAll();
    }

    public RecTransporter(SpeechRecorder speechrecorder, RecTransporterActions actions) {
        this(actions, false);
    }

    private void setButtActionClearToolTip(JButton butt, Action action) {
        butt.setAction(action);
        butt.setToolTipText(null);
    }

    public void setKeyButtonBindingEnabled(boolean enabled) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (enabled && this.keyMap.size() > 0) {
            if (!this.listening) {
                kfm.addKeyEventDispatcher(this);
            }
            this.listening = true;
        } else {
            kfm.removeKeyEventDispatcher(this);
            this.listening = false;
        }
    }

    private void create() {
        this.started = false;
        GridLayout layout = new GridLayout();
        layout.setHgap(2);
        layout.setVgap(2);
        this.setLayout(layout);
        this.removeAll();
        if (!this.speakerAddressed) {
            this.add(this.fileLabel);
            if (this.annotationMode) {
                if (this.enumAnnotationButtons == null) {
                    this.enumAnnotationButtons = new JButton[this.rta.annotationActions.length];
                    int i = 0;
                    while (i < this.rta.annotationActions.length) {
                        this.enumAnnotationButtons[i] = new JButton(this.rta.annotationActions[i]);
                        ++i;
                    }
                }
                JButton[] jButtonArray = this.enumAnnotationButtons;
                int n = this.enumAnnotationButtons.length;
                int n2 = 0;
                while (n2 < n) {
                    JButton ab = jButtonArray[n2];
                    this.add(ab);
                    ++n2;
                }
            } else {
                this.add(this.backButton);
                this.add(this.recButton);
                this.add(this.forwardButton);
                this.add(this.advanceToNextButton);
                if (this.autoRecording) {
                    this.add(this.pauseButton);
                }
            }
            this.add(this.playButton);
            this.add(this.playPauseButton);
        } else {
            if (this.showRecStartAction || this.showRecStopAction) {
                this.add(this.recButton);
            }
            if (this.autoRecording) {
                this.setButtActionClearToolTip(this.pauseButton, this.rta.startAutoRecordingAction);
                this.add(this.pauseButton);
            }
        }
    }

    private void switchMode(boolean annotate) {
        if (this.annotationMode != annotate) {
            this.annotationMode = annotate;
            this.create();
            this.revalidate();
            this.repaint();
        }
    }

    private void setAnnotationActionsEnabled(boolean enabled) {
        if (this.rta.annotationActions != null) {
            Action[] actionArray = this.rta.annotationActions;
            int n = this.rta.annotationActions.length;
            int n2 = 0;
            while (n2 < n) {
                Action annoAction = actionArray[n2];
                annoAction.setEnabled(enabled);
                ++n2;
            }
        }
    }

    @Override
    public void update(int status) {
        if (status == 0) {
            this.disableAll();
            this.started = false;
            return;
        }
        if (status == 18) {
            this.close();
            return;
        }
        if (status == 1) {
            this.switchMode(false);
            this.setAutoRecording(this.autoRecording);
            this.rta.stopRecordAction.setEnabled(false);
            this.setButtActionClearToolTip(this.recButton, this.rta.startRecordAction);
            this.rta.startRecordAction.setEnabled(true);
            this.recButton.setVisible(this.showRecStartAction);
            if (this.autoRecording) {
                this.rta.pauseAutoRecordingAction.setEnabled(false);
                this.rta.startRecordAction.setEnabled(false);
                if (this.progressPaused) {
                    if (this.started) {
                        this.rta.startAutoRecordingAction.setEnabled(false);
                        this.rta.continueAutoRecordingAction.setEnabled(true);
                        this.setButtActionClearToolTip(this.pauseButton, this.rta.continueAutoRecordingAction);
                    } else {
                        this.setButtActionClearToolTip(this.pauseButton, this.rta.startAutoRecordingAction);
                        this.rta.continueAutoRecordingAction.setEnabled(false);
                        this.rta.startAutoRecordingAction.setEnabled(true);
                    }
                    this.fileLabel.setEnabled(true);
                } else {
                    if (!this.started) {
                        this.setButtActionClearToolTip(this.pauseButton, this.rta.startAutoRecordingAction);
                        this.rta.startAutoRecordingAction.setEnabled(true);
                    }
                    this.fileLabel.setEnabled(true);
                }
            }
            this.rta.forwardAction.setEnabled(true);
            this.rta.advanceToNextAction.setEnabled(true);
            this.rta.backwardAction.setEnabled(true);
            this.rta.startPlaybackAction.setEnabled(this.playbackEnabled);
            this.rta.stopPlaybackAction.setEnabled(false);
            this.rta.pausePlaybackAction.setEnabled(false);
            this.setButtActionClearToolTip(this.playButton, (Action)((Object)this.rta.startPlaybackAction));
            this.rta.pausePlaybackAction.setEnabled(false);
            this.setButtActionClearToolTip(this.playPauseButton, this.rta.pausePlaybackAction);
            this.fileLabel.setEnabled(true);
            this.setAnnotationActionsEnabled(false);
        } else if (status == -2) {
            this.switchMode(false);
            this.setAutoRecording(this.autoRecording);
            this.rta.stopRecordAction.setEnabled(false);
            this.setButtActionClearToolTip(this.recButton, this.rta.startRecordAction);
            this.rta.startRecordAction.setEnabled(false);
            this.recButton.setVisible(this.showRecStartAction);
            if (this.autoRecording) {
                this.rta.pauseAutoRecordingAction.setEnabled(false);
                this.rta.startRecordAction.setEnabled(false);
                if (this.progressPaused) {
                    if (this.started) {
                        this.rta.startAutoRecordingAction.setEnabled(false);
                        this.rta.continueAutoRecordingAction.setEnabled(false);
                        this.setButtActionClearToolTip(this.pauseButton, this.rta.continueAutoRecordingAction);
                    } else {
                        this.setButtActionClearToolTip(this.pauseButton, this.rta.startAutoRecordingAction);
                        this.rta.continueAutoRecordingAction.setEnabled(false);
                        this.rta.startAutoRecordingAction.setEnabled(false);
                    }
                    this.fileLabel.setEnabled(true);
                } else {
                    if (!this.started) {
                        this.setButtActionClearToolTip(this.pauseButton, this.rta.startAutoRecordingAction);
                        this.rta.startAutoRecordingAction.setEnabled(false);
                    }
                    this.fileLabel.setEnabled(true);
                }
            }
            this.rta.forwardAction.setEnabled(true);
            this.rta.advanceToNextAction.setEnabled(true);
            this.rta.backwardAction.setEnabled(true);
            this.rta.startPlaybackAction.setEnabled(this.playbackEnabled);
            this.rta.stopPlaybackAction.setEnabled(false);
            this.rta.pausePlaybackAction.setEnabled(false);
            this.setButtActionClearToolTip(this.playButton, (Action)((Object)this.rta.startPlaybackAction));
            this.rta.pausePlaybackAction.setEnabled(false);
            this.setButtActionClearToolTip(this.playPauseButton, this.rta.pausePlaybackAction);
            this.fileLabel.setEnabled(true);
            this.setAnnotationActionsEnabled(false);
        } else if (status == 2) {
            this.switchMode(false);
            this.setAutoRecording(this.autoRecording);
            this.rta.stopRecordAction.setEnabled(false);
            this.setButtActionClearToolTip(this.recButton, this.rta.startRecordAction);
            this.rta.startRecordAction.setEnabled(false);
            this.recButton.setVisible(this.showRecStartAction);
            if (this.autoRecording) {
                this.rta.startRecordAction.setEnabled(false);
                if (this.progressPaused) {
                    if (this.started) {
                        this.rta.startAutoRecordingAction.setEnabled(false);
                        this.rta.continueAutoRecordingAction.setEnabled(true);
                        this.setButtActionClearToolTip(this.pauseButton, this.rta.continueAutoRecordingAction);
                    } else {
                        this.setButtActionClearToolTip(this.pauseButton, this.rta.startAutoRecordingAction);
                        this.rta.continueAutoRecordingAction.setEnabled(false);
                        this.rta.startAutoRecordingAction.setEnabled(true);
                    }
                    this.fileLabel.setEnabled(true);
                } else {
                    if (!this.started) {
                        this.setButtActionClearToolTip(this.pauseButton, this.rta.startAutoRecordingAction);
                        this.rta.startAutoRecordingAction.setEnabled(true);
                    }
                    this.fileLabel.setEnabled(true);
                }
            }
            this.rta.forwardAction.setEnabled(true);
            this.rta.advanceToNextAction.setEnabled(true);
            this.rta.backwardAction.setEnabled(true);
            this.rta.startPlaybackAction.setEnabled(false);
            this.rta.stopPlaybackAction.setEnabled(false);
            this.rta.pausePlaybackAction.setEnabled(false);
            this.setButtActionClearToolTip(this.playButton, (Action)((Object)this.rta.startPlaybackAction));
            this.rta.pausePlaybackAction.setEnabled(false);
            this.setButtActionClearToolTip(this.playPauseButton, this.rta.pausePlaybackAction);
            this.fileLabel.setEnabled(false);
        } else if (status == 4 || status == 3) {
            this.rta.advanceToNextAction.setEnabled(false);
            this.rta.forwardAction.setEnabled(false);
            this.rta.backwardAction.setEnabled(false);
            this.rta.startPlaybackAction.setEnabled(false);
            this.rta.stopPlaybackAction.setEnabled(false);
            this.rta.pausePlaybackAction.setEnabled(false);
        } else if (status == 6) {
            this.switchMode(false);
            this.started = true;
            this.rta.startRecordAction.setEnabled(false);
            this.rta.stopRecordAction.setEnabled(false);
            this.rta.stopNonrecordingAction.setEnabled(true);
            this.rta.forwardAction.setEnabled(false);
            this.rta.advanceToNextAction.setEnabled(false);
            this.rta.backwardAction.setEnabled(false);
            this.rta.startPlaybackAction.setEnabled(false);
            this.rta.stopPlaybackAction.setEnabled(false);
            this.rta.pausePlaybackAction.setEnabled(false);
            if (this.autoRecording) {
                this.setButtActionClearToolTip(this.recButton, this.rta.stopNonrecordingAction);
                this.rta.continueAutoRecordingAction.setEnabled(false);
                this.rta.startAutoRecordingAction.setEnabled(false);
            }
        } else if (status == 7) {
            this.switchMode(false);
            this.started = true;
            this.rta.startRecordAction.setEnabled(false);
            this.rta.stopRecordAction.setEnabled(false);
            this.rta.advanceToNextAction.setEnabled(false);
            this.rta.forwardAction.setEnabled(false);
            this.rta.backwardAction.setEnabled(false);
            this.rta.startPlaybackAction.setEnabled(false);
            this.rta.stopPlaybackAction.setEnabled(false);
            this.rta.pausePlaybackAction.setEnabled(false);
            this.recButton.setVisible(this.showRecStopAction);
            if (this.autoRecording) {
                this.rta.stopRecordAction.putValue("Name", this.stopAndNextLabel);
                this.setButtActionClearToolTip(this.recButton, this.rta.stopRecordAction);
                this.rta.pauseAutoRecordingAction.setEnabled(false);
                this.rta.continueAutoRecordingAction.setEnabled(false);
                this.rta.startAutoRecordingAction.setEnabled(false);
                this.setButtActionClearToolTip(this.pauseButton, this.rta.pauseAutoRecordingAction);
            } else {
                this.rta.stopRecordAction.putValue("Name", this.stopLabel);
                this.setButtActionClearToolTip(this.recButton, this.rta.stopRecordAction);
            }
            this.setAnnotationActionsEnabled(false);
        } else if (status == 8) {
            this.switchMode(false);
            this.rta.startRecordAction.setEnabled(false);
            this.rta.stopRecordAction.setEnabled(true);
            this.rta.forwardAction.setEnabled(false);
            this.rta.advanceToNextAction.setEnabled(false);
            this.recButton.setVisible(this.showRecStopAction);
            this.recButton.setEnabled(true);
            this.rta.backwardAction.setEnabled(false);
            this.rta.startPlaybackAction.setEnabled(false);
            this.rta.stopPlaybackAction.setEnabled(false);
            this.rta.pausePlaybackAction.setEnabled(false);
            if (this.autoRecording) {
                this.setButtActionClearToolTip(this.recButton, this.rta.stopRecordAction);
                this.rta.stopRecordAction.putValue("Name", this.stopAndNextLabel);
                this.rta.pauseAutoRecordingAction.setEnabled(true);
                this.rta.continueAutoRecordingAction.setEnabled(false);
                this.rta.startAutoRecordingAction.setEnabled(false);
                this.setButtActionClearToolTip(this.pauseButton, this.rta.pauseAutoRecordingAction);
            } else {
                this.rta.stopRecordAction.putValue("Name", this.stopLabel);
                this.setButtActionClearToolTip(this.recButton, this.rta.stopRecordAction);
            }
        } else if (status == 9) {
            this.rta.startRecordAction.setEnabled(false);
            this.rta.stopRecordAction.setEnabled(false);
            if (this.autoRecording) {
                this.setButtActionClearToolTip(this.recButton, this.rta.stopRecordAction);
                this.rta.stopRecordAction.putValue("Name", this.stopAndNextLabel);
                this.rta.pauseAutoRecordingAction.setEnabled(false);
                this.rta.continueAutoRecordingAction.setEnabled(false);
                this.rta.startAutoRecordingAction.setEnabled(false);
            } else {
                this.rta.stopRecordAction.putValue("Name", this.stopLabel);
                this.setButtActionClearToolTip(this.recButton, this.rta.stopRecordAction);
            }
            this.rta.forwardAction.setEnabled(false);
            this.rta.backwardAction.setEnabled(false);
            this.rta.startPlaybackAction.setEnabled(false);
            this.rta.stopPlaybackAction.setEnabled(false);
            this.rta.pausePlaybackAction.setEnabled(false);
            this.rta.pauseAutoRecordingAction.setEnabled(false);
        } else if (status == 11) {
            this.switchMode(true);
            this.rta.stopRecordAction.setEnabled(false);
            this.rta.startRecordAction.setEnabled(false);
            this.recButton.setVisible(false);
            this.rta.pauseAutoRecordingAction.setEnabled(false);
            this.rta.startRecordAction.setEnabled(false);
            this.rta.startAutoRecordingAction.setEnabled(false);
            this.rta.continueAutoRecordingAction.setEnabled(false);
            this.rta.continueAutoRecordingAction.setEnabled(false);
            this.rta.startAutoRecordingAction.setEnabled(false);
            this.fileLabel.setEnabled(true);
            this.rta.startAutoRecordingAction.setEnabled(false);
            this.rta.forwardAction.setEnabled(false);
            this.rta.advanceToNextAction.setEnabled(false);
            this.rta.backwardAction.setEnabled(false);
            this.rta.startPlaybackAction.setEnabled(this.playbackEnabled);
            this.rta.stopPlaybackAction.setEnabled(false);
            this.rta.pausePlaybackAction.setEnabled(false);
            this.setButtActionClearToolTip(this.playButton, (Action)((Object)this.rta.startPlaybackAction));
            this.rta.pausePlaybackAction.setEnabled(false);
            this.setButtActionClearToolTip(this.playPauseButton, this.rta.pausePlaybackAction);
            this.fileLabel.setEnabled(true);
            this.setAnnotationActionsEnabled(true);
        } else if (status == 13) {
            this.rta.startRecordAction.setEnabled(false);
            this.rta.startAutoRecordingAction.setEnabled(false);
            this.rta.continueAutoRecordingAction.setEnabled(false);
            this.recButton.setEnabled(false);
            this.rta.backwardAction.setEnabled(true);
            this.rta.forwardAction.setEnabled(true);
            this.rta.advanceToNextAction.setEnabled(true);
            this.rta.startPlaybackAction.setEnabled(false);
            this.rta.stopPlaybackAction.setEnabled(true);
            this.setButtActionClearToolTip(this.playButton, this.rta.stopPlaybackAction);
            this.rta.pausePlaybackAction.setEnabled(true);
            this.setButtActionClearToolTip(this.playPauseButton, this.rta.pausePlaybackAction);
            this.setAnnotationActionsEnabled(false);
        } else if (status == 14) {
            this.rta.startRecordAction.setEnabled(false);
            this.recButton.setEnabled(false);
            this.rta.forwardAction.setEnabled(true);
            this.rta.backwardAction.setEnabled(true);
            this.rta.startPlaybackAction.setEnabled(false);
            this.rta.stopPlaybackAction.setEnabled(true);
            this.setButtActionClearToolTip(this.playButton, this.rta.stopPlaybackAction);
            this.rta.pausePlaybackAction.setEnabled(false);
            this.rta.continuePlaybackAction.setEnabled(true);
            this.setButtActionClearToolTip(this.playPauseButton, this.rta.continuePlaybackAction);
        } else if (status == 15) {
            this.rta.startRecordAction.setEnabled(false);
            this.rta.startAutoRecordingAction.setEnabled(false);
            this.rta.continueAutoRecordingAction.setEnabled(false);
            this.recButton.setEnabled(false);
            this.rta.backwardAction.setEnabled(false);
            this.rta.forwardAction.setEnabled(false);
            this.rta.advanceToNextAction.setEnabled(false);
            this.rta.startPlaybackAction.setEnabled(false);
            this.rta.stopPlaybackAction.setEnabled(false);
            this.rta.pausePlaybackAction.setEnabled(true);
            this.setAnnotationActionsEnabled(false);
        } else if (status == 0) {
            this.rta.startRecordAction.setEnabled(true);
            this.recButton.setEnabled(true);
            this.recButton.setText(this.startLabel);
            this.recButton.setActionCommand("start");
            this.rta.forwardAction.setEnabled(false);
            this.rta.backwardAction.setEnabled(false);
            this.setButtActionClearToolTip(this.playButton, (Action)((Object)this.rta.startPlaybackAction));
            this.rta.startPlaybackAction.setEnabled(false);
            this.rta.stopPlaybackAction.setEnabled(false);
            this.rta.pausePlaybackAction.setEnabled(false);
            this.rta.continuePlaybackAction.setEnabled(false);
            this.setButtActionClearToolTip(this.playPauseButton, this.rta.pausePlaybackAction);
        } else if (status == 16) {
            this.rta.startRecordAction.setEnabled(false);
            this.setButtActionClearToolTip(this.recButton, this.rta.startRecordAction);
            this.recButton.setVisible(this.showRecStartAction);
            this.rta.forwardAction.setEnabled(false);
            this.rta.startRecordAction.setEnabled(false);
            this.rta.backwardAction.setEnabled(false);
            this.rta.startPlaybackAction.setEnabled(false);
            this.rta.stopPlaybackAction.setEnabled(false);
            this.rta.pauseAutoRecordingAction.setEnabled(false);
        }
    }

    private void disableAll() {
        this.rta.startRecordAction.setEnabled(false);
        this.rta.stopRecordAction.setEnabled(false);
        this.rta.startAutoRecordingAction.setEnabled(false);
        this.rta.continueAutoRecordingAction.setEnabled(false);
        this.rta.pauseAutoRecordingAction.setEnabled(false);
        this.rta.backwardAction.setEnabled(false);
        this.rta.continuePlaybackAction.setEnabled(false);
        this.rta.advanceToNextAction.setEnabled(false);
        this.rta.forwardAction.setEnabled(false);
        this.rta.startPlaybackAction.setEnabled(false);
        this.rta.pausePlaybackAction.setEnabled(false);
        this.rta.stopPlaybackAction.setEnabled(false);
        this.fileLabel.setText("---");
        this.fileLabel.setEnabled(false);
        this.setAnnotationActionsEnabled(false);
    }

    public boolean isAutoRecording() {
        return this.autoRecording;
    }

    public void setAutoRecording(boolean b) {
        if (b != this.autoRecording) {
            this.autoRecording = b;
            this.create();
        }
    }

    public boolean isSpeakerAddressed() {
        return this.speakerAddressed;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        Set actionSet = (Set)this.keyMap.get(KeyStroke.getKeyStrokeForEvent(e));
        if (actionSet != null) {
            for (Action action : actionSet) {
                if (!action.isEnabled()) continue;
                e.consume();
                action.actionPerformed(new ActionEvent(this, 1001, (String)action.getValue("ActionCommandKey")));
                return true;
            }
        }
        if (this.consumeAllKeys) {
            e.consume();
            return true;
        }
        return false;
    }

    public void addKeyStrokeAction(KeyStroke keyStroke, Action action) {
        if (action != null) {
            HashSet<Action> actionSet = (HashSet<Action>)this.keyMap.get(keyStroke);
            if (actionSet == null) {
                actionSet = new HashSet<Action>();
            }
            actionSet.add(action);
            this.keyMap.put(keyStroke, actionSet);
        }
    }

    public void clearActionKeyCodes() {
        this.keyMap.clear();
    }

    public boolean isConsumeAllKeys() {
        return this.consumeAllKeys;
    }

    public void setConsumeAllKeys(boolean consumeAllKeys) {
        this.consumeAllKeys = consumeAllKeys;
    }

    public void close() {
        this.disableAll();
        this.started = false;
        this.setKeyButtonBindingEnabled(false);
    }

    public boolean isShowRecStartAction() {
        return this.showRecStartAction;
    }

    public void setShowRecStartAction(boolean showRecStartAction) {
        this.showRecStartAction = showRecStartAction;
        this.create();
    }

    public boolean isShowRecStopAction() {
        return this.showRecStopAction;
    }

    public void setShowRecStopAction(boolean showRecStopAction) {
        this.showRecStopAction = showRecStopAction;
        this.create();
    }

    public String getItemCode() {
        return this.itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
        String label = "";
        if (this.itemCode != null) {
            label = this.itemCode;
        }
        this.fileLabel.setText(label);
    }

    public boolean isPlaybackEnabled() {
        return this.playbackEnabled;
    }

    public void setPlaybackEnabled(boolean playbackEnabled) {
        this.playbackEnabled = playbackEnabled;
    }

    public boolean isProgressPaused() {
        return this.progressPaused;
    }

    public void setProgressPaused(boolean progressPaused) {
        this.progressPaused = progressPaused;
    }
}

