/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ipsk.apps.speechrecorder.RecLogger;
import ipsk.apps.speechrecorder.UIResources;
import java.util.Vector;

public class Speaker {
    public static int COL_ID = 0;
    public static int COL_CODE = 1;
    public static int COL_NAME = 2;
    public static int COL_FORENAME = 3;
    public static int COL_GENDER = 4;
    public static int COL_ACCENT = 5;
    public static int COL_BIRTHDATE = 6;
    private int speakerID = 0;
    private String speakerCode;
    private String speakerName;
    private String speakerFirstName;
    private String speakerGender;
    private String speakerAccent;
    private String speakerDateOfBirth;
    private RecLogger recLog;
    private static UIResources uiString = UIResources.getInstance();

    public Speaker(int ID2) {
        this.speakerID = ID2;
    }

    public Speaker(Vector<String> spkData) {
        this.speakerID = Integer.parseInt(spkData.elementAt(0));
        this.setData(spkData);
        uiString = UIResources.getInstance();
    }

    public void setSpeaker(String code, String name, String fname, String gender, String accent, String birthdate) {
        this.setSpeakerData(COL_CODE, code);
        this.setSpeakerData(COL_NAME, name);
        this.setSpeakerData(COL_FORENAME, fname);
        this.setSpeakerData(COL_GENDER, gender);
        this.setSpeakerData(COL_ACCENT, accent);
        this.setSpeakerData(COL_BIRTHDATE, birthdate);
    }

    public Object getSpeakerData(int i) {
        if (i == 0) {
            return this.getCode();
        }
        if (i == 1) {
            return this.getName();
        }
        if (i == 2) {
            return this.getFirstName();
        }
        if (i == 3) {
            return this.getGender();
        }
        if (i == 4) {
            return this.getAccent();
        }
        if (i == 5) {
            return this.getDateOfBirth();
        }
        return null;
    }

    public void setSpeakerData(int i, Object value) {
        String tmpValue = (String)value;
        String nomalizedValue = tmpValue.trim();
        if (i == 0) {
            this.setCode(nomalizedValue);
        } else if (i == 1) {
            this.setName(nomalizedValue);
        } else if (i == 2) {
            this.setFirstName(nomalizedValue);
        } else if (i == 3) {
            this.setGender(nomalizedValue);
        } else if (i == 4) {
            this.setAccent(nomalizedValue);
        } else if (i == 5) {
            this.setDateOfBirth(nomalizedValue);
        }
    }

    public int getID() {
        return this.speakerID;
    }

    public String getCode() {
        return this.speakerCode;
    }

    public String getName() {
        return this.speakerName;
    }

    public String getFirstName() {
        return this.speakerFirstName;
    }

    public String getGender() {
        return this.speakerGender;
    }

    public String getAccent() {
        return this.speakerAccent;
    }

    public String getDateOfBirth() {
        return this.speakerDateOfBirth;
    }

    public void setCode(String code) {
        this.speakerCode = code == null ? code : code.toUpperCase();
    }

    public void setName(String name) {
        this.speakerName = name;
    }

    public void setFirstName(String fname) {
        this.speakerFirstName = fname;
    }

    public void setGender(String gender) {
        this.speakerGender = gender;
    }

    public void setAccent(String accent) {
        this.speakerAccent = accent;
    }

    public void setDateOfBirth(String date) {
        this.speakerDateOfBirth = date;
    }

    public String toString() {
        String s = new String();
        String code = this.getCode();
        if (code != null) {
            s = s.concat(String.valueOf(this.getCode()) + "\t");
        }
        s = s.concat(String.valueOf(this.getName()) + "\t" + this.getFirstName() + "\t" + this.getGender() + "\t" + this.getAccent() + "\t" + this.getDateOfBirth());
        return s;
    }

    public static final Vector<String> getDescription() {
        Vector<String> v = new Vector<String>(7);
        v.addElement("ID");
        v.addElement(uiString.getString("SpeakerCode"));
        v.addElement(uiString.getString("SpeakerName"));
        v.addElement(uiString.getString("SpeakerFirstName"));
        v.addElement(uiString.getString("SpeakerGender"));
        v.addElement(uiString.getString("SpeakerAccent"));
        v.addElement(uiString.getString("SpeakerDateOfBirth"));
        return v;
    }

    public Vector<String> getData() {
        Vector<String> v = new Vector<String>(7);
        v.addElement(Integer.toString(this.getID()));
        v.addElement(this.getCode());
        v.addElement(this.getName());
        v.addElement(this.getFirstName());
        v.addElement(this.getGender());
        v.addElement(this.getAccent());
        v.addElement(this.getDateOfBirth());
        return v;
    }

    public void setData(Vector<String> spkData) {
        int i = 0;
        while (i < spkData.size()) {
            this.setSpeakerData(i, spkData.elementAt(i));
            ++i;
        }
    }

    public void setLogEntries() {
        this.recLog.setLogEntry("SCD: ", String.valueOf(this.getID()));
        this.recLog.setLogEntry("AGE: ", this.getDateOfBirth());
        this.recLog.setLogEntry("ACC: ", this.getAccent());
        this.recLog.setLogEntry("SEX: ", this.getGender());
    }
}

